/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui;

import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.ui.CoserFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SelectionsListMenu
extends JMenu
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -3528302058982208907L;
    private static final Log log = LogFactory.getLog(SelectionsListMenu.class);
    protected CoserFrame view;
    protected Project project;

    public SelectionsListMenu(CoserFrame view) {
        this.view = view;
        this.updateMenuContent();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        if (this.project != null) {
            this.project.removePropertyChangeListener("selections", (PropertyChangeListener)this);
            this.project.getControl().removePropertyChangeListener("validated", (PropertyChangeListener)this);
        }
        this.project = project;
        if (this.project != null) {
            this.project.addPropertyChangeListener("selections", (PropertyChangeListener)this);
            this.project.getControl().addPropertyChangeListener("validated", (PropertyChangeListener)this);
        }
        this.updateMenuContent();
    }

    protected void updateMenuContent() {
        this.removeAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Refresh selection menu items");
        }
        if (this.project != null) {
            if (!this.project.getControl().isValidated()) {
                JMenuItem menuItem = new JMenuItem(I18n.t((String)"coser.ui.mainframe.menu.data.noValidation", (Object[])new Object[0]));
                menuItem.setFont(menuItem.getFont().deriveFont(2));
                menuItem.setEnabled(false);
                this.add(menuItem);
            } else {
                Map selections = this.project.getSelections();
                if (selections == null || selections.isEmpty()) {
                    JMenuItem menuItem = new JMenuItem(I18n.t((String)"coser.ui.mainframe.menu.data.noSelection", (Object[])new Object[0]));
                    menuItem.setFont(menuItem.getFont().deriveFont(2));
                    menuItem.setEnabled(false);
                    this.add(menuItem);
                } else {
                    for (String selectionName : selections.keySet()) {
                        JMenuItem menuItem = new JMenuItem(selectionName);
                        menuItem.setActionCommand(selectionName);
                        menuItem.addActionListener(this);
                        this.add(menuItem);
                    }
                }
                this.add(new JSeparator());
                JMenuItem newMenuItem = new JMenuItem(I18n.t((String)"coser.ui.mainframe.menu.data.newSelection", (Object[])new Object[0]));
                newMenuItem.setActionCommand("$new selection$");
                newMenuItem.addActionListener(this);
                this.add(newMenuItem);
                JMenuItem replayMenuItem = new JMenuItem(I18n.t((String)"coser.ui.mainframe.menu.data.replaySelection", (Object[])new Object[0]));
                replayMenuItem.setActionCommand("$replay selection$");
                replayMenuItem.addActionListener(this);
                this.add(replayMenuItem);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        if ("$new selection$".equals(actionCommand)) {
            this.view.getHandler().showSelectionView();
        } else if ("$replay selection$".equals(actionCommand)) {
            this.view.getHandler().replaySelection();
        } else {
            this.view.getHandler().showSelectionView(actionCommand);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateMenuContent();
    }
}

