/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.publication;

import com.google.common.collect.Lists;
import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConfig;
import fr.ifremer.coser.CoserException;
import fr.ifremer.coser.bean.GlobalResult;
import fr.ifremer.coser.services.ClientResultService;
import fr.ifremer.coser.ui.common.CommonHandler;
import fr.ifremer.coser.ui.publication.ExportUploadDialog;
import fr.ifremer.coser.ui.publication.GlobalResultRenderer;
import fr.ifremer.coser.ui.publication.GlobalResultZoneRenderer;
import fr.ifremer.coser.ui.publication.SelectUploadResultView;
import fr.ifremer.coser.ui.util.CoserProgressBar;
import fr.ifremer.coser.ui.util.ErrorHelper;
import fr.ifremer.coser.util.ProgressMonitor;
import java.awt.Component;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import jaxx.runtime.JAXXContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class GlobalResultHandler
extends CommonHandler {
    public void init(SelectUploadResultView view) {
        view.getAvailableResultTable().setDefaultRenderer(String[].class, new GlobalResultRenderer());
        view.getSelectedResultTable().setDefaultRenderer(String[].class, new GlobalResultRenderer());
        view.getAvailableResultTable().setDefaultRenderer(String.class, new GlobalResultZoneRenderer(view));
        view.getSelectedResultTable().setDefaultRenderer(String.class, new GlobalResultZoneRenderer(view));
        this.updateAvailableResultsFilter(view);
        view.getSelectedResultTableModel().setResultPaths(Lists.newArrayList());
    }

    public void updateAvailableResultsFilter(SelectUploadResultView view) {
        Date beginDate = view.getFilterBeginDate().getDate();
        Date endDate = view.getFilterEndDate().getDate();
        boolean onlyPubliable = view.getPubliableResults().isSelected();
        ClientResultService webService = view.getContextValue(ClientResultService.class);
        try {
            List results = webService.findAllProjectWithResult(beginDate, endDate, onlyPubliable);
            view.getAvailableResultTableModel().setResultPaths(results);
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't get results", ex);
        }
    }

    public void addAvailableResult(SelectUploadResultView view) {
        int[] selectedAvailableRows;
        List<GlobalResult> currentResult = view.getSelectedResultTableModel().getResultPaths();
        for (int selectedAvailableRow : selectedAvailableRows = view.getAvailableResultTable().getSelectedRows()) {
            GlobalResult resultData = view.getAvailableResultTableModel().getResultPaths().get(selectedAvailableRow);
            if (currentResult.contains(resultData)) continue;
            currentResult.add(resultData);
            view.getSelectedResultTableModel().getIndicatorResults().add(resultData);
            if (!resultData.isEchoBase()) continue;
            view.getSelectedResultTableModel().getMapResults().add(resultData);
            view.getSelectedResultTableModel().getPublishDataResults().add(resultData);
        }
        view.getSelectedResultTableModel().setResultPaths(currentResult);
    }

    public void removeSelectedResult(SelectUploadResultView view) {
        List<GlobalResult> currentResult = view.getSelectedResultTableModel().getResultPaths();
        int[] selectedSelectedRows = view.getSelectedResultTable().getSelectedRows();
        for (int index = selectedSelectedRows.length - 1; index >= 0; --index) {
            int selectedSelectedRow = selectedSelectedRows[index];
            currentResult.remove(selectedSelectedRow);
        }
        view.getSelectedResultTableModel().setResultPaths(currentResult);
    }

    public void performUploadResult(final ExportUploadDialog view) {
        final String login = view.getUploadLogintextField().getText();
        final String password = new String(view.getUploadPasswordtextField().getPassword());
        SelectUploadResultView parentView = view.getContextValue(SelectUploadResultView.class, "parent");
        final List<GlobalResult> selectedResults = parentView.getSelectedResultTableModel().getResultPaths();
        final Set<GlobalResult> indicatorResults = parentView.getSelectedResultTableModel().getIndicatorResults();
        final Set<GlobalResult> mapResults = parentView.getSelectedResultTableModel().getMapResults();
        final Set<GlobalResult> publishDataResults = parentView.getSelectedResultTableModel().getPublishDataResults();
        if (CollectionUtils.isNotEmpty(selectedResults)) {
            SwingWorker<String, Void> task = new SwingWorker<String, Void>(){

                @Override
                protected String doInBackground() {
                    try {
                        GlobalResultHandler.this.setWaitCursor(view);
                        CoserProgressBar progressBar = view.getUploadProgressBar();
                        ClientResultService webService = view.getContextValue(ClientResultService.class);
                        String status = webService.performResultUpload(selectedResults, indicatorResults, mapResults, publishDataResults, login, password, (ProgressMonitor)progressBar);
                        return status;
                    }
                    catch (CoserBusinessException ex) {
                        throw new CoserException(ex.getMessage(), ex);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    try {
                        String status = (String)this.get();
                        if (StringUtils.isNotEmpty((CharSequence)status)) {
                            JOptionPane.showMessageDialog(view, I18n.t((String)"coser.ui.uploadresult.resultsuploaderror", (Object[])new Object[]{status}), I18n.t((String)"coser.ui.uploadresult.title", (Object[])new Object[0]), 0);
                        } else {
                            JOptionPane.showMessageDialog(view, I18n.t((String)"coser.ui.uploadresult.resultsuploaded", (Object[])new Object[0]), I18n.t((String)"coser.ui.uploadresult.title", (Object[])new Object[0]), 1);
                        }
                        view.dispose();
                    }
                    catch (Exception ex) {
                        ErrorHelper errorHelper = new ErrorHelper();
                        errorHelper.showErrorDialog(view, ex.getMessage(), ex);
                    }
                    finally {
                        GlobalResultHandler.this.setDefaultCursor(view);
                    }
                }
            };
            task.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performExtractResult(ExportUploadDialog view) {
        String extractPath = view.getExtractToTextField().getText();
        File extractDirectory = new File(extractPath);
        SelectUploadResultView parentView = view.getContextValue(SelectUploadResultView.class, "parent");
        List<GlobalResult> selectedResult = parentView.getSelectedResultTableModel().getResultPaths();
        Set<GlobalResult> publishDataResults = parentView.getSelectedResultTableModel().getPublishDataResults();
        ClientResultService webService = view.getContextValue(ClientResultService.class);
        try {
            this.setWaitCursor(view);
            webService.performResultExtract(selectedResult, publishDataResults, extractDirectory);
            JOptionPane.showMessageDialog(view, I18n.t((String)"coser.ui.uploadresult.resultsextracted", (Object[])new Object[0]), I18n.t((String)"coser.ui.uploadresult.title", (Object[])new Object[0]), 1);
            view.dispose();
        }
        finally {
            this.setDefaultCursor(view);
        }
    }

    public void showExportUploadDialog(SelectUploadResultView view) {
        ExportUploadDialog dialog = new ExportUploadDialog((JAXXContext)view);
        dialog.setLocationRelativeTo((Component)((Object)view));
        dialog.setVisible(true);
    }

    public void selectExportDirectory(ExportUploadDialog view, JTextField textComponent) {
        CoserConfig config = view.getContextValue(CoserConfig.class);
        JFileChooser selectFileChooser = this.getFileChooserInstance(config.getProjectsDirectory());
        selectFileChooser.setFileSelectionMode(1);
        int result = selectFileChooser.showOpenDialog(view);
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            textComponent.setText(selectedFile.getAbsolutePath());
        }
    }
}

