/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.publication;

import com.google.common.collect.Sets;
import fr.ifremer.coser.bean.GlobalResult;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.nuiton.i18n.I18n;

public class GlobalResultTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected List<GlobalResult> resultPaths;
    protected Set<GlobalResult> indicatorResults;
    protected Set<GlobalResult> mapResults;
    protected Set<GlobalResult> publishDataResults;
    protected boolean selected;

    public GlobalResultTableModel(boolean selected) {
        this.selected = selected;
        this.indicatorResults = Sets.newHashSet();
        this.mapResults = Sets.newHashSet();
        this.publishDataResults = Sets.newHashSet();
    }

    public void setResultPaths(List<GlobalResult> resultPaths) {
        this.resultPaths = resultPaths;
        this.fireTableDataChanged();
    }

    public List<GlobalResult> getResultPaths() {
        return this.resultPaths;
    }

    public Set<GlobalResult> getIndicatorResults() {
        return this.indicatorResults;
    }

    public Set<GlobalResult> getMapResults() {
        return this.mapResults;
    }

    public Set<GlobalResult> getPublishDataResults() {
        return this.publishDataResults;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.resultPaths != null) {
            result = this.resultPaths.size();
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = null;
        switch (column) {
            case 0: {
                result = I18n.t((String)"coser.ui.uploadresult.resultType", (Object[])new Object[0]);
                break;
            }
            case 1: {
                result = I18n.t((String)"coser.ui.uploadresult.creationDate", (Object[])new Object[0]);
                break;
            }
            case 2: {
                result = I18n.t((String)"coser.ui.uploadresult.path", (Object[])new Object[0]);
                break;
            }
            case 3: {
                result = I18n.t((String)"coser.ui.uploadresult.zone", (Object[])new Object[0]);
                break;
            }
            case 4: {
                result = I18n.t((String)"coser.ui.uploadresult.indicatorResult", (Object[])new Object[0]);
                break;
            }
            case 5: {
                result = I18n.t((String)"coser.ui.uploadresult.mapResult", (Object[])new Object[0]);
                break;
            }
            case 6: {
                result = I18n.t((String)"coser.ui.uploadresult.publishData", (Object[])new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class result = null;
        switch (columnIndex) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = Date.class;
                break;
            }
            case 2: {
                result = String[].class;
                break;
            }
            case 3: {
                result = String.class;
                break;
            }
            case 4: {
                result = Boolean.class;
                break;
            }
            case 5: {
                result = Boolean.class;
                break;
            }
            case 6: {
                result = Boolean.class;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        int result = 4;
        if (this.selected) {
            result = 7;
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        GlobalResult data = this.resultPaths.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = data.isRsufi() ? "RSufi" : "EchoBase";
                break;
            }
            case 1: {
                result = data.getCreationDate();
                break;
            }
            case 2: {
                result = data;
                break;
            }
            case 3: {
                result = data.getZone();
                break;
            }
            case 4: {
                result = this.indicatorResults.contains(data);
                break;
            }
            case 5: {
                result = this.mapResults.contains(data);
                break;
            }
            case 6: {
                result = this.publishDataResults.contains(data);
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        GlobalResult data = this.resultPaths.get(rowIndex);
        boolean editable = !data.isEchoBase() && columnIndex >= 4;
        return editable;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        GlobalResult data = this.resultPaths.get(rowIndex);
        if (columnIndex == 4) {
            Boolean bValue = (Boolean)aValue;
            if (bValue.booleanValue()) {
                this.indicatorResults.add(data);
            } else {
                this.indicatorResults.remove(data);
            }
        } else if (columnIndex == 5) {
            Boolean bValue = (Boolean)aValue;
            if (bValue.booleanValue()) {
                this.mapResults.add(data);
            } else {
                this.mapResults.remove(data);
            }
        } else if (columnIndex == 6) {
            Boolean bValue = (Boolean)aValue;
            if (bValue.booleanValue()) {
                this.publishDataResults.add(data);
            } else {
                this.publishDataResults.remove(data);
            }
        }
    }
}

