/*
 * #%L
 * $Id: ZoneComboBoxModel.java 632 2011-02-01 13:19:15Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.3/coser-ui/src/main/java/fr/ifremer/coser/ui/result/ZoneComboBoxModel.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.result;

import javax.swing.DefaultComboBoxModel;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.storage.DataStorage;

/**
 * Zone combo box model.
 * Contains zone list defined in "matchzone" file common to web side and client
 * side.
 * 
 * @author chatellier
 * @version $Revision: 632 $
 * 
 * Last update : $Date: 2011-02-01 14:19:15 +0100 (mar. 01 févr. 2011) $
 * By : $Author: chatellier $
 */
public class ZoneComboBoxModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4452070553401468762L;

    protected DataStorage zonesMap;

    public ZoneComboBoxModel(WebService webService) {
        try {
            zonesMap = webService.getZonesMap();
        } catch (CoserBusinessException ex) {
            throw new CoserException("Can't get zone list", ex);
        }
    }

    @Override
    public int getSize() {
        // -1 for header
        return zonesMap.size() - 1;
    }

    @Override
    public Object getElementAt(int index) {
        // "id";"facadeid";"facade";"zone";"periode";"serie";"comment";"map"
        // +1 for header
        return zonesMap.get(index + 1)[0];
    }

    public String[] getZone(String zoneId) {
        int index = zonesMap.indexOf(zoneId);
        String[] result = null;
        if (index != -1) {
            result = zonesMap.get(index);
        }
        return result;
    }
}
