/*
 * #%L
 * $Id: ZoneComboBoxRenderer.java 632 2011-02-01 13:19:15Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.2.2/coser-ui/src/main/java/fr/ifremer/coser/ui/result/ZoneComboBoxRenderer.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser.ui.result;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

/**
 * Zone list combo renderer (display zone name for zone id).
 * 
 * @author chatellier
 * @version $Revision: 632 $
 * 
 * Last update : $Date: 2011-02-01 14:19:15 +0100 (Tue, 01 Feb 2011) $
 * By : $Author: chatellier $
 */
public class ZoneComboBoxRenderer extends DefaultListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -8231189755539976714L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        String zoneId = (String)value;
        ZoneComboBoxModel model = (ZoneComboBoxModel)list.getModel();

        // "id";"facadeid";"facade";"zone";"periode";"serie";"comment";"map"
        String[] zoneData = model.getZone(zoneId);
        String zoneName = null;
        if (zoneData != null) {
            // le surveyName ne sert à rien
            // mais est la a titre d'information par rapport
            // à l'affichage cote web
            zoneName = zoneData[2] + " - " + zoneData[3] + " - " + zoneData[4] + " - " + zoneData[5];
        }
        else {
            zoneName = zoneId;
        }
        return super.getListCellRendererComponent(list, zoneName, index, isSelected,
                cellHasFocus);
    }
}
