/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser;

import com.bbn.openmap.MapBean;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserClassLoader;
import fr.ifremer.coser.CoserConfig;
import fr.ifremer.coser.services.CommandService;
import fr.ifremer.coser.services.ControlService;
import fr.ifremer.coser.services.ImportService;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.services.PublicationService;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.ui.CoserFrame;
import fr.ifremer.coser.ui.util.ErrorHelper;
import java.awt.Component;
import java.io.File;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.widget.SwingSession;

public class Coser {
    private static final Log log = LogFactory.getLog(Coser.class);

    public static void main(String ... args) {
        CoserConfig coserConfig;
        block2: {
            coserConfig = new CoserConfig();
            try {
                coserConfig.parse(args);
            }
            catch (ArgumentsParserException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Cant' parse configuration", (Throwable)ex);
            }
        }
        MapBean.suppressCopyright = true;
        Coser.launch(coserConfig);
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Global application exception", ex);
                }
                ErrorHelper errorHelper = new ErrorHelper(coserConfig);
                errorHelper.showErrorDialog(null, ex.getMessage(), ex);
            }
        });
    }

    public static void launch(final CoserConfig coserConfig) {
        I18n.init((I18nInitializer)new DefaultI18nInitializer("coser-ui-i18n"), (Locale)coserConfig.getLocale());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block3: {
                    ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                    CoserClassLoader coserClassLoader = new CoserClassLoader(currentClassLoader);
                    Thread.currentThread().setContextClassLoader((ClassLoader)coserClassLoader);
                    coserClassLoader.setValidatorsDirectory(coserConfig.getValidatorsDirectory());
                    try {
                        String lafClassName = coserConfig.getLookAndFeel();
                        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                            if (!laf.getClassName().equalsIgnoreCase(lafClassName)) continue;
                            UIManager.setLookAndFeel(laf.getClassName());
                        }
                    }
                    catch (Exception ex) {
                        if (!log.isErrorEnabled()) break block3;
                        log.error((Object)"Can't init look and feel", (Throwable)ex);
                    }
                }
                coserConfig.updateSwingFont();
                File coserConfigDirectory = new File(coserConfig.getUserConfigDirectory(), "coser");
                coserConfigDirectory.mkdirs();
                File mainFrameFile = new File(coserConfigDirectory, "session.xml");
                SwingSession session = new SwingSession(mainFrameFile, true);
                DefaultApplicationContext context = new DefaultApplicationContext();
                context.setContextValue((Object)coserConfig);
                context.setContextValue((Object)session);
                context.setContextValue((Object)new ProjectService((CoserBusinessConfig)coserConfig));
                context.setContextValue((Object)new ImportService((CoserBusinessConfig)coserConfig));
                context.setContextValue((Object)new CommandService((CoserBusinessConfig)coserConfig));
                context.setContextValue((Object)new ControlService((CoserBusinessConfig)coserConfig));
                context.setContextValue((Object)new PublicationService((CoserBusinessConfig)coserConfig));
                context.setContextValue((Object)new WebService((CoserBusinessConfig)coserConfig));
                CoserFrame frame = new CoserFrame((JAXXContext)context);
                frame.setLocationRelativeTo(null);
                session.add((Component)frame);
                frame.setVisible(true);
            }
        });
    }
}

