/*
 * #%L
 * Coser :: UI
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.coser.ui.selection;

import fr.ifremer.coser.ui.selection.*;
import fr.ifremer.coser.ui.selection.model.*;
import fr.ifremer.coser.ui.util.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class SelectionListsView extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTION = "selection";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ALL_SPECIES_COMMENT_FIELD_TEXT = "allSpeciesCommentField.text";
    public static final String BINDING_MATURITY_COMMENT_FIELD_TEXT = "maturityCommentField.text";
    public static final String BINDING_OCCURRENCE_DENSITY_COMMENT_FIELD_TEXT = "occurrenceDensityCommentField.text";
    public static final String BINDING_SELECTION_ALL_SPECIES_LIST_SELECTION_MODEL = "selectionAllSpeciesList.selectionModel";
    public static final String BINDING_SELECTION_FILTER_DENSITY_FIELD_TEXT = "selectionFilterDensityField.text";
    public static final String BINDING_SELECTION_FILTER_OCCURRENCE_FIELD_TEXT = "selectionFilterOccurrenceField.text";
    public static final String BINDING_SELECTION_MATURITY_LIST_SELECTION_MODEL = "selectionMaturityList.selectionModel";
    public static final String BINDING_SELECTION_OCCURRENCE_DENSITY_LIST_SELECTION_MODEL = "selectionOccurrenceDensityList.selectionModel";
    public static final String BINDING_SELECTION_SIZE_ALL_YEAR_LIST_SELECTION_MODEL = "selectionSizeAllYearList.selectionModel";
    public static final String BINDING_SIZE_ALL_YEAR_COMMENT_FIELD_TEXT = "sizeAllYearCommentField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALWXPWwcRRTHx0dsx3Y+wJ8x/sDEh0AgrR37bAdscJw4p2CdMcqdkBMjlLndsb1mbneZnbXPkUCRkJDooEACURAKOhoQHRWiSE1BgyhpEaKgoQBm9u52b2/nxhMGXKydfe/93v+9+diXL38FnT4BTx7AatUggUPtCjI21ra3t8oHyKTryDeJ7VGXgNpPRwZkdkCfFb33KZjeKfDwmXr4zDW34rkOcpqilwug16fHGPn7CFEKJpIRpu/PFCPzctULSIMaiRJR7//+W+YD697nGQCqHlP3PCtl6qSouJJTBZCxLQr6WaZDOIOhs8dkENvZY3rP8nfXMPT9V2AFvQXeAd0F0OVBwmAUXFQvOWSE8VWPgu5sCZYxmqVgdpcY9i5BFUQM0/XZM7ANH2HWdtt1jGLjr4LtU/81Gx15XojpYpB96FgYEQoMRciNWkCM6ImcKHgiBSkj2BQcR/VmN0qui69CwgoY5B2qGv4Ra5jReM8deyL/AR8eoohzNaCU5xtIBNbe8oD+KG7wEGLbagnktpGk33mIcdFDpo38AiwjTMFTLtkzDtj+fJO6Xi1F1djYLtkUIwZk6wfZ4iRVTrimGRC2sCZaR45v0+NmJncaTwaM+PZdtIbxLQTJCa6DFUgDcjLydHbjVeggzPran2hP+DblG2JSvhF8OvKdjNY5b2OKyFZUat5GmG3+4eQqoioNDUlKb3bdNYMK2+As52hzBGUBRsPopSRe4v9+Jglr2OYEtrEWufX1iCQ9105XmMhIC5gXJOmHnoePWSc4vZYn2luxV0+2vjVnI2O8BGezG0WTuBjz5WE9GUl0MTYlo8aj6tbifcuO96Zr8b2bkx/mCvcyWsO8pl0pplPwWHKXsHc85EVxNWEnV5PCpyP0VutRadJ/XUV/CtC+oEl5Vu51nT/y4kLmBIVMRMhifISbSlhVWoL06U+Lv9AuUyR7Uyx7XiD78Qi2Wb9OmjSvqGjebLmG0oKHhDkitaX0wbgkOBiRcU5mnJcZczLjgsy4KDMuyYyXBcbGFZKLrpC0bUFiW5TYlgS2xC7ICXbBcPy1YwMHv/Xqd/hQ6g5fIwjyKF9wVc61XJWJvAuiQ5P6Pjan505H/HFXkGtelmtRkKv50yrMck+QJSfLsiTIEn2VhSneE6RYaKQgYCwxYbLZ1Yhn13i47NgBnSRgr9lVsJMed28yU23QvdAy6HJgaP1reODHb3/+Jt+YbhdY7iGha9NwzqZOj7gemw1tnvp8bbQNqI1nNqG3vNMY/MLJfVwgrFg3M3EsX/jlMHi4cQP6+wzR2f3Td98P3/nhEZDJg17sQisPuf/LoIfuE9YFF1tVb/VKqOjM0Wn2fJRrY4dtl3lTPv2yT/CK7WDbQVOQsoG7HFD0UpX1YlzQi0hQuefBHwPFr640+tHB9I22dY970nkbdNWyhfM+X8juNvN9n+ejwHLjkV00xHfw3wNefbt9GD4/EhV8yjb5uHtuxWJlT5Vtx2Lnk9XJAz4JC+B/fRryhlV4fNji1o//LYO//ow/7osJo0qELyQaTiZQ0En5NC6RMaYk42sJYVKbMKVNuKjdzKcVmtltujioOL4E86y6kDalPAShjYZZbcKcEuGBhJDT7sNDENpouKyypMjht6QlwbygLUSNILssVhRK6aOui0u2V5LfXCej+OtfJIR1lXsnHIUlFalAzsVj8n9AO2MijG8ix0Kk9p/QNqyCUoP+1Cb8/b9qKGprUCPINNzW1qBGkG3W17VPrxpBpuENbQ36hDvahLI2wdIm7GoT9rUJB9oErE1wtAmeNoGojNHEPZKNS4faY4ISoeOWRMPb2hqUCFIN72prUCJINbyvrYET/gHeFdJk5hoAAA==";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    public static final String PROPERTY$DOCUMENT3 = "$Document3";
    public static final String PROPERTY$DOCUMENT4 = "$Document4";
    public static final String PROPERTY$DOCUMENT5 = "$Document5";
    private static final Log log = LogFactory.getLog(fr.ifremer.coser.ui.selection.SelectionListsView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextArea allSpeciesCommentField;
    protected org.jdesktop.swingx.JXTitledSeparator allSpeciesLabel;
    protected javax.swing.JButton applyOccDensFilter;
    protected fr.ifremer.coser.ui.selection.SelectionHandler handler;
    protected javax.swing.JTextArea maturityCommentField;
    protected org.jdesktop.swingx.JXTitledSeparator maturitySpeciesLabel;
    protected javax.swing.JTextArea occurrenceDensityCommentField;
    protected org.jdesktop.swingx.JXTitledSeparator occurrenceDensitySpeciesLabel;
    protected javax.swing.JButton saveSelectionButton;
    protected fr.ifremer.coser.bean.Selection selection;
    protected javax.swing.JList selectionAllSpeciesList;
    protected fr.ifremer.coser.ui.selection.model.SpeciesListModel selectionAllSpeciesListModel;
    protected javax.swing.JTextField selectionFilterDensityField;
    protected javax.swing.JTextField selectionFilterOccurrenceField;
    protected javax.swing.JList selectionMaturityList;
    protected fr.ifremer.coser.ui.selection.model.MaturitySpeciesListModel selectionMaturityListModel;
    protected javax.swing.JList selectionOccurrenceDensityList;
    protected fr.ifremer.coser.ui.selection.model.OccurrenceDensitySpeciesListModel selectionOccurrenceDensityListModel;
    protected javax.swing.JList selectionSizeAllYearList;
    protected fr.ifremer.coser.ui.selection.model.SizeAllYearSpeciesListModel selectionSizeAllYearListModel;
    protected javax.swing.JTextArea sizeAllYearCommentField;
    protected org.jdesktop.swingx.JXTitledSeparator sizeAllYearSpeciesLabel;
    protected javax.swing.JButton validSelectionButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SelectionListsView $Table0 = this;
    private javax.swing.JToolBar $JToolBar0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.text.Document $Document0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.text.Document $Document1;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.JScrollPane $JScrollPane2;
    private javax.swing.JScrollPane $JScrollPane3;
    private javax.swing.JButton $JButton1;
    private javax.swing.JButton $JButton2;
    private javax.swing.JButton $JButton3;
    private javax.swing.JButton $JButton4;
    private javax.swing.JButton $JButton5;
    private javax.swing.JButton $JButton6;
    private javax.swing.JButton $JButton7;
    private javax.swing.JButton $JButton8;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JScrollPane $JScrollPane4;
    private javax.swing.text.Document $Document2;
    private javax.swing.JScrollPane $JScrollPane5;
    private javax.swing.text.Document $Document3;
    private javax.swing.JScrollPane $JScrollPane6;
    private javax.swing.text.Document $Document4;
    private javax.swing.JScrollPane $JScrollPane7;
    private javax.swing.text.Document $Document5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
            // le modele de la liste est allimenté par la selection de la précédente liste
            // la selection est mise à jour par la modification du model de la liste
            
            void $afterCompleteSetup() {
                // modification (all species -> all species list)
                selectionAllSpeciesList.addListSelectionListener(selectionOccurrenceDensityListModel);
                selectionOccurrenceDensityListModel.addListDataListener((CoserListSelectionModel)selectionOccurrenceDensityList.getSelectionModel());
                
                selectionOccurrenceDensityList.addListSelectionListener(selectionSizeAllYearListModel);
                selectionSizeAllYearListModel.addListDataListener((CoserListSelectionModel)selectionSizeAllYearList.getSelectionModel());
                
                selectionSizeAllYearList.addListSelectionListener(selectionMaturityListModel);
                selectionMaturityListModel.addListDataListener((CoserListSelectionModel)selectionMaturityList.getSelectionModel());
                
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionListsView() {
        $initialize();
    }

    public SelectionListsView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton8(java.awt.event.ActionEvent event) {
        ((CoserListSelectionModel)selectionMaturityList.getSelectionModel()).clearSelection();
    }

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        ((CoserListSelectionModel)selectionOccurrenceDensityList.getSelectionModel()).clearSelection();
    }

    public void doActionPerformed__on__$JButton5(java.awt.event.ActionEvent event) {
        ((CoserListSelectionModel)selectionSizeAllYearList.getSelectionModel()).fillSelection();
    }

    public void doActionPerformed__on__$JButton6(java.awt.event.ActionEvent event) {
        ((CoserListSelectionModel)selectionSizeAllYearList.getSelectionModel()).clearSelection();
    }

    public void doActionPerformed__on__$JButton7(java.awt.event.ActionEvent event) {
        ((CoserListSelectionModel)selectionMaturityList.getSelectionModel()).fillSelection();
    }

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().displayLengthStructureGraph(this);
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        ((CoserListSelectionModel)selectionAllSpeciesList.getSelectionModel()).fillSelection();
    }

    public void doActionPerformed__on__$JButton2(java.awt.event.ActionEvent event) {
        ((CoserListSelectionModel)selectionAllSpeciesList.getSelectionModel()).clearSelection();
    }

    public void doActionPerformed__on__$JButton3(java.awt.event.ActionEvent event) {
        ((CoserListSelectionModel)selectionOccurrenceDensityList.getSelectionModel()).fillSelection();
    }

    public void doActionPerformed__on__applyOccDensFilter(java.awt.event.ActionEvent event) {
        getHandler().updateOccurrenceDensityFilter(this);applyOccDensFilter.setEnabled(false);
    }

    public void doActionPerformed__on__saveSelectionButton(java.awt.event.ActionEvent event) {
        getHandler().saveSelection(this);
    }

    public void doActionPerformed__on__validSelectionButton(java.awt.event.ActionEvent event) {
        getHandler().validSelection(this);
    }

    public void doContentsChanged__on__selectionAllSpeciesListModel(javax.swing.event.ListDataEvent event) {
        allSpeciesLabel.setTitle(_("coser.ui.selection.allSpecies", selectionAllSpeciesList.getSelectedIndices().length, selectionAllSpeciesList.getModel().getSize()));
    }

    public void doContentsChanged__on__selectionMaturityListModel(javax.swing.event.ListDataEvent event) {
        maturitySpeciesLabel.setTitle(_("coser.ui.selection.maturitySpecies", selectionMaturityList.getSelectedIndices().length, selectionMaturityList.getModel().getSize()));
    }

    public void doContentsChanged__on__selectionOccurrenceDensityListModel(javax.swing.event.ListDataEvent event) {
        occurrenceDensitySpeciesLabel.setTitle(_("coser.ui.selection.occurrenceDensitySpecies", selectionOccurrenceDensityList.getSelectedIndices().length, selectionOccurrenceDensityList.getModel().getSize()));
    }

    public void doContentsChanged__on__selectionSizeAllYearListModel(javax.swing.event.ListDataEvent event) {
        sizeAllYearSpeciesLabel.setTitle(_("coser.ui.selection.sizeAllYearSpecies", selectionSizeAllYearList.getSelectedIndices().length, selectionSizeAllYearList.getModel().getSize()));
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        applyOccDensFilter.setEnabled(true);
    }

    public void doInsertUpdate__on__$Document5(javax.swing.event.DocumentEvent event) {
        getSelection().setSelectedSpeciesMaturityComment(maturityCommentField.getText());
    }

    public void doRemoveUpdate__on__$Document5(javax.swing.event.DocumentEvent event) {
        getSelection().setSelectedSpeciesMaturityComment(maturityCommentField.getText());
    }

    public void doInsertUpdate__on__$Document4(javax.swing.event.DocumentEvent event) {
        getSelection().setSelectedSpeciesSizeAllYearComment(sizeAllYearCommentField.getText());
    }

    public void doRemoveUpdate__on__$Document4(javax.swing.event.DocumentEvent event) {
        getSelection().setSelectedSpeciesSizeAllYearComment(sizeAllYearCommentField.getText());
    }

    public void doInsertUpdate__on__$Document3(javax.swing.event.DocumentEvent event) {
        getSelection().setSelectedSpeciesOccDensComment(occurrenceDensityCommentField.getText());
    }

    public void doRemoveUpdate__on__$Document3(javax.swing.event.DocumentEvent event) {
        getSelection().setSelectedSpeciesOccDensComment(occurrenceDensityCommentField.getText());
    }

    public void doInsertUpdate__on__$Document2(javax.swing.event.DocumentEvent event) {
        getSelection().setSelectedSpeciesComment(allSpeciesCommentField.getText());
    }

    public void doRemoveUpdate__on__$Document2(javax.swing.event.DocumentEvent event) {
        getSelection().setSelectedSpeciesComment(allSpeciesCommentField.getText());
    }

    public void doInsertUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        applyOccDensFilter.setEnabled(true);
    }

    public void doRemoveUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        applyOccDensFilter.setEnabled(true);
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        applyOccDensFilter.setEnabled(true);
    }

    public void doValueChanged__on__selectionAllSpeciesList(javax.swing.event.ListSelectionEvent event) {
        allSpeciesLabel.setTitle(_("coser.ui.selection.allSpecies", selectionAllSpeciesList.getSelectedIndices().length, selectionAllSpeciesList.getModel().getSize()));
    }

    public void doValueChanged__on__selectionMaturityList(javax.swing.event.ListSelectionEvent event) {
        maturitySpeciesLabel.setTitle(_("coser.ui.selection.maturitySpecies", selectionMaturityList.getSelectedIndices().length, selectionMaturityList.getModel().getSize()));
    }

    public void doValueChanged__on__selectionOccurrenceDensityList(javax.swing.event.ListSelectionEvent event) {
        applyOccDensFilter.setEnabled(true); occurrenceDensitySpeciesLabel.setTitle(_("coser.ui.selection.occurrenceDensitySpecies", selectionOccurrenceDensityList.getSelectedIndices().length, selectionOccurrenceDensityList.getModel().getSize()));
    }

    public void doValueChanged__on__selectionSizeAllYearList(javax.swing.event.ListSelectionEvent event) {
        sizeAllYearSpeciesLabel.setTitle(_("coser.ui.selection.sizeAllYearSpecies", selectionSizeAllYearList.getSelectedIndices().length, selectionSizeAllYearList.getModel().getSize()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextArea getAllSpeciesCommentField() {
        return allSpeciesCommentField;
    }

    public org.jdesktop.swingx.JXTitledSeparator getAllSpeciesLabel() {
        return allSpeciesLabel;
    }

    public javax.swing.JButton getApplyOccDensFilter() {
        return applyOccDensFilter;
    }

    public fr.ifremer.coser.ui.selection.SelectionHandler getHandler() {
        return handler;
    }

    public javax.swing.JTextArea getMaturityCommentField() {
        return maturityCommentField;
    }

    public org.jdesktop.swingx.JXTitledSeparator getMaturitySpeciesLabel() {
        return maturitySpeciesLabel;
    }

    public javax.swing.JTextArea getOccurrenceDensityCommentField() {
        return occurrenceDensityCommentField;
    }

    public org.jdesktop.swingx.JXTitledSeparator getOccurrenceDensitySpeciesLabel() {
        return occurrenceDensitySpeciesLabel;
    }

    public javax.swing.JButton getSaveSelectionButton() {
        return saveSelectionButton;
    }

    public fr.ifremer.coser.bean.Selection getSelection() {
        return selection;
    }

    public javax.swing.JList getSelectionAllSpeciesList() {
        return selectionAllSpeciesList;
    }

    public fr.ifremer.coser.ui.selection.model.SpeciesListModel getSelectionAllSpeciesListModel() {
        return selectionAllSpeciesListModel;
    }

    public javax.swing.JTextField getSelectionFilterDensityField() {
        return selectionFilterDensityField;
    }

    public javax.swing.JTextField getSelectionFilterOccurrenceField() {
        return selectionFilterOccurrenceField;
    }

    public javax.swing.JList getSelectionMaturityList() {
        return selectionMaturityList;
    }

    public fr.ifremer.coser.ui.selection.model.MaturitySpeciesListModel getSelectionMaturityListModel() {
        return selectionMaturityListModel;
    }

    public javax.swing.JList getSelectionOccurrenceDensityList() {
        return selectionOccurrenceDensityList;
    }

    public fr.ifremer.coser.ui.selection.model.OccurrenceDensitySpeciesListModel getSelectionOccurrenceDensityListModel() {
        return selectionOccurrenceDensityListModel;
    }

    public javax.swing.JList getSelectionSizeAllYearList() {
        return selectionSizeAllYearList;
    }

    public fr.ifremer.coser.ui.selection.model.SizeAllYearSpeciesListModel getSelectionSizeAllYearListModel() {
        return selectionSizeAllYearListModel;
    }

    public javax.swing.JTextArea getSizeAllYearCommentField() {
        return sizeAllYearCommentField;
    }

    public org.jdesktop.swingx.JXTitledSeparator getSizeAllYearSpeciesLabel() {
        return sizeAllYearSpeciesLabel;
    }

    public javax.swing.JButton getValidSelectionButton() {
        return validSelectionButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void set$Document1(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document1;
        this.$Document1 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, newValue);
    }

    public void set$Document2(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document2;
        this.$Document2 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, newValue);
    }

    public void set$Document3(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document3;
        this.$Document3 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT3, oldValue, newValue);
    }

    public void set$Document4(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document4;
        this.$Document4 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT4, oldValue, newValue);
    }

    public void set$Document5(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document5;
        this.$Document5 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT5, oldValue, newValue);
    }

    public void setHandler(fr.ifremer.coser.ui.selection.SelectionHandler newValue) {
        fr.ifremer.coser.ui.selection.SelectionHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setSelection(fr.ifremer.coser.bean.Selection newValue) {
        fr.ifremer.coser.bean.Selection oldValue = this.selection;
        this.selection = newValue;
        firePropertyChange(PROPERTY_SELECTION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.text.Document get$Document1() {
        return $Document1;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected javax.swing.JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    protected javax.swing.JButton get$JButton2() {
        return $JButton2;
    }

    protected javax.swing.JButton get$JButton3() {
        return $JButton3;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JButton get$JButton5() {
        return $JButton5;
    }

    protected javax.swing.JButton get$JButton6() {
        return $JButton6;
    }

    protected javax.swing.JButton get$JButton7() {
        return $JButton7;
    }

    protected javax.swing.JButton get$JButton8() {
        return $JButton8;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected javax.swing.text.Document get$Document2() {
        return $Document2;
    }

    protected javax.swing.JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected javax.swing.text.Document get$Document3() {
        return $Document3;
    }

    protected javax.swing.JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected javax.swing.text.Document get$Document4() {
        return $Document4;
    }

    protected javax.swing.JScrollPane get$JScrollPane7() {
        return $JScrollPane7;
    }

    protected javax.swing.text.Document get$Document5() {
        return $Document5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAllSpeciesCommentField() {
        $objectMap.put("allSpeciesCommentField", allSpeciesCommentField = new javax.swing.JTextArea());
        
        allSpeciesCommentField.setName("allSpeciesCommentField");
        allSpeciesCommentField.setColumns(15);
        allSpeciesCommentField.setLineWrap(true);
        allSpeciesCommentField.setWrapStyleWord(true);
        allSpeciesCommentField.setRows(3);
    }

    protected void createAllSpeciesLabel() {
        $objectMap.put("allSpeciesLabel", allSpeciesLabel = new org.jdesktop.swingx.JXTitledSeparator());
        
        allSpeciesLabel.setName("allSpeciesLabel");
    }

    protected void createApplyOccDensFilter() {
        $objectMap.put("applyOccDensFilter", applyOccDensFilter = new javax.swing.JButton());
        
        applyOccDensFilter.setName("applyOccDensFilter");
        applyOccDensFilter.setEnabled(false);
        applyOccDensFilter.setText(_("coser.ui.selection.filter.filter"));
        applyOccDensFilter.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__applyOccDensFilter"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createMaturityCommentField() {
        $objectMap.put("maturityCommentField", maturityCommentField = new javax.swing.JTextArea());
        
        maturityCommentField.setName("maturityCommentField");
        maturityCommentField.setColumns(15);
        maturityCommentField.setLineWrap(true);
        maturityCommentField.setWrapStyleWord(true);
        maturityCommentField.setRows(3);
    }

    protected void createMaturitySpeciesLabel() {
        $objectMap.put("maturitySpeciesLabel", maturitySpeciesLabel = new org.jdesktop.swingx.JXTitledSeparator());
        
        maturitySpeciesLabel.setName("maturitySpeciesLabel");
    }

    protected void createOccurrenceDensityCommentField() {
        $objectMap.put("occurrenceDensityCommentField", occurrenceDensityCommentField = new javax.swing.JTextArea());
        
        occurrenceDensityCommentField.setName("occurrenceDensityCommentField");
        occurrenceDensityCommentField.setColumns(15);
        occurrenceDensityCommentField.setLineWrap(true);
        occurrenceDensityCommentField.setWrapStyleWord(true);
        occurrenceDensityCommentField.setRows(3);
    }

    protected void createOccurrenceDensitySpeciesLabel() {
        $objectMap.put("occurrenceDensitySpeciesLabel", occurrenceDensitySpeciesLabel = new org.jdesktop.swingx.JXTitledSeparator());
        
        occurrenceDensitySpeciesLabel.setName("occurrenceDensitySpeciesLabel");
    }

    protected void createSaveSelectionButton() {
        $objectMap.put("saveSelectionButton", saveSelectionButton = new javax.swing.JButton());
        
        saveSelectionButton.setName("saveSelectionButton");
        saveSelectionButton.setText(_("coser.ui.selection.details.saveSelection"));
        saveSelectionButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveSelectionButton"));
    }

    protected void createSelection() {
        $objectMap.put("selection", selection = null);
    }

    protected void createSelectionAllSpeciesList() {
        $objectMap.put("selectionAllSpeciesList", selectionAllSpeciesList = new javax.swing.JList());
        
        selectionAllSpeciesList.setName("selectionAllSpeciesList");
        selectionAllSpeciesList.setEnabled(false);
        selectionAllSpeciesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionAllSpeciesList"));
    }

    protected void createSelectionAllSpeciesListModel() {
        $objectMap.put("selectionAllSpeciesListModel", selectionAllSpeciesListModel = new fr.ifremer.coser.ui.selection.model.SpeciesListModel());
        
        selectionAllSpeciesListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__selectionAllSpeciesListModel"));
    }

    protected void createSelectionFilterDensityField() {
        $objectMap.put("selectionFilterDensityField", selectionFilterDensityField = new javax.swing.JTextField());
        
        selectionFilterDensityField.setName("selectionFilterDensityField");
        selectionFilterDensityField.setColumns(15);
        selectionFilterDensityField.setColumns(3);
    }

    protected void createSelectionFilterOccurrenceField() {
        $objectMap.put("selectionFilterOccurrenceField", selectionFilterOccurrenceField = new javax.swing.JTextField());
        
        selectionFilterOccurrenceField.setName("selectionFilterOccurrenceField");
        selectionFilterOccurrenceField.setColumns(15);
        selectionFilterOccurrenceField.setColumns(3);
    }

    protected void createSelectionMaturityList() {
        $objectMap.put("selectionMaturityList", selectionMaturityList = new javax.swing.JList());
        
        selectionMaturityList.setName("selectionMaturityList");
        selectionMaturityList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionMaturityList"));
    }

    protected void createSelectionMaturityListModel() {
        $objectMap.put("selectionMaturityListModel", selectionMaturityListModel = new fr.ifremer.coser.ui.selection.model.MaturitySpeciesListModel());
        
        selectionMaturityListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__selectionMaturityListModel"));
    }

    protected void createSelectionOccurrenceDensityList() {
        $objectMap.put("selectionOccurrenceDensityList", selectionOccurrenceDensityList = new javax.swing.JList());
        
        selectionOccurrenceDensityList.setName("selectionOccurrenceDensityList");
        selectionOccurrenceDensityList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionOccurrenceDensityList"));
    }

    protected void createSelectionOccurrenceDensityListModel() {
        $objectMap.put("selectionOccurrenceDensityListModel", selectionOccurrenceDensityListModel = new fr.ifremer.coser.ui.selection.model.OccurrenceDensitySpeciesListModel());
        
        selectionOccurrenceDensityListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__selectionOccurrenceDensityListModel"));
    }

    protected void createSelectionSizeAllYearList() {
        $objectMap.put("selectionSizeAllYearList", selectionSizeAllYearList = new javax.swing.JList());
        
        selectionSizeAllYearList.setName("selectionSizeAllYearList");
        selectionSizeAllYearList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionSizeAllYearList"));
    }

    protected void createSelectionSizeAllYearListModel() {
        $objectMap.put("selectionSizeAllYearListModel", selectionSizeAllYearListModel = new fr.ifremer.coser.ui.selection.model.SizeAllYearSpeciesListModel());
        
        selectionSizeAllYearListModel.addListDataListener(JAXXUtil.getEventListener(ListDataListener.class, "contentsChanged", this, "doContentsChanged__on__selectionSizeAllYearListModel"));
    }

    protected void createSizeAllYearCommentField() {
        $objectMap.put("sizeAllYearCommentField", sizeAllYearCommentField = new javax.swing.JTextArea());
        
        sizeAllYearCommentField.setName("sizeAllYearCommentField");
        sizeAllYearCommentField.setColumns(15);
        sizeAllYearCommentField.setLineWrap(true);
        sizeAllYearCommentField.setWrapStyleWord(true);
        sizeAllYearCommentField.setRows(3);
    }

    protected void createSizeAllYearSpeciesLabel() {
        $objectMap.put("sizeAllYearSpeciesLabel", sizeAllYearSpeciesLabel = new org.jdesktop.swingx.JXTitledSeparator());
        
        sizeAllYearSpeciesLabel.setName("sizeAllYearSpeciesLabel");
    }

    protected void createValidSelectionButton() {
        $objectMap.put("validSelectionButton", validSelectionButton = new javax.swing.JButton());
        
        validSelectionButton.setName("validSelectionButton");
        validSelectionButton.setText(_("coser.ui.selection.details.validSelection"));
        validSelectionButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validSelectionButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JToolBar0, new GridBagConstraints(0, 0, 8, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(allSpeciesLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(occurrenceDensitySpeciesLabel, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(sizeAllYearSpeciesLabel, new GridBagConstraints(4, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(maturitySpeciesLabel, new GridBagConstraints(6, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JPanel0, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JButton0, new GridBagConstraints(4, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(2, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane2, new GridBagConstraints(4, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane3, new GridBagConstraints(6, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton1, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton2, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton3, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton4, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton5, new GridBagConstraints(4, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton6, new GridBagConstraints(5, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton7, new GridBagConstraints(6, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton8, new GridBagConstraints(7, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel4, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel5, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel6, new GridBagConstraints(4, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel7, new GridBagConstraints(6, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane4, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane5, new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane6, new GridBagConstraints(4, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane7, new GridBagConstraints(6, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JToolBar0
        $JToolBar0.add(saveSelectionButton);
        $JToolBar0.add(validSelectionButton);
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel0);
        $JPanel0.add(selectionFilterOccurrenceField);
        $JPanel0.add($JLabel1);
        $JPanel0.add($JLabel2);
        $JPanel0.add(selectionFilterDensityField);
        $JPanel0.add($JLabel3);
        $JPanel0.add(applyOccDensFilter);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(selectionAllSpeciesList);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(selectionOccurrenceDensityList);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(selectionSizeAllYearList);
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(selectionMaturityList);
        // inline complete setup of $JScrollPane4
        $JScrollPane4.getViewport().add(allSpeciesCommentField);
        // inline complete setup of $JScrollPane5
        $JScrollPane5.getViewport().add(occurrenceDensityCommentField);
        // inline complete setup of $JScrollPane6
        $JScrollPane6.getViewport().add(sizeAllYearCommentField);
        // inline complete setup of $JScrollPane7
        $JScrollPane7.getViewport().add(maturityCommentField);
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        saveSelectionButton.setIcon(jaxx.runtime.SwingUtil.createImageIcon("disk.png"));
        validSelectionButton.setIcon(jaxx.runtime.SwingUtil.createImageIcon("accept.png"));
        allSpeciesLabel.setTitle(_("coser.ui.selection.allSpecies", 0, 0));
        occurrenceDensitySpeciesLabel.setTitle(_("coser.ui.selection.occurrenceDensitySpecies", 0, 0));
        sizeAllYearSpeciesLabel.setTitle(_("coser.ui.selection.sizeAllYearSpecies", 0, 0));
        maturitySpeciesLabel.setTitle(_("coser.ui.selection.maturitySpecies", 0, 0));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.createImageIcon("chart_bar.png"));
        selectionAllSpeciesList.setModel(selectionAllSpeciesListModel);
        selectionOccurrenceDensityList.setCellRenderer(new SpeciesListOccDensRenderer());
        selectionOccurrenceDensityList.setModel(selectionOccurrenceDensityListModel);
        selectionSizeAllYearList.setModel(selectionSizeAllYearListModel);
        selectionMaturityList.setModel(selectionMaturityListModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createSelection();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new javax.swing.JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        createSaveSelectionButton();
        createValidSelectionButton();
        createAllSpeciesLabel();
        createOccurrenceDensitySpeciesLabel();
        createSizeAllYearSpeciesLabel();
        createMaturitySpeciesLabel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.selection.filter.occurrence"));
        createSelectionFilterOccurrenceField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = selectionFilterOccurrenceField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("coser.ui.selection.filter.occurrenceunit"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.selection.filter.density"));
        createSelectionFilterDensityField();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = selectionFilterDensityField.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.selection.filter.densityunit"));
        createApplyOccDensFilter();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("coser.ui.graph.lengthStructure"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSelectionAllSpeciesListModel();
        createSelectionAllSpeciesList();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createSelectionOccurrenceDensityListModel();
        createSelectionOccurrenceDensityList();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new javax.swing.JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createSelectionSizeAllYearListModel();
        createSelectionSizeAllYearList();
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new javax.swing.JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createSelectionMaturityListModel();
        createSelectionMaturityList();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setEnabled(false);
        $JButton1.setText(_("coser.ui.common.selectAll.short"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new javax.swing.JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setEnabled(false);
        $JButton2.setText(_("coser.ui.common.unselectAll.short"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new javax.swing.JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("coser.ui.common.selectAll.short"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new javax.swing.JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("coser.ui.common.unselectAll.short"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new javax.swing.JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setText(_("coser.ui.common.selectAll.short"));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        // inline creation of $JButton6
        $objectMap.put("$JButton6", $JButton6 = new javax.swing.JButton());
        
        $JButton6.setName("$JButton6");
        $JButton6.setText(_("coser.ui.common.unselectAll.short"));
        $JButton6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton6"));
        // inline creation of $JButton7
        $objectMap.put("$JButton7", $JButton7 = new javax.swing.JButton());
        
        $JButton7.setName("$JButton7");
        $JButton7.setText(_("coser.ui.common.selectAll.short"));
        $JButton7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton7"));
        // inline creation of $JButton8
        $objectMap.put("$JButton8", $JButton8 = new javax.swing.JButton());
        
        $JButton8.setName("$JButton8");
        $JButton8.setText(_("coser.ui.common.unselectAll.short"));
        $JButton8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton8"));
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("coser.ui.selection.comment"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("coser.ui.selection.comment"));
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("coser.ui.selection.comment"));
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("coser.ui.selection.comment"));
        // inline creation of $JScrollPane4
        $objectMap.put("$JScrollPane4", $JScrollPane4 = new javax.swing.JScrollPane());
        
        $JScrollPane4.setName("$JScrollPane4");
        createAllSpeciesCommentField();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = allSpeciesCommentField.getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $JScrollPane5
        $objectMap.put("$JScrollPane5", $JScrollPane5 = new javax.swing.JScrollPane());
        
        $JScrollPane5.setName("$JScrollPane5");
        createOccurrenceDensityCommentField();
        // inline creation of $Document3
        $objectMap.put("$Document3", $Document3 = occurrenceDensityCommentField.getDocument());
        
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document3"));
        $Document3.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document3"));
        // inline creation of $JScrollPane6
        $objectMap.put("$JScrollPane6", $JScrollPane6 = new javax.swing.JScrollPane());
        
        $JScrollPane6.setName("$JScrollPane6");
        createSizeAllYearCommentField();
        // inline creation of $Document4
        $objectMap.put("$Document4", $Document4 = sizeAllYearCommentField.getDocument());
        
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document4"));
        $Document4.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document4"));
        // inline creation of $JScrollPane7
        $objectMap.put("$JScrollPane7", $JScrollPane7 = new javax.swing.JScrollPane());
        
        $JScrollPane7.setName("$JScrollPane7");
        createMaturityCommentField();
        // inline creation of $Document5
        $objectMap.put("$Document5", $Document5 = maturityCommentField.getDocument());
        
        $Document5.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document5"));
        $Document5.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document5"));
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 10 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 10 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_FILTER_OCCURRENCE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("occurrenceFilter", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    jaxx.runtime.SwingUtil.setText(selectionFilterOccurrenceField, String.valueOf(getSelection().getOccurrenceFilter()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("occurrenceFilter", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_FILTER_DENSITY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("densityFilter", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    jaxx.runtime.SwingUtil.setText(selectionFilterDensityField, String.valueOf(getSelection().getDensityFilter()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("densityFilter", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_ALL_SPECIES_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectionAllSpeciesList != null) {
                    selectionAllSpeciesList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectionAllSpeciesList != null) {
                    selectionAllSpeciesList.setSelectionModel(new CoserListSelectionModel(selectionAllSpeciesList.getSelectionModel(), selectionAllSpeciesListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectionAllSpeciesList != null) {
                    selectionAllSpeciesList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_OCCURRENCE_DENSITY_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectionOccurrenceDensityList != null) {
                    selectionOccurrenceDensityList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectionOccurrenceDensityList != null) {
                    selectionOccurrenceDensityList.setSelectionModel(new CoserListSelectionModel(selectionOccurrenceDensityList.getSelectionModel(), selectionOccurrenceDensityListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectionOccurrenceDensityList != null) {
                    selectionOccurrenceDensityList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_SIZE_ALL_YEAR_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectionSizeAllYearList != null) {
                    selectionSizeAllYearList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectionSizeAllYearList != null) {
                    selectionSizeAllYearList.setSelectionModel(new CoserListSelectionModel(selectionSizeAllYearList.getSelectionModel(), selectionSizeAllYearListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectionSizeAllYearList != null) {
                    selectionSizeAllYearList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTION_MATURITY_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectionMaturityList != null) {
                    selectionMaturityList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectionMaturityList != null) {
                    selectionMaturityList.setSelectionModel(new CoserListSelectionModel(selectionMaturityList.getSelectionModel(), selectionMaturityListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectionMaturityList != null) {
                    selectionMaturityList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ALL_SPECIES_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("selectedSpeciesComment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    jaxx.runtime.SwingUtil.setText(allSpeciesCommentField, getSelection().getSelectedSpeciesComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("selectedSpeciesComment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OCCURRENCE_DENSITY_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("selectedSpeciesOccDensComment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    jaxx.runtime.SwingUtil.setText(occurrenceDensityCommentField, getSelection().getSelectedSpeciesOccDensComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("selectedSpeciesOccDensComment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIZE_ALL_YEAR_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("selectedSpeciesSizeAllYearComment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    jaxx.runtime.SwingUtil.setText(sizeAllYearCommentField, getSelection().getSelectedSpeciesSizeAllYearComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("selectedSpeciesSizeAllYearComment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MATURITY_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("selectedSpeciesMaturityComment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    jaxx.runtime.SwingUtil.setText(maturityCommentField, getSelection().getSelectedSpeciesMaturityComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("selectedSpeciesMaturityComment", this);
                }
            }
        });
    }

}