/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.common;

import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.ui.common.CommonHandler;
import fr.ifremer.coser.ui.common.LengthStructureMatrixFilter;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixFilter;
import org.nuiton.math.matrix.viewer.MatrixRenderer;
import org.nuiton.math.matrix.viewer.MatrixViewerPanel;
import org.nuiton.math.matrix.viewer.renderer.MatrixChartRenderer;
import org.nuiton.math.matrix.viewer.renderer.MatrixInfoTableRenderer;
import org.nuiton.widget.SwingSession;

public class DataHandler
extends CommonHandler {
    public void displayLengthStructureGraph(final Component parent, final SwingSession session, final ProjectService projectService, final Project project, final AbstractDataContainer container) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DataHandler.this.setWaitCursor(parent);
                    MatrixND matrix = projectService.getLengthStructure(project, container);
                    JFrame previousFrame = (JFrame)((JAXXContext)parent).getContextValue(JFrame.class, "lengthstructureframe");
                    if (previousFrame != null) {
                        previousFrame.dispose();
                    }
                    JFrame matrixViewerFrame = new JFrame(I18n._((String)"coser.ui.graph.lengthStructure", (Object[])new Object[0]));
                    matrixViewerFrame.setName("lengthstructureframe");
                    MatrixViewerPanel panel = new MatrixViewerPanel();
                    panel.addMatrixRenderer((MatrixRenderer)new MatrixChartRenderer());
                    panel.addMatrixRenderer((MatrixRenderer)new MatrixInfoTableRenderer());
                    panel.addMatrixFilter((MatrixFilter)new LengthStructureMatrixFilter(project, container));
                    panel.addMatrix(new MatrixND[]{matrix});
                    matrixViewerFrame.add((Component)panel);
                    matrixViewerFrame.pack();
                    matrixViewerFrame.setLocationRelativeTo(parent);
                    session.add((Component)matrixViewerFrame);
                    matrixViewerFrame.toFront();
                    matrixViewerFrame.setVisible(true);
                    ((JAXXContext)parent).setContextValue((Object)matrixViewerFrame, "lengthstructureframe");
                }
                finally {
                    DataHandler.this.setDefaultCursor(parent);
                }
            }
        });
    }
}

