/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.connector;

import com.orientimport.easyfck.services.FckEditorService;
import com.orientimport.easyfck.util.LegacyT5ServiceHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.fckeditor.connector.Dispatcher;
import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.response.GetResponse;
import net.fckeditor.response.UploadResponse;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ApplicationGlobals;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.HttpServletRequestHandler;
import org.slf4j.Logger;

public class Tapestry5InterceptFckActivityFilter
implements HttpServletRequestFilter {
    private final Pattern fileBrowserActivityPattern;
    private final Pattern configurePattern;
    private final Dispatcher dispatcher;
    private final ApplicationGlobals applicationGlobals;
    private final FckEditorService fckEditorService;
    private final Logger logger;

    public Tapestry5InterceptFckActivityFilter(ApplicationGlobals applicationGlobals, LoggerSource loggerSource, Logger logger, @Inject @Symbol(value="com.orientimport.easyfckeditor.fckeditor-context") String location, FckEditorService fckEditorService) {
        this.fileBrowserActivityPattern = Pattern.compile("/assets/" + location + "/fckeditor/editor/filemanager/browser/default/fckeditor", 2);
        this.configurePattern = Pattern.compile("/assets/" + location + "/configure", 2);
        try {
            this.dispatcher = new Dispatcher(applicationGlobals.getServletContext());
        }
        catch (Exception e) {
            logger.error("Dispatcher could not be initialized", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.applicationGlobals = applicationGlobals;
        this.logger = logger;
        this.fckEditorService = fckEditorService;
    }

    public boolean service(HttpServletRequest request, HttpServletResponse response, HttpServletRequestHandler handler) throws IOException {
        String path = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        if (this.fileBrowserActivityPattern.matcher(path).matches()) {
            LegacyT5ServiceHelper.setRegistryToRequest(this.applicationGlobals.getServletContext(), request);
            this.logger.debug("Added the registry to the request.");
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            PrintWriter out = response.getWriter();
            if (request.getMethod().equalsIgnoreCase("get")) {
                GetResponse getResponse = null;
                response.setContentType("application/xml");
                try {
                    ThreadLocalData.beginRequest((HttpServletRequest)request);
                    getResponse = this.dispatcher.doGet(request);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    ThreadLocalData.endRequest();
                }
                out.print(getResponse);
            } else {
                UploadResponse uploadResponse = null;
                response.setContentType("text/html");
                try {
                    ThreadLocalData.beginRequest((HttpServletRequest)request);
                    uploadResponse = this.dispatcher.doPost(request);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    ThreadLocalData.endRequest();
                }
                out.print(uploadResponse);
            }
            out.flush();
            out.close();
            return true;
        }
        if (this.configurePattern.matcher(path).matches()) {
            String id = request.getParameter("id");
            String conf = this.fckEditorService.getEditorConfiguration(id);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.print(conf);
            out.flush();
            out.close();
            return true;
        }
        return handler.service(request, response);
    }
}

