/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class MailingManager {
    private static final Log log = LogFactory.getLog(MailingManager.class);
    protected static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    protected WikittyProxy wikittyProxy;

    public MailingManager(WikittyProxy wikittyProxy) {
        this.wikittyProxy = wikittyProxy;
    }

    public String postMail(String recipient, String subject, String message, List<Form> forms, boolean receptionProof) throws VradiException {
        String result;
        final VradiServiceConfiguration config = VradiServiceConfiguration.getInstance(new String[0]);
        if (StringUtils.isBlank((String)recipient) || message == null && (forms == null || forms.isEmpty())) {
            if (log.isWarnEnabled()) {
                log.warn((Object)I18n._("Nothing to send : %s", recipient));
            }
            return null;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", config.getSmtpHost());
        props.put("mail.smtp.port", (Object)config.getSmtpPort());
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(config.getMailUser(), config.getMailPassword());
            }
        });
        MimeMessage msg = new MimeMessage(session);
        try {
            InternetAddress addressFrom = new InternetAddress(config.getMailFrom(), config.getMailFromName());
            msg.setFrom((Address)addressFrom);
            InternetAddress addressTo = new InternetAddress(recipient);
            msg.addRecipient(Message.RecipientType.TO, (Address)addressTo);
            if (receptionProof) {
                msg.addHeader("Return-Receipt-To", config.getMailFrom());
                msg.addHeader("Disposition-Notification-To", config.getMailFrom());
            }
            MimeMultipart multiparts = new MimeMultipart();
            MimeBodyPart msgBodyPart = new MimeBodyPart();
            msgBodyPart.setText(message);
            multiparts.addBodyPart((BodyPart)msgBodyPart);
            int count = 0;
            if (forms != null) {
                for (Form form : forms) {
                    File formFile = this.getGeneratedPdfFile(form);
                    if (formFile.exists()) {
                        MimeBodyPart msgCurrentPdfPart = new MimeBodyPart();
                        msgCurrentPdfPart.setHeader("Content-Type", "application/pdf");
                        FileDataSource source = new FileDataSource(formFile);
                        msgCurrentPdfPart.setDataHandler(new DataHandler((DataSource)source));
                        msgCurrentPdfPart.setFileName(formFile.getName());
                        multiparts.addBodyPart((BodyPart)msgCurrentPdfPart);
                        ++count;
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("No pdf attachment found for form : " + form.getObjet()));
                }
            }
            if (count == 0) {
                throw new VradiException(I18n._("vradi.error.sending.noAttachedPDF"));
            }
            msg.setContent((Multipart)multiparts);
            msg.setSubject(subject);
            try {
                Transport.send((Message)msg);
            }
            catch (MessagingException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Cant send mail", (Throwable)eee);
                }
                if (eee.getCause() instanceof SendFailedException) {
                    SendFailedException exception = (SendFailedException)eee.getCause();
                    throw new VradiException(I18n._("SMTP fail to send mail :\n(%s)", exception.getLocalizedMessage()), eee);
                }
                throw new VradiException("Can't send message", eee);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("MessageID: " + msg.getMessageID()));
            }
            result = msg.getMessageID();
        }
        catch (MessagingException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't generate message", (Throwable)eee);
            }
            throw new VradiException("Can't generate message", eee);
        }
        catch (UnsupportedEncodingException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't generate message", (Throwable)eee);
            }
            throw new VradiException("Can't generate message", eee);
        }
        return result;
    }

    public void receiveMails() throws VradiException {
        try {
            Message[] messages;
            final VradiServiceConfiguration config = VradiServiceConfiguration.getInstance(new String[0]);
            Properties props = new Properties();
            props.put("mail.imap.host", config.getImapHost());
            props.put("mail.imap.auth", "true");
            props.put("mail.imap.user", config.getMailUser());
            props.put("mail.imap.port", (Object)config.getImapPort());
            props.put("mail.store.protocol", "imap");
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(config.getMailUser(), config.getMailPassword());
                }
            });
            Store store = session.getStore("imap");
            store.connect(config.getImapHost(), config.getMailUser(), config.getMailPassword());
            Folder folder = store.getFolder("INBOX");
            folder.open(2);
            FlagTerm flagTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
            for (Message message : messages = folder.search((SearchTerm)flagTerm)) {
                if (message.getContentType().startsWith("multipart/")) {
                    boolean markAsRead = false;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Testing message " + Arrays.toString(message.getHeader("Message-ID")) + " as multipart"));
                    }
                    Multipart multiPart = (Multipart)message.getContent();
                    String errorMessage = null;
                    String errorMessageId = null;
                    String originalMessageID = null;
                    for (int index = 0; index < multiPart.getCount(); ++index) {
                        String content;
                        BodyPart bodyPart = multiPart.getBodyPart(index);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Part " + index + " : " + bodyPart.getContentType()));
                        }
                        if ("message/delivery-status".equals(bodyPart.getContentType())) {
                            content = this.getStreamContent(bodyPart.getInputStream());
                            errorMessage = this.getHeaderValueInContent("Diagnostic-Code", content);
                        }
                        if ("text/rfc822-headers".equals(bodyPart.getContentType())) {
                            content = this.getStreamContent(bodyPart.getInputStream());
                            errorMessageId = this.getHeaderValueInContent("Message-ID", content);
                        }
                        if (!bodyPart.getContentType().startsWith("message/disposition-notification")) continue;
                        content = this.getStreamContent(bodyPart.getInputStream());
                        originalMessageID = this.getHeaderValueInContent("Original-Message-ID", content);
                    }
                    if (StringUtils.isNotEmpty(errorMessage) && StringUtils.isNotEmpty(errorMessageId)) {
                        Sending sending;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Error message received for message " + errorMessageId));
                            log.info((Object)(" error description : " + errorMessage));
                        }
                        if ((sending = MailingManager.getSendingByMessageID(errorMessageId, this.wikittyProxy)) != null) {
                            sending.setStatus(VradiConstants.SendingStatus.ERROR.getValue());
                            this.wikittyProxy.store((BusinessEntity)sending);
                            markAsRead = true;
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Can't find sending for message id : " + errorMessageId));
                        }
                    } else if (StringUtils.isNotEmpty(originalMessageID)) {
                        Sending sending;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Proof notification received for message " + originalMessageID));
                        }
                        if ((sending = MailingManager.getSendingByMessageID(originalMessageID, this.wikittyProxy)) != null) {
                            if (VradiConstants.SendingStatus.isWaitingReceptionProof(sending)) {
                                sending.setStatus(VradiConstants.SendingStatus.RECEIVED.getValue());
                                sending.setReceptionDate(new Date());
                                this.wikittyProxy.store((BusinessEntity)sending);
                                this.setValidEmailForUser(sending);
                                markAsRead = true;
                            } else if (log.isWarnEnabled()) {
                                log.warn((Object)"Received a reception proof for a sending with non reception proof waiting status");
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Can't find sending for message id : " + originalMessageID));
                        }
                    }
                    message.setFlag(Flags.Flag.SEEN, markAsRead);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Mail inbox contains non multipart mails !");
            }
            folder.close(true);
            store.close();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't recieve messages", (Throwable)e);
            }
            throw new VradiException("Can't recieve messages", e);
        }
    }

    protected void setValidEmailForUser(Sending sending) {
        String userId = sending.getUser();
        User user = (User)this.wikittyProxy.restore(User.class, userId);
        if (user != null && !user.getValidEmail()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("User email " + user.getEmail() + " has been validated"));
            }
            user.setValidEmail(true);
            this.wikittyProxy.store((BusinessEntity)user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStreamContent(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            inputStream.close();
        }
        return sb.toString();
    }

    protected String getHeaderValueInContent(String headerName, String content) {
        String result = null;
        String headerText = headerName + ":";
        int firstIndex = content.indexOf(headerText) + headerText.length();
        int lastIndex = content.indexOf("\n", firstIndex);
        if (lastIndex == -1) {
            lastIndex = content.length();
        }
        result = content.substring(firstIndex, lastIndex);
        result = result.trim();
        return result;
    }

    protected static Sending getSendingByMessageID(String messageID, WikittyProxy proxy) {
        Sending result = null;
        Search search = Search.query();
        search.eq(Element.ELT_EXTENSION, "Sending").eq("Sending.messageId", messageID);
        Criteria criteria = search.criteria();
        PagedResult sendingsResult = proxy.findAllByCriteria(Sending.class, criteria);
        List sendingList = sendingsResult.getAll();
        if (sendingList.size() == 1) {
            result = (Sending)sendingList.get(0);
        }
        return result;
    }

    public File getGeneratedPdfFile(Form form) {
        String filename = form.getWikittyId() + "-" + form.getWikittyVersion() + ".pdf";
        File pdfDir = VradiServiceConfiguration.getInstance(new String[0]).getPdfDir();
        File result = new File(pdfDir, filename);
        return result;
    }
}

