/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NamespaceDeclarationsImpl;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pull.PullFromIterator;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.UnconstructedParent;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTreeWalker;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class TreeWalker
implements PullProvider,
SourceLocator {
    private NodeInfo startNode;
    private NodeInfo currentNode;
    private int currentEvent;
    private Stack iteratorStack = new Stack();
    private PipelineConfiguration pipe;
    private int[] nsBuffer = new int[10];

    public static PullProvider makeTreeWalker(NodeInfo nodeInfo) {
        if (nodeInfo instanceof UnconstructedParent) {
            return ((UnconstructedParent)nodeInfo).getPuller();
        }
        if (nodeInfo instanceof TinyNodeImpl) {
            switch (nodeInfo.getNodeKind()) {
                case 1: 
                case 9: {
                    return new TinyTreeWalker((TinyNodeImpl)nodeInfo);
                }
            }
            return new PullFromIterator(SingletonIterator.makeIterator(nodeInfo));
        }
        return new TreeWalker(nodeInfo);
    }

    private TreeWalker(NodeInfo nodeInfo) {
        this.startNode = nodeInfo;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public int next() throws XPathException {
        switch (this.currentEvent) {
            case 0: {
                this.currentNode = this.startNode;
                switch (this.currentNode.getNodeKind()) {
                    case 9: {
                        this.currentEvent = 2;
                        break;
                    }
                    case 1: {
                        this.currentEvent = 4;
                        break;
                    }
                    case 3: {
                        this.currentEvent = 8;
                        break;
                    }
                    case 8: {
                        this.currentEvent = 9;
                        break;
                    }
                    case 7: {
                        this.currentEvent = 10;
                        break;
                    }
                    case 2: {
                        this.currentEvent = 6;
                        break;
                    }
                    case 13: {
                        this.currentEvent = 7;
                    }
                }
                return this.currentEvent;
            }
            case 2: 
            case 4: {
                AxisIterator axisIterator = this.currentNode.iterateAxis((byte)3);
                this.iteratorStack.push(axisIterator);
                this.currentNode = (NodeInfo)axisIterator.next();
                if (this.currentNode != null) {
                    switch (this.currentNode.getNodeKind()) {
                        case 1: {
                            this.currentEvent = 4;
                            break;
                        }
                        case 3: {
                            this.currentEvent = 8;
                            break;
                        }
                        case 8: {
                            this.currentEvent = 9;
                            break;
                        }
                        case 7: {
                            this.currentEvent = 10;
                        }
                    }
                    return this.currentEvent;
                }
                this.iteratorStack.pop();
                if (this.iteratorStack.isEmpty()) {
                    this.currentNode = this.startNode;
                }
                this.currentEvent = this.currentEvent == 2 ? 3 : 5;
                return this.currentEvent;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                if (this.iteratorStack.isEmpty()) {
                    if (this.currentNode == this.startNode) {
                        this.currentNode = null;
                        this.currentEvent = -1;
                    } else {
                        this.currentNode = this.startNode;
                        this.currentEvent = this.currentNode.getNodeKind() == 1 ? 5 : 3;
                    }
                    return this.currentEvent;
                }
                AxisIterator axisIterator = (AxisIterator)this.iteratorStack.peek();
                this.currentNode = (NodeInfo)axisIterator.next();
                if (this.currentNode == null) {
                    this.iteratorStack.pop();
                    if (this.iteratorStack.isEmpty()) {
                        this.currentNode = this.startNode;
                        this.currentEvent = this.currentNode.getNodeKind() == 1 ? 5 : 3;
                        return this.currentEvent;
                    }
                    AxisIterator axisIterator2 = (AxisIterator)this.iteratorStack.peek();
                    this.currentNode = (NodeInfo)axisIterator2.current();
                    this.currentEvent = this.currentNode.getNodeKind() == 9 ? 3 : 5;
                    return this.currentEvent;
                }
                switch (this.currentNode.getNodeKind()) {
                    case 1: {
                        this.currentEvent = 4;
                        break;
                    }
                    case 3: {
                        this.currentEvent = 8;
                        break;
                    }
                    case 8: {
                        this.currentEvent = 9;
                        break;
                    }
                    case 7: {
                        this.currentEvent = 10;
                    }
                }
                return this.currentEvent;
            }
            case 3: 
            case 6: 
            case 7: {
                this.currentEvent = -1;
                return this.currentEvent;
            }
            case -1: {
                throw new IllegalStateException("Cannot call next() when input is exhausted");
            }
        }
        throw new IllegalStateException("Unrecognized event " + this.currentEvent);
    }

    public int current() {
        return this.currentEvent;
    }

    public AttributeCollection getAttributes() throws XPathException {
        if (this.currentNode.getNodeKind() == 1) {
            NodeInfo nodeInfo;
            AttributeCollectionImpl attributeCollectionImpl = new AttributeCollectionImpl(this.getNamePool());
            AxisIterator axisIterator = this.currentNode.iterateAxis((byte)2);
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                attributeCollectionImpl.addAttribute(nodeInfo.getNameCode(), nodeInfo.getTypeAnnotation(), nodeInfo.getStringValue(), 0, 0);
            }
            return attributeCollectionImpl;
        }
        throw new IllegalStateException("getAttributes() called when current event is not ELEMENT_START");
    }

    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        if (this.currentNode.getNodeKind() == 1) {
            if (this.iteratorStack.size() == 0) {
                int[] nArray = new NamespaceIterator(this.currentNode, null).getInScopeNamespaceCodes();
                return new NamespaceDeclarationsImpl(this.getNamePool(), nArray);
            }
            return new NamespaceDeclarationsImpl(this.getNamePool(), this.currentNode.getDeclaredNamespaces(this.nsBuffer));
        }
        throw new IllegalStateException("getNamespaceDeclarations() called when current event is not ELEMENT_START");
    }

    public int skipToMatchingEnd() throws XPathException {
        switch (this.currentEvent) {
            case 2: {
                this.currentEvent = 3;
                return this.currentEvent;
            }
            case 4: {
                this.currentEvent = 5;
                return this.currentEvent;
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    public void close() {
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public int getNameCode() {
        return this.currentNode.getNameCode();
    }

    public int getFingerprint() {
        return this.currentNode.getFingerprint();
    }

    public CharSequence getStringValue() throws XPathException {
        if (this.currentNode.getNodeKind() == 1) {
            this.skipToMatchingEnd();
        }
        return this.currentNode.getStringValueCS();
    }

    public int getTypeAnnotation() {
        return this.currentNode.getTypeAnnotation();
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public SourceLocator getSourceLocator() {
        return this;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.currentNode.getSystemId();
    }

    public int getLineNumber() {
        return this.currentNode.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }
}

