/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.TimeoutException;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class NAKACK_SET_DIGEST_Test {
    private NAKACK nak;
    private MutableDigest d1;
    private MutableDigest d2;
    private Address a;
    private Address b;
    private Address c;
    private static final short TP_ID = 101;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.a = Util.createRandomAddress();
        this.b = Util.createRandomAddress();
        this.c = Util.createRandomAddress();
        UUID.add((UUID)this.a, "A");
        UUID.add((UUID)this.b, "B");
        UUID.add((UUID)this.c, "C");
        this.nak = new NAKACK();
        this.d1 = new MutableDigest(2);
        this.d1.add(this.a, 0L, 11L, 11L);
        this.d1.add(this.b, 0L, 30L, 35L);
        this.d2 = new MutableDigest(3);
        this.d2.add(this.a, 0L, 10L, 10L);
        this.d2.add(this.b, 0L, 30L, 30L);
        this.d2.add(this.c, 10L, 50L, 50L);
        TP transport = new TP(){

            @Override
            public boolean supportsMulticasting() {
                return false;
            }

            @Override
            public void sendMulticast(byte[] data, int offset, int length) throws Exception {
            }

            @Override
            public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
            }

            @Override
            public String getInfo() {
                return null;
            }

            @Override
            public Object down(Event evt) {
                return null;
            }

            @Override
            protected PhysicalAddress getPhysicalAddress() {
                return null;
            }

            @Override
            public TimeScheduler getTimer() {
                return new TimeScheduler(1);
            }
        };
        transport.setId((short)101);
        this.nak.setDownProtocol(transport);
        this.nak.start();
    }

    @AfterMethod
    protected void tearDown() {
        this.nak.stop();
    }

    public void testSetDigest() throws TimeoutException {
        System.out.println("d1: " + this.d1);
        System.out.println("d2: " + this.d2);
        System.out.println("setting d2:");
        this.nak.down(new Event(41, this.d2));
        Digest digest = (Digest)this.nak.down(new Event(39));
        System.out.println("digest = " + digest);
        assert (digest.size() == 3);
        assert (digest.contains(this.a));
        assert (digest.contains(this.b));
        assert (digest.contains(this.c));
        System.out.println("setting d1:");
        this.nak.down(new Event(41, this.d1));
        digest = (Digest)this.nak.down(new Event(39));
        System.out.println("digest = " + digest);
        assert (digest.size() == 3);
        assert (digest.contains(this.a));
        assert (digest.contains(this.b));
        assert (digest.contains(this.c));
    }
}

