/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.beans.XmlStreamImportResult;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.WebHarvestStream;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.DateParser;
import com.jurismarches.vradi.services.managers.FormManager;
import com.jurismarches.vradi.services.managers.FormTypeManager;
import com.jurismarches.vradi.util.SSLUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;
import org.webharvest.definition.ScraperConfiguration;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.variables.Variable;

public class BindingManager {
    private static final Log log = LogFactory.getLog(BindingManager.class);
    protected WikittyProxy wikittyProxy;
    protected FormTypeManager formTypeManager;
    protected FormManager formManager;
    protected Timer timer;
    protected TimerTask xmlStreamTask;

    public BindingManager(WikittyProxy wikittyProxy, FormTypeManager formTypeManager, FormManager formManager) {
        this.wikittyProxy = wikittyProxy;
        this.formTypeManager = formTypeManager;
        this.formManager = formManager;
    }

    public List<XmlFieldBinding> getXmlFieldBindings(XmlStream xmlStream) {
        ArrayList<XmlFieldBinding> list = new ArrayList<XmlFieldBinding>();
        if (xmlStream != null && xmlStream.getXmlFieldBinding() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getXmlFieldBindings(" + xmlStream.getName() + ")"));
                log.debug((Object)xmlStream.getXmlFieldBinding());
            }
            ArrayList bindings = new ArrayList();
            bindings.addAll(xmlStream.getXmlFieldBinding());
            List restore = this.wikittyProxy.restore(XmlFieldBinding.class, bindings);
            list.addAll(restore);
        }
        return list;
    }

    public XmlFieldBinding getXmlFieldBinding(String xmlFieldBindingId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getXmlFieldBinding(" + xmlFieldBindingId + ")"));
        }
        XmlFieldBinding xmlFieldBinding = (XmlFieldBinding)this.wikittyProxy.restore(XmlFieldBinding.class, xmlFieldBindingId);
        return xmlFieldBinding;
    }

    public List<XmlStream> getAllXmlStreams() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllXmlStreams()");
        }
        ArrayList<XmlStream> result = new ArrayList<XmlStream>();
        Criteria criteriaXmlStream = Search.query().eq(Element.ELT_EXTENSION, "XmlStream").neq(Element.ELT_EXTENSION, "WebHarvestStream").criteria();
        PagedResult xmlStreams = this.wikittyProxy.findAllByCriteria(XmlStream.class, criteriaXmlStream);
        result.addAll(xmlStreams.getAll());
        Criteria criteriaWebHarvestStream = Search.query().eq(Element.ELT_EXTENSION, "XmlStream").eq(Element.ELT_EXTENSION, "WebHarvestStream").criteria();
        PagedResult xmlWebHarvestStream = this.wikittyProxy.findAllByCriteria(WebHarvestStream.class, criteriaWebHarvestStream);
        result.addAll(xmlWebHarvestStream.getAll());
        return result;
    }

    public List<WebHarvestStream> getAllWebHarvestStreams() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllWebHarvestStreams()");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "WebHarvestStream").criteria();
        PagedResult xmlStreams = this.wikittyProxy.findAllByCriteria(WebHarvestStream.class, criteria);
        List all = xmlStreams.getAll();
        ArrayList<WebHarvestStream> list = new ArrayList<WebHarvestStream>();
        list.addAll(all);
        return list;
    }

    public URI getWebHarvestPreviewUrl(WebHarvestStream stream) throws VradiException {
        String path = this.getWebHarvestPreviewPath(stream);
        File previewFile = new File(path);
        if (!previewFile.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Preview file doesnt exist, creating one for script path : " + path));
            }
            previewFile = this.createPreviewFile(stream);
        }
        URI uri = previewFile.toURI();
        return uri;
    }

    public String getWebHarvestPreviewUrlAsString(WebHarvestStream stream) throws VradiException {
        String uri = this.getWebHarvestPreviewUrl(stream).toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Previews url is : " + uri));
        }
        return uri;
    }

    public String getWebHarvestPreviewPath(WebHarvestStream stream) {
        File scriptFile = new File(VradiServiceConfiguration.getInstance(new String[0]).getWebHarvestScriptDir() + File.separator + stream.getScriptUrl());
        String previewPath = VradiServiceConfiguration.getInstance(new String[0]).getWebHarvestPreviewDir() + File.separator + "Preview" + scriptFile.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Previews path is : " + previewPath));
        }
        return previewPath;
    }

    public XmlStream getXmlStream(String xmlStreamId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getXmlStream(" + xmlStreamId + ")"));
        }
        XmlStream xmlStream = (XmlStream)this.wikittyProxy.restore(XmlStream.class, xmlStreamId);
        return xmlStream;
    }

    protected FormImpl createForm(WikittyExtension formType, List<XmlFieldBinding> bindings, org.jdom.Element feed, Namespace namespace, BindingContext bindingContext) throws VradiException {
        FormImpl form = new FormImpl();
        Wikitty wikitty = form.getWikitty();
        wikitty.addExtension(formType);
        for (XmlFieldBinding binding : bindings) {
            FieldType fieldType;
            String fqFormField = binding.getFormField();
            try {
                fieldType = wikitty.getFieldType(fqFormField);
            }
            catch (Exception e) {
                continue;
            }
            this.fillFormField(wikitty, fieldType, binding, feed, namespace, bindingContext);
        }
        return form;
    }

    protected void fillFormField(Wikitty wikitty, FieldType fieldType, XmlFieldBinding binding, org.jdom.Element feed, Namespace namespace, BindingContext bindingContext) throws VradiException {
        String fqFormField = binding.getFormField();
        Set xmlFields = binding.getXmlField();
        if (xmlFields == null || xmlFields.isEmpty()) {
            String defaultValue = binding.getDefaultValue();
            this.fillFormField2(wikitty, fieldType, fqFormField, defaultValue, bindingContext);
            return;
        }
        for (String xmlField : xmlFields) {
            org.jdom.Element child = feed.getChild(xmlField, namespace);
            String feedValue = null;
            if (child != null) {
                feedValue = child.getTextTrim();
            }
            if (feedValue == null || feedValue.isEmpty()) {
                feedValue = binding.getDefaultValue();
            }
            this.fillFormField2(wikitty, fieldType, fqFormField, feedValue, bindingContext);
        }
    }

    private void fillFormField2(Wikitty wikitty, FieldType fieldType, String fqFormField, String feedValue, BindingContext bindingContext) throws VradiException {
        if (feedValue == null || feedValue.isEmpty()) {
            return;
        }
        switch (fieldType.getType()) {
            case DATE: {
                Date date = DateParser.parse(feedValue);
                if (date != null) {
                    try {
                        wikitty.setFqField(fqFormField, (Object)WikittyUtil.formatDate((Date)date));
                        break;
                    }
                    catch (ParseException eee) {
                        throw new VradiException("Cant parse date " + date, eee);
                    }
                }
                ++bindingContext.dateParsingError;
                break;
            }
            case NUMERIC: {
                if (NumberUtils.isNumber((String)feedValue)) {
                    Double value = Double.valueOf(feedValue);
                    wikitty.setFqField(fqFormField, (Object)value);
                    break;
                }
                ++bindingContext.numberParsingError;
                break;
            }
            default: {
                Object fieldValue = wikitty.getFqField(fqFormField);
                String newValue = null;
                newValue = fieldValue != null ? fieldValue + "\n" + feedValue : feedValue;
                wikitty.setFqField(fqFormField, (Object)newValue);
            }
        }
    }

    public XmlStreamImportResult importFormsFromWebHarvestStream(WebHarvestStream webHarvestStream) throws VradiException {
        log.info((Object)("getFormsFromWebHarvestStream for " + webHarvestStream.getName()));
        File previewFile = this.createPreviewFile(webHarvestStream, true);
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(previewFile);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't read xml stream", (Throwable)e);
            }
            throw new VradiException("Can't read xml stream : ", e);
        }
        return this.getFormsFromStream(webHarvestStream, document);
    }

    public File createPreviewFile(WebHarvestStream webHarvestStream) throws VradiException {
        return this.createPreviewFile(webHarvestStream, false);
    }

    protected File createPreviewFile(WebHarvestStream webHarvestStream, boolean override) throws VradiException {
        String path = webHarvestStream.getScriptUrl();
        if (path == null) {
            return null;
        }
        path = VradiServiceConfiguration.getInstance(new String[0]).getWebHarvestPreviewDir() + File.separator + path;
        File scriptFile = new File(path);
        if (!override && scriptFile.exists()) {
            return scriptFile;
        }
        ScraperConfiguration config = null;
        try {
            config = new ScraperConfiguration(scriptFile);
        }
        catch (FileNotFoundException eee) {
            throw new VradiException("Cant open script " + webHarvestStream.getScriptUrl(), eee);
        }
        VradiServiceConfiguration appConfig = VradiServiceConfiguration.getInstance(new String[0]);
        Scraper scraper = new Scraper(config, appConfig.getDataDir());
        scraper.setDebug(log.isDebugEnabled());
        scraper.addVariableToContext("url", (Object)webHarvestStream.getUrl());
        long startTime = System.currentTimeMillis();
        scraper.execute();
        log.info((Object)("Script execution time elapsed: " + (System.currentTimeMillis() - startTime)));
        Variable resultVar = (Variable)scraper.getContext().get((Object)"result");
        String result = resultVar.toString();
        result = result.replaceAll("&", "&amp;");
        File previewFile = new File(path);
        try {
            FileUtils.writeStringToFile((File)previewFile, (String)result);
            log.info((Object)("Store preview for script " + scriptFile.getPath()));
        }
        catch (IOException eee) {
            log.error((Object)("Failed to write preview for script " + scriptFile.getName()), (Throwable)eee);
        }
        return previewFile;
    }

    public XmlStreamImportResult importFormsFromXmlStream(XmlStream xmlStream) throws VradiException {
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder(false);
            sxb.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            URL rssUrl = new URL(xmlStream.getUrl());
            log.info((Object)("Reading xmlStream url from: " + rssUrl));
            document = sxb.build(rssUrl);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't read xml stream", (Throwable)e);
            }
            throw new VradiException("Can't read xml stream : ", e);
        }
        return this.getFormsFromStream(xmlStream, document);
    }

    public <E extends XmlStream> XmlStreamImportResult getFormsFromStream(E stream, Document document) throws VradiException {
        XmlStreamImportResult result = new XmlStreamImportResult();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormsFromStream(" + stream.getName()));
        }
        if (stream.getFormTypeName() == null) {
            throw new VradiException("xmlStream.formTypeName is null");
        }
        WikittyExtension formType = this.formTypeManager.getFormType(stream.getFormTypeName());
        if (formType == null) {
            throw new VradiException("Extension of name xmlStream.formTypeName does not exists");
        }
        org.jdom.Element racine = document.getRootElement();
        Namespace namespace = racine.getNamespace("");
        List elements = null;
        if (racine.getChild("item", namespace) != null) {
            elements = racine.getChildren("item", namespace);
        } else if (racine.getChild("channel", namespace) != null) {
            org.jdom.Element channel = racine.getChild("channel", namespace);
            elements = channel.getChildren("item", namespace);
        } else if (racine.getChild("entry", namespace) != null) {
            elements = racine.getChildren("entry", namespace);
        }
        if (elements == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Enable to find items or entries in stream");
            }
            return result;
        }
        ArrayList<Form> forms = new ArrayList<Form>();
        ArrayList xmlFieldBindingIds = new ArrayList(stream.getXmlFieldBinding());
        List bindings = this.wikittyProxy.restore(XmlFieldBinding.class, xmlFieldBindingIds);
        String formDateId = VradiConstants.FORM_ID_DATE_FORMAT.format(new Date());
        String toTreatId = this.formManager.getNonTraiteStatus().getWikittyId();
        BindingContext bindingContext = new BindingContext();
        for (int index = 0; index < elements.size(); ++index) {
            org.jdom.Element feedElement = (org.jdom.Element)elements.get(index);
            StringBuffer sb = new StringBuffer();
            List fields = feedElement.getChildren();
            for (org.jdom.Element field : fields) {
                sb.append(field.getText());
            }
            String contentSHA1Hash = StringUtil.encodeSHA1((String)sb.toString());
            Criteria criteria = Search.query().eq("Form.importContentHash", contentSHA1Hash).criteria();
            criteria.setEndIndex(0);
            PagedResult pagesResult = this.wikittyProxy.findAllByCriteria(Form.class, criteria);
            if (pagesResult.getNumFound() > 0) {
                if (!log.isWarnEnabled()) break;
                log.warn((Object)"SHA1 content collision detected");
                break;
            }
            FormImpl form = this.createForm(formType, bindings, feedElement, namespace, bindingContext);
            ++bindingContext.nbCreated;
            form.setId(formDateId + form.getWikittyId());
            form.setXmlStream(stream.getWikittyId());
            form.setStatus(toTreatId);
            form.setImportContentHash(contentSHA1Hash);
            forms.add((Form)form);
            if (forms.size() <= 100) continue;
            this.formManager.updateForms(forms, null);
            forms.clear();
        }
        if (!forms.isEmpty()) {
            this.formManager.updateForms(forms, null);
        }
        result.setCreatedFormCount(bindingContext.nbCreated);
        result.setDateParsingError(bindingContext.dateParsingError);
        result.setNumberParsingError(bindingContext.numberParsingError);
        int alreadyExists = elements.size() - result.getCreatedFormCount();
        result.setAlreadyExistsFormCount(alreadyExists);
        if (log.isInfoEnabled()) {
            log.info((Object)("Form import from stream, created = " + result.getCreatedFormCount()));
            log.info((Object)("Form import from stream, already existing = " + result.getAlreadyExistsFormCount()));
            log.info((Object)("Form import from stream, dateParsingError = " + result.getDateParsingError()));
            log.info((Object)("Form import from stream, numberParsingError = " + result.getNumberParsingError()));
        }
        return result;
    }

    static {
        SSLUtils.intallCertificateTruster();
    }

    private static class BindingContext {
        int dateParsingError = 0;
        int numberParsingError = 0;
        int nbCreated = 0;

        private BindingContext() {
        }
    }
}

