/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

class LongConstValueSource
extends ValueSource {
    final long constant;

    public LongConstValueSource(long constant) {
        this.constant = constant;
    }

    public String description() {
        return "const(" + this.constant + ")";
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        return new DocValues(){

            public float floatVal(int doc) {
                return LongConstValueSource.this.constant;
            }

            public int intVal(int doc) {
                return (int)LongConstValueSource.this.constant;
            }

            public long longVal(int doc) {
                return LongConstValueSource.this.constant;
            }

            public double doubleVal(int doc) {
                return LongConstValueSource.this.constant;
            }

            public String strVal(int doc) {
                return Long.toString(LongConstValueSource.this.constant);
            }

            public String toString(int doc) {
                return LongConstValueSource.this.description();
            }
        };
    }

    public int hashCode() {
        return (int)this.constant + (int)(this.constant >>> 32);
    }

    public boolean equals(Object o) {
        if (LongConstValueSource.class != o.getClass()) {
            return false;
        }
        LongConstValueSource other = (LongConstValueSource)o;
        return this.constant == other.constant;
    }
}

