/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.FunctionQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.function.FunctionQuery;
import org.apache.solr.search.function.QueryValueSource;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.search.function.ValueSourceRangeFilter;

public class FunctionRangeQParserPlugin
extends QParserPlugin {
    public static String NAME = "frange";

    public void init(NamedList args) {
    }

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){
            ValueSource vs;
            String funcStr;

            public Query parse() throws ParseException {
                this.funcStr = this.localParams.get("v", null);
                Query funcQ = this.subQuery(this.funcStr, FunctionQParserPlugin.NAME).parse();
                this.vs = funcQ instanceof FunctionQuery ? ((FunctionQuery)funcQ).getValueSource() : new QueryValueSource(funcQ, 0.0f);
                String l = this.localParams.get("l");
                String u = this.localParams.get("u");
                boolean includeLower = this.localParams.getBool("incl", true);
                boolean includeUpper = this.localParams.getBool("incu", true);
                ValueSourceRangeFilter rf = new ValueSourceRangeFilter(this.vs, l, u, includeLower, includeUpper);
                SolrConstantScoreQuery csq = new SolrConstantScoreQuery(rf);
                return csq;
            }
        };
    }
}

