/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.FreqProxTermsWriterPerThread;
import org.apache.lucene.index.Payload;
import org.apache.lucene.index.RawPostingList;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashPerField;

final class FreqProxTermsWriterPerField
extends TermsHashConsumerPerField
implements Comparable {
    final FreqProxTermsWriterPerThread perThread;
    final TermsHashPerField termsHashPerField;
    final FieldInfo fieldInfo;
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState;
    boolean omitTermFreqAndPositions;
    PayloadAttribute payloadAttribute;
    boolean hasPayloads;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FreqProxTermsWriterPerField(TermsHashPerField termsHashPerField, FreqProxTermsWriterPerThread perThread, FieldInfo fieldInfo) {
        this.termsHashPerField = termsHashPerField;
        this.perThread = perThread;
        this.fieldInfo = fieldInfo;
        this.docState = termsHashPerField.docState;
        this.fieldState = termsHashPerField.fieldState;
        this.omitTermFreqAndPositions = fieldInfo.omitTermFreqAndPositions;
    }

    int getStreamCount() {
        if (this.fieldInfo.omitTermFreqAndPositions) {
            return 1;
        }
        return 2;
    }

    void finish() {
    }

    void skippingLongTerm() throws IOException {
    }

    public int compareTo(Object other0) {
        FreqProxTermsWriterPerField other = (FreqProxTermsWriterPerField)other0;
        return this.fieldInfo.name.compareTo(other.fieldInfo.name);
    }

    void reset() {
        this.omitTermFreqAndPositions = this.fieldInfo.omitTermFreqAndPositions;
        this.payloadAttribute = null;
    }

    boolean start(Fieldable[] fields, int count) {
        for (int i = 0; i < count; ++i) {
            if (!fields[i].isIndexed()) continue;
            return true;
        }
        return false;
    }

    void start(Fieldable f) {
        this.payloadAttribute = this.fieldState.attributeSource.hasAttribute(PayloadAttribute.class) ? (PayloadAttribute)this.fieldState.attributeSource.getAttribute(PayloadAttribute.class) : null;
    }

    final void writeProx(FreqProxTermsWriter.PostingList p, int proxCode) {
        Payload payload = this.payloadAttribute == null ? null : this.payloadAttribute.getPayload();
        if (payload != null && payload.length > 0) {
            this.termsHashPerField.writeVInt(1, proxCode << 1 | 1);
            this.termsHashPerField.writeVInt(1, payload.length);
            this.termsHashPerField.writeBytes(1, payload.data, payload.offset, payload.length);
            this.hasPayloads = true;
        } else {
            this.termsHashPerField.writeVInt(1, proxCode << 1);
        }
        p.lastPosition = this.fieldState.position;
    }

    final void newTerm(RawPostingList p0) {
        if (!$assertionsDisabled && !this.docState.testPoint("FreqProxTermsWriterPerField.newTerm start")) {
            throw new AssertionError();
        }
        FreqProxTermsWriter.PostingList p = (FreqProxTermsWriter.PostingList)p0;
        p.lastDocID = this.docState.docID;
        if (this.omitTermFreqAndPositions) {
            p.lastDocCode = this.docState.docID;
        } else {
            p.lastDocCode = this.docState.docID << 1;
            p.docFreq = 1;
            this.writeProx(p, this.fieldState.position);
        }
    }

    final void addTerm(RawPostingList p0) {
        if (!$assertionsDisabled && !this.docState.testPoint("FreqProxTermsWriterPerField.addTerm start")) {
            throw new AssertionError();
        }
        FreqProxTermsWriter.PostingList p = (FreqProxTermsWriter.PostingList)p0;
        if (!$assertionsDisabled && !this.omitTermFreqAndPositions && p.docFreq <= 0) {
            throw new AssertionError();
        }
        if (this.omitTermFreqAndPositions) {
            if (this.docState.docID != p.lastDocID) {
                if (!$assertionsDisabled && this.docState.docID <= p.lastDocID) {
                    throw new AssertionError();
                }
                this.termsHashPerField.writeVInt(0, p.lastDocCode);
                p.lastDocCode = this.docState.docID - p.lastDocID;
                p.lastDocID = this.docState.docID;
            }
        } else if (this.docState.docID != p.lastDocID) {
            if (!$assertionsDisabled && this.docState.docID <= p.lastDocID) {
                throw new AssertionError();
            }
            if (1 == p.docFreq) {
                this.termsHashPerField.writeVInt(0, p.lastDocCode | 1);
            } else {
                this.termsHashPerField.writeVInt(0, p.lastDocCode);
                this.termsHashPerField.writeVInt(0, p.docFreq);
            }
            p.docFreq = 1;
            p.lastDocCode = this.docState.docID - p.lastDocID << 1;
            p.lastDocID = this.docState.docID;
            this.writeProx(p, this.fieldState.position);
        } else {
            ++p.docFreq;
            this.writeProx(p, this.fieldState.position - p.lastPosition);
        }
    }

    public void abort() {
    }

    static {
        $assertionsDisabled = !FreqProxTermsWriterPerField.class.desiredAssertionStatus();
    }
}

