/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.services.FileService;
import com.jurismarches.vradi.services.VradiException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class FileServiceProxy
implements FileService {
    private static final Log log = LogFactory.getLog(FileServiceProxy.class);
    protected String serviceEndpoint;

    public FileServiceProxy(String serviceEndpoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using " + FileServiceProxy.class.getSimpleName() + " to manage file upload"));
        }
        this.serviceEndpoint = serviceEndpoint;
    }

    @Override
    public String uploadTemplate(File file, String extensionName) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.TEMPLATE.toString(), extensionName);
        return this.uploadFile(file, postUrl);
    }

    @Override
    public String uploadWebHarvestScript(File file) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.WEB_HARVEST.toString(), file.getName());
        return this.uploadFile(file, postUrl);
    }

    @Override
    public String uploadFormAttachment(File file, String formId) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.ATTACHMENTS_FORM_FILES.toString(), formId, file.getName());
        return this.uploadFile(file, postUrl);
    }

    @Override
    public String uploadTempFile(File file) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.TEMP_FILE.toString(), file.getName());
        return this.uploadFile(file, postUrl);
    }

    @Override
    public String uploadFormEmbeddedFile(File file, String formId) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.EMBEDDED_FORM_FILES.toString(), formId, file.getName());
        return this.uploadFile(file, postUrl);
    }

    protected String buildUrl(String endpoint, String ... additionalParams) {
        StringBuilder url = new StringBuilder(endpoint);
        if (url.lastIndexOf("/") == url.length() - 1) {
            url = url.delete(url.length() - 1, url.length());
        }
        for (String additionalParam : additionalParams) {
            url.append("/");
            url.append(additionalParam);
        }
        return url.toString();
    }

    protected String uploadFile(File file, String postUrl) throws VradiException {
        String uri;
        try {
            HttpClientParams params = new HttpClientParams();
            params.setConnectionManagerTimeout(8000L);
            HttpClient client = new HttpClient(params);
            PostMethod postMethod = new PostMethod(postUrl);
            Part[] parts = new Part[]{new FilePart(file.getName(), file)};
            MultipartRequestEntity requestEntity = new MultipartRequestEntity(parts, postMethod.getParams());
            postMethod.setRequestEntity((RequestEntity)requestEntity);
            int response = client.executeMethod((HttpMethod)postMethod);
            if (response != 200) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("File upload servlet response : " + response));
                }
                throw new VradiException(I18n._((String)"File upload failed : server response %d", (Object[])new Object[]{response}));
            }
            Header header = postMethod.getResponseHeader("fileuri");
            if (header == null || StringUtils.isEmpty((String)header.getValue())) {
                if (header != null && log.isErrorEnabled()) {
                    log.error((Object)("Can't read upload response as valid file uri : " + header.getValue()));
                }
                throw new VradiException(I18n._((String)"File upload failed : invalid response"));
            }
            uri = header.getValue();
            postMethod.releaseConnection();
        }
        catch (FileNotFoundException ex) {
            throw new VradiException("Can't upload file", ex);
        }
        catch (HttpException ex) {
            throw new VradiException("Can't upload file", ex);
        }
        catch (IOException ex) {
            throw new VradiException("Can't upload file", ex);
        }
        return uri;
    }

    protected File downloadFile(String fileUrl) throws VradiException {
        File resultFile;
        try {
            resultFile = File.createTempFile("vradi-", ".tmp");
            resultFile.deleteOnExit();
            URL url = new URL(fileUrl);
            FileUtils.copyURLToFile((URL)url, (File)resultFile);
            if (log.isDebugEnabled()) {
                log.debug((Object)("File downloaded to " + resultFile));
            }
        }
        catch (IOException ex) {
            throw new VradiException("Can't download file", ex);
        }
        return resultFile;
    }

    @Override
    public File downloadWebHarvestScript(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.WEB_HARVEST.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadTemplate(String extensionName, String templateName) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.TEMPLATE.toString(), extensionName, templateName);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadPDF(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.PDF.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadFormAttachment(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.ATTACHMENTS_FORM_FILES.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadFormEmbeddedFile(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.EMBEDDED_FORM_FILES.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadRequestHistory(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.QUERY_HISTORY.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public String getRequestHistoryURL(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, VradiConstants.FileType.QUERY_HISTORY.toString(), uri);
        return fileUrl;
    }
}

