/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.util.Tuple;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.annotations.Test;

public class JUnitXMLReporter
extends TestListenerAdapter
implements IInvokedMethodListener {
    private String output_dir = null;
    private String suffix = null;
    private static final String SUFFIX = "test.suffix";
    private static final String XML_DEF = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    private static final String CDATA = "![CDATA[";
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    private static final String SYSTEM_OUT = "system-out";
    private static final String SYSTEM_ERR = "system-err";
    private PrintStream old_stdout = System.out;
    private PrintStream old_stderr = System.err;
    private final ConcurrentMap<Class<?>, List<ITestResult>> classes = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Tuple<StringBuffer, StringBuffer>> outputs = new ConcurrentHashMap();
    public static InheritableThreadLocal<Class<?>> local = new InheritableThreadLocal();

    public void beforeInvocation(IInvokedMethod method, ITestResult tr) {
        Class real_class = tr.getTestClass().getRealClass();
        local.set(real_class);
        LinkedList results = (LinkedList)this.classes.get(real_class);
        if (results == null) {
            results = new LinkedList();
            this.classes.putIfAbsent(real_class, results);
        }
        this.outputs.putIfAbsent(real_class, new Tuple<StringBuffer, StringBuffer>(new StringBuffer(), new StringBuffer()));
    }

    public void afterInvocation(IInvokedMethod method, ITestResult tr) {
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult tr) {
        Class real_class = tr.getTestClass().getRealClass();
        this.addTest(real_class, tr);
        JUnitXMLReporter.print(this.old_stdout, "OK:   ", real_class.getName(), tr.getName());
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        Class real_class = tr.getTestClass().getRealClass();
        this.addTest(tr.getTestClass().getRealClass(), tr);
        JUnitXMLReporter.print(this.old_stdout, "OK:   ", real_class.getName(), tr.getName());
    }

    public void onTestFailure(ITestResult tr) {
        Class real_class = tr.getTestClass().getRealClass();
        this.addTest(tr.getTestClass().getRealClass(), tr);
        JUnitXMLReporter.print(this.old_stderr, "FAIL: ", real_class.getName(), tr.getName());
    }

    public void onTestSkipped(ITestResult tr) {
        Class real_class = tr.getTestClass().getRealClass();
        this.addTest(tr.getTestClass().getRealClass(), tr);
        JUnitXMLReporter.print(this.old_stdout, "SKIP: ", real_class.getName(), tr.getName());
    }

    private static void print(PrintStream out, String msg, String classname, String method_name) {
        out.println(msg + "[" + Thread.currentThread().getId() + "] " + classname + "." + method_name + "()");
    }

    private void addTest(Class<?> clazz, ITestResult result) {
        boolean allTestsInClassCompleted;
        List<ITestResult> results = (LinkedList)this.classes.get(clazz);
        if (results == null) {
            results = new LinkedList();
            this.classes.putIfAbsent(clazz, results);
        }
        results = (List)this.classes.get(clazz);
        results.add(result);
        ITestNGMethod[] testMethods = result.getMethod().getTestClass().getTestMethods();
        int enabledCount = this.enabledMethods(testMethods);
        boolean bl = allTestsInClassCompleted = results.size() >= enabledCount;
        if (allTestsInClassCompleted) {
            try {
                this.generateReport(clazz, results);
            }
            catch (IOException e) {
                JUnitXMLReporter.print(this.old_stderr, "Failed generating report: ", clazz.getName(), "");
            }
        }
    }

    private int enabledMethods(ITestNGMethod[] testMethods) {
        int count = testMethods.length;
        for (ITestNGMethod testNGMethod : testMethods) {
            Test annotation;
            Method m = testNGMethod.getMethod();
            if (!m.isAnnotationPresent(Test.class) || (annotation = m.getAnnotation(Test.class)).enabled()) continue;
            --count;
        }
        return count;
    }

    public void onStart(ITestContext context) {
        this.suffix = System.getProperty(SUFFIX);
        if (this.suffix != null) {
            this.suffix = this.suffix.trim();
        }
        this.output_dir = context.getOutputDirectory();
        try {
            System.setOut(new MyOutput("/tmp/tmp.txt", 1));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            System.setErr(new MyOutput("/tmp/tmp.txt", 2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void onFinish(ITestContext context) {
        System.setOut(this.old_stdout);
        System.setErr(this.old_stderr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateReport(Class<?> clazz, List<ITestResult> results) throws IOException {
        int num_failures = JUnitXMLReporter.getFailures(results);
        int num_skips = JUnitXMLReporter.getSkips(results);
        int num_errors = JUnitXMLReporter.getErrors(results);
        long total_time = JUnitXMLReporter.getTotalTime(results);
        String file_name = this.output_dir + File.separator + "TEST-" + clazz.getName();
        if (this.suffix != null) {
            file_name = file_name + "-" + this.suffix;
        }
        file_name = file_name + ".xml";
        FileWriter out = new FileWriter(file_name, false);
        try {
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            out.write("\n<testsuite  failures=\"" + num_failures + "\" errors=\"" + num_errors + "\" skips=\"" + num_skips + "\" name=\"" + clazz.getName());
            if (this.suffix != null) {
                out.write(" (" + this.suffix + ")");
            }
            out.write("\" tests=\"" + results.size() + "\" time=\"" + (double)total_time / 1000.0 + "\">");
            out.write("\n<properties>");
            Properties props = System.getProperties();
            for (Map.Entry<Object, Object> tmp : props.entrySet()) {
                out.write("\n    <property name=\"" + tmp.getKey() + "\"" + " value=\"" + tmp.getValue() + "\"/>");
            }
            out.write("\n</properties>\n");
            for (ITestResult result : results) {
                if (result == null) continue;
                long time = result.getEndMillis() - result.getStartMillis();
                out.write("\n    <testcase classname=\"" + clazz.getName());
                if (this.suffix != null) {
                    out.write(" (" + this.suffix + ")");
                }
                out.write("\" name=\"" + result.getMethod().getMethodName() + "\" time=\"" + (double)time / 1000.0 + "\">");
                Throwable ex = result.getThrowable();
                switch (result.getStatus()) {
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        JUnitXMLReporter.writeFailure("failure", result.getMethod().getMethod(), ex, "exception", out);
                        break;
                    }
                    case 3: {
                        JUnitXMLReporter.writeFailure("error", result.getMethod().getMethod(), ex, "SKIPPED", out);
                        break;
                    }
                    default: {
                        JUnitXMLReporter.writeFailure("error", result.getMethod().getMethod(), ex, "exception", out);
                    }
                }
                out.write("\n</testcase>");
            }
            Tuple stdout = (Tuple)this.outputs.get(clazz);
            if (stdout != null) {
                StringBuffer system_out = (StringBuffer)stdout.getVal1();
                StringBuffer system_err = (StringBuffer)stdout.getVal2();
                JUnitXMLReporter.writeOutput(out, system_out.toString(), 1);
                out.write("\n");
                JUnitXMLReporter.writeOutput(out, system_err.toString(), 2);
            }
            out.write("\n</testsuite>\n");
        }
        finally {
            out.close();
        }
    }

    private static void writeOutput(FileWriter out, String s, int type) throws IOException {
        if (s != null && s.length() > 0) {
            out.write("\n<" + (type == 2 ? SYSTEM_ERR : SYSTEM_OUT) + "><" + CDATA + "\n");
            out.write(s);
            out.write("\n]]>");
            out.write("\n</" + (type == 2 ? SYSTEM_ERR : SYSTEM_OUT) + ">");
        }
    }

    private static void writeFailure(String type, Method method, Throwable ex, String msg, FileWriter out) throws IOException {
        Test annotation = method.getAnnotation(Test.class);
        if (annotation != null && ex != null) {
            Class[] expected_exceptions = annotation.expectedExceptions();
            for (int i = 0; i < expected_exceptions.length; ++i) {
                Class expected_exception = expected_exceptions[i];
                if (!expected_exception.equals(ex.getClass())) continue;
                return;
            }
        }
        out.write("\n<" + type + " type=\"");
        if (ex != null) {
            out.write(ex.getClass().getName() + "\" message=\"" + JUnitXMLReporter.escape(ex.getMessage()) + "\">");
            JUnitXMLReporter.printException(ex, out);
        } else {
            out.write("exception\" message=\"" + msg + "\">");
        }
        out.write("\n</" + type + ">");
    }

    private static void printException(Throwable ex, FileWriter out) throws IOException {
        if (ex == null) {
            return;
        }
        StackTraceElement[] stack_trace = ex.getStackTrace();
        out.write("\n<![CDATA[\n");
        out.write(ex.getClass().getName() + " \n");
        for (int i = 0; i < stack_trace.length; ++i) {
            StackTraceElement frame = stack_trace[i];
            try {
                out.write("at " + frame.toString() + " \n");
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        out.write("\n]]>");
    }

    private static String escape(String message) {
        return message != null ? message.replaceAll("<", LT).replaceAll(">", GT) : message;
    }

    private static long getTotalTime(List<ITestResult> results) {
        long start = 0L;
        long stop = 0L;
        for (ITestResult result : results) {
            if (result == null) continue;
            long tmp_start = result.getStartMillis();
            long tmp_stop = result.getEndMillis();
            start = start == 0L ? tmp_start : Math.min(start, tmp_start);
            if (stop == 0L) {
                stop = tmp_stop;
                continue;
            }
            stop = Math.max(stop, tmp_stop);
        }
        return stop - start;
    }

    private static int getFailures(List<ITestResult> results) {
        int retval = 0;
        for (ITestResult result : results) {
            if (result == null || result.getStatus() != 2) continue;
            ++retval;
        }
        return retval;
    }

    private static int getErrors(List<ITestResult> results) {
        int retval = 0;
        for (ITestResult result : results) {
            if (result == null || result.getStatus() == 1 || result.getStatus() == 4 || result.getStatus() == 2) continue;
            ++retval;
        }
        return retval;
    }

    private static int getSkips(List<ITestResult> results) {
        int retval = 0;
        for (ITestResult result : results) {
            if (result == null || result.getStatus() != 3) continue;
            ++retval;
        }
        return retval;
    }

    class MyOutput
    extends PrintStream {
        final int type;

        public MyOutput(String fileName, int type) throws FileNotFoundException {
            super(fileName);
            this.type = type;
            if (type != 1 && type != 2) {
                throw new IllegalArgumentException("index has to be 1 or 2");
            }
        }

        @Override
        public void write(byte[] b) {
            String s = new String(b);
            this.append(s.trim(), false);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            String s = new String(b, off, len);
            this.append(s.trim(), false);
        }

        @Override
        public void write(int b) {
            Integer i = new Integer(b);
            this.append(i.toString(), false);
        }

        @Override
        public void println(String s) {
            this.append(s, true);
        }

        @Override
        public void print(String s) {
            this.append(s, false);
        }

        @Override
        public void print(Object obj) {
            if (obj != null) {
                this.append(obj.toString(), false);
            } else {
                this.append("null", false);
            }
        }

        @Override
        public void println(Object obj) {
            if (obj != null) {
                this.append(obj.toString(), true);
            } else {
                this.append("null", true);
            }
        }

        private synchronized void append(String x, boolean newline) {
            PrintStream stream;
            Tuple tuple;
            Class clazz = (Class)local.get();
            if (clazz != null && (tuple = (Tuple)JUnitXMLReporter.this.outputs.get(clazz)) != null) {
                StringBuffer sb;
                StringBuffer stringBuffer = sb = this.type == 1 ? (StringBuffer)tuple.getVal1() : (StringBuffer)tuple.getVal2();
                if (sb.length() == 0) {
                    sb.append("\n" + clazz.getName() + ":");
                }
                sb.append("\n").append(x);
                return;
            }
            PrintStream printStream = stream = this.type == 2 ? JUnitXMLReporter.this.old_stderr : JUnitXMLReporter.this.old_stdout;
            if (newline) {
                stream.println(x);
            } else {
                stream.print(x);
            }
        }
    }
}

