/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services;

import au.com.bytecode.opencsv.CSVWriter;
import com.herbocailleau.sgq.business.ServiceDAOHelper;
import com.herbocailleau.sgq.business.SgqBusinessConfig;
import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.AnalyzeFilter;
import com.herbocailleau.sgq.business.model.AnalyzeModel;
import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.model.PresentationModel;
import com.herbocailleau.sgq.business.model.SearchColumn;
import com.herbocailleau.sgq.business.model.SearchModel;
import com.herbocailleau.sgq.business.services.ConfigurationService;
import com.herbocailleau.sgq.business.services.csv.AnalyzeImportModel;
import com.herbocailleau.sgq.business.services.csv.BatchBean;
import com.herbocailleau.sgq.business.services.csv.BatchImportModel;
import com.herbocailleau.sgq.business.services.csv.InventoryBean;
import com.herbocailleau.sgq.business.services.csv.InventoryExportModel;
import com.herbocailleau.sgq.business.services.csv.InventoryImportModel;
import com.herbocailleau.sgq.entities.AnalyzeFile;
import com.herbocailleau.sgq.entities.AnalyzeFileDAO;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.AnalyzeTypeDAO;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.BatchAnalyzeDAO;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.BatchImpl;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.ClientDAO;
import com.herbocailleau.sgq.entities.Country;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.PlaceDAO;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.PresentationDAO;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductDAO;
import com.herbocailleau.sgq.entities.ProductPlace;
import com.herbocailleau.sgq.entities.ProductPlaceDAO;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SupplierDAO;
import com.herbocailleau.sgq.entities.Zone;
import com.itextpdf.text.DocumentException;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import nl.knaw.dans.common.dbflib.CorruptedTableException;
import nl.knaw.dans.common.dbflib.Record;
import nl.knaw.dans.common.dbflib.Table;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.csv.AbstractImportErrorInfo;
import org.nuiton.util.csv.Export;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.Import2;
import org.nuiton.util.csv.ImportConf;
import org.nuiton.util.csv.ImportModel;
import org.nuiton.util.csv.ImportRow;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class BatchService
extends SgqService {
    private static final Log log = LogFactory.getLog(BatchService.class);
    protected ConfigurationService configurationService = new ConfigurationService();

    @Override
    public void setConfig(SgqBusinessConfig config) {
        super.setConfig(config);
        this.configurationService.setConfig(config);
    }

    @Override
    public void setServiceDAOHelper(ServiceDAOHelper daoHelper) {
        super.setServiceDAOHelper(daoHelper);
        this.configurationService.setServiceDAOHelper(daoHelper);
    }

    public long getBatchCount() {
        long count = 0L;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            count = batchDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return count;
    }

    public long getOperatingBatchCount() {
        long count = 0L;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            count = batchDAO.countOperating();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return count;
    }

    public int getLastConventionalBatch() {
        int number = 0;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            number = batchDAO.getLastBatchNumber(this.config.getBatchRangeNonBioEnd());
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return number;
    }

    public int getLastBiologicalBatch() {
        int number = 0;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            number = batchDAO.getLastBatchNumber(this.config.getBatchRangeBioEnd());
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return number;
    }

    public long getAnalyzeCount() {
        long count = 0L;
        try {
            BatchAnalyzeDAO batchAnalyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
            count = batchAnalyzeDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return count;
    }

    public Pair<List<BatchModel>, Long> searchBatch(SearchModel search, int offset, int count) {
        Pair result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            List<BatchModel> elements = batchDAO.findAllModel(search, offset, count);
            elements = this.addBatchAnalyzeToModel(search, elements);
            Long totalCount = batchDAO.findAllCount(search);
            result = Pair.of(elements, (Object)totalCount);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't search batches", ex);
        }
        return result;
    }

    protected List<BatchModel> addBatchAnalyzeToModel(SearchModel search, List<BatchModel> elements) {
        if (search.getSearchColumns().contains((Object)SearchColumn.ANALYZE_CONFORMITY)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding analyzes list to batch model");
            }
            for (BatchModel model : elements) {
                List<BatchAnalyze> analyzes = this.findAllAnalyzesByBatch(model.getBatch());
                model.setBatchAnalyzes(analyzes);
            }
        }
        return elements;
    }

    public InputStream searchBatchASCsv(SearchModel search) {
        FileInputStream result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            List<BatchModel> elements = batchDAO.findAllModel(search);
            elements = this.addBatchAnalyzeToModel(search, elements);
            File file = File.createTempFile("sgq-products", ".csv");
            file.deleteOnExit();
            CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(file), ';');
            ArrayList<String> headers = new ArrayList<String>();
            for (SearchColumn searchColumn : search.getSearchColumns()) {
                headers.add(searchColumn.getDescription());
            }
            csvWriter.writeNext(headers.toArray(new String[headers.size()]));
            for (BatchModel batchModel : elements) {
                ArrayList<String> data = new ArrayList<String>(headers.size());
                for (SearchColumn searchColumn : search.getSearchColumns()) {
                    String content = searchColumn.getValueFor(search, batchModel);
                    if (content == null) {
                        data.add("");
                        continue;
                    }
                    data.add(content);
                }
                csvWriter.writeNext(data.toArray(new String[data.size()]));
            }
            csvWriter.close();
            result = new FileInputStream(file);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't search batches", ex);
        }
        catch (IOException ex) {
            throw new SgqBusinessException("Can't output csv file", ex);
        }
        return result;
    }

    public List<Batch> findAllBetweenNumbers(int startNumber, int endNumber) {
        List<Batch> result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.findAllBetweenNumbers(startNumber, endNumber);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't search batches", ex);
        }
        return result;
    }

    public MultiKeyMap findAllAnalyzesBetweenBatchNumbers(int startNumber, int endNumber) {
        MultiKeyMap result = null;
        try {
            BatchAnalyzeDAO batchAnalyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
            AnalyzeFilter filter = new AnalyzeFilter();
            filter.setBatchNumberBegin(startNumber);
            filter.setBatchNumberEnd(endNumber);
            List<BatchAnalyze> analyzes = batchAnalyzeDAO.findAllAnalyze(filter);
            result = new MultiKeyMap();
            for (BatchAnalyze analyze : analyzes) {
                result.put((Object)analyze.getBatch(), (Object)analyze.getAnalyzeType(), (Object)analyze);
            }
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't search batches", ex);
        }
        return result;
    }

    public Batch getBatchById(String batchId) {
        Batch result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = (Batch)batchDAO.findByTopiaId(batchId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public BatchModel getBatchModelById(String batchId) {
        BatchModel result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.findModelByTopiaId(batchId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    protected Batch getBatchByNumber(int batchNumer) {
        Batch result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = (Batch)batchDAO.findByNumber(batchNumer);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by number", ex);
        }
        return result;
    }

    public void saveBatch(Batch batch) {
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            batch = (Batch)batchDAO.update(batch);
            if (batch.getExpiredDate() != null) {
                PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
                List<Presentation> presentations = presentationDAO.findAllPresentationForbatch(batch);
                for (Presentation presentation : presentations) {
                    presentation.setQuantity(0.0);
                    presentation.clearInventoryPlaces();
                    presentationDAO.update(presentation);
                }
            }
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't save batch", ex);
        }
    }

    public List<Batch> getBatchWithMoreSellThanStock() {
        List<Batch> result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getBatchWithMoreSellThanStock();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find batch with more sell than stock", ex);
        }
        return result;
    }

    public List<Batch> getDedicatedClientExpiredBatch() {
        List<Batch> result;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getDedicatedClientExpiredBatch();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find expired batch", ex);
        }
        return result;
    }

    public List<Batch> getBatchWithNoStock() {
        List<Batch> result;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getBatchWithNoStock();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find batch without stock", ex);
        }
        return result;
    }

    public List<Batch> getBatchWithBulletinToAsk() {
        List<Batch> result;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getBatchWithBulletinToAsk();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find batch with bulletin to ask", ex);
        }
        return result;
    }

    public List<PresentationModel> findAllPresentationsByBatch(Batch batch) {
        List<PresentationModel> result = null;
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            result = presentationDAO.findAllByBatchOrderByPresentation(batch);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by batch", ex);
        }
        return result;
    }

    public Presentation getPresentationById(String presentationId) {
        Presentation result = null;
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            result = (Presentation)presentationDAO.findByTopiaId(presentationId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public void updatePresentation(Presentation presentation) {
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            presentationDAO.update(presentation);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't update", ex);
        }
    }

    public List<BatchAnalyze> findAllAnalyzesByBatch(Batch batch) {
        List<BatchAnalyze> analyzes = null;
        try {
            BatchAnalyzeDAO analyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
            analyzes = analyzeDAO.findAllByBatch(batch);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by batch", ex);
        }
        return analyzes;
    }

    public List<AnalyzeFile> findAllAnalyzeFilesByBatch(Batch batch) {
        List<AnalyzeFile> analyzeFiles = null;
        try {
            AnalyzeFileDAO analyzeFileDAO = this.daoHelper.getAnalyzeFileDAO();
            analyzeFiles = analyzeFileDAO.findAllByBatch(batch);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by batch", ex);
        }
        return analyzeFiles;
    }

    public List<AnalyzeFile> findAllAnalyzeFilesByAnalyze(BatchAnalyze analyze) {
        List<AnalyzeFile> analyzeFiles = null;
        try {
            AnalyzeFileDAO analyzeFileDAO = this.daoHelper.getAnalyzeFileDAO();
            analyzeFiles = analyzeFileDAO.findAllByBatchAnalyze(analyze);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by analyze", ex);
        }
        return analyzeFiles;
    }

    public BatchAnalyze getAnalyzeById(String analyzeId) {
        BatchAnalyze result = null;
        try {
            BatchAnalyzeDAO analyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
            result = (BatchAnalyze)analyzeDAO.findByTopiaId(analyzeId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public void saveAnalyze(BatchAnalyze analyze) {
        try {
            BatchAnalyzeDAO analyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
            analyzeDAO.create(analyze);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't create analyze", ex);
        }
    }

    public InputStream getAnalyzeDataStream(AnalyzeFile analyzeFile) {
        InputStream result = null;
        try {
            result = analyzeFile.getData().getBinaryStream();
        }
        catch (SQLException ex) {
            throw new SgqBusinessException("Can't get analyze input stream", ex);
        }
        return result;
    }

    public List<AnalyzeModel> getAnalysisToSend(AnalyzeFilter analyzeFilter) {
        ArrayList<AnalyzeModel> result = null;
        try {
            BatchAnalyzeDAO analyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
            List<BatchAnalyze> analyzes = analyzeDAO.findAllAnalyzeToSend(analyzeFilter);
            result = new ArrayList<AnalyzeModel>(analyzes.size());
            for (BatchAnalyze analyze : analyzes) {
                AnalyzeModel model = new AnalyzeModel(analyze);
                int analyzeDuration = analyze.getAnalyzeType().getDurationDays();
                Date dpmes = analyze.getBatch().getDpmes();
                if (dpmes != null) {
                    Date computedSendLimitDate = DateUtils.addDays((Date)dpmes, (int)(-analyzeDuration));
                    model.setComputedSendLimitDate(computedSendLimitDate);
                }
                Date computedReceiptLimitDate = DateUtils.addDays((Date)new Date(), (int)analyzeDuration);
                model.setComputedReceiptLimitDate(computedReceiptLimitDate);
                result.add(model);
            }
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analysis", ex);
        }
        return result;
    }

    public List<BatchAnalyze> getAnalysisToReceive(AnalyzeFilter analyzeFilter) {
        List<BatchAnalyze> result = null;
        try {
            BatchAnalyzeDAO analyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
            result = analyzeDAO.findAllAnalyzeToReceive(analyzeFilter);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analysis", ex);
        }
        return result;
    }

    public List<Batch> getBatchWithOutputAndPendingAnalysis() {
        List<Batch> result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getBatchWithOutputAndPendingAnalysis();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't execute request", ex);
        }
        return result;
    }

    @Deprecated
    public List<Batch> getBatchWithInputAndPendingAnalysis() {
        List<Batch> result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getBatchWithInputAndPendingAnalysis();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't execute request", ex);
        }
        return result;
    }

    public List<ImportLog<Batch>> importBatchFile(String filename, File batchFile) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing batch from file " + batchFile));
        }
        if (!StringUtils.endsWithIgnoreCase((CharSequence)filename, (CharSequence)".DBF")) {
            throw new SgqBusinessException("Le nom de fichier doit finir par l'extension DBF");
        }
        int nonBioStart = this.configurationService.getNextNonBioBatchNumber();
        int bioStart = this.configurationService.getNextBioBatchNumber();
        Table table = new Table(batchFile);
        ArrayList<ImportLog<Batch>> importLogs = new ArrayList<ImportLog<Batch>>();
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            int nonBioEnd = this.config.getBatchRangeNonBioEnd();
            int bioEnd = this.config.getBatchRangeBioEnd();
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
            table = new Table(batchFile, this.config.getImportDbfFileEncoding());
            table.open();
            int line = 0;
            Iterator recordIterator = table.recordIterator();
            while (recordIterator.hasNext()) {
                ++line;
                Record record = (Record)recordIterator.next();
                int num = record.getNumberValue("LOT_R").intValue();
                if (nonBioStart <= num && num <= nonBioEnd || bioStart <= num && num <= bioEnd) {
                    Date dateEntree = record.getDateValue("DATE_R");
                    String fournisseur = record.getStringValue("CODF_R").trim();
                    Number commande = record.getNumberValue("COMM_R");
                    Number colis = record.getNumberValue("COLIS_R");
                    Number poids = record.getNumberValue("POIDS_R");
                    String codeProduit = record.getStringValue("PROD_R").trim();
                    String codePays = record.getStringValue("CODP_R").trim();
                    String dluo = record.getStringValue("DLUO_R").trim();
                    String codeClient = record.getStringValue("CODC_R").trim();
                    String echantillon = record.getStringValue("ECH_R").trim();
                    String remarque = record.getStringValue("REM_R").trim();
                    String ignore = record.getStringValue("IG_R").trim();
                    String hash = SgqUtils.getSHA1Hash(df.format(dateEntree), fournisseur, String.valueOf(commande), String.valueOf(colis), String.valueOf(poids), codeProduit, codePays, dluo, echantillon, remarque, ignore);
                    Batch batch = this.getBatchByNumber(num);
                    if (batch == null) {
                        batch = new BatchImpl();
                    } else {
                        if (hash.equals(batch.getImportHash())) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Import hashcode unchanged for batch " + num));
                            continue;
                        }
                        batch.setImportHash(hash);
                    }
                    batch.setNumber(num);
                    boolean invalid = false;
                    if ("O".equalsIgnoreCase(ignore)) {
                        invalid = true;
                    }
                    batch.setInvalid(invalid);
                    ImportLog<Batch> importLog = new ImportLog<Batch>();
                    importLog.setLine(line);
                    importLog.setCode(String.valueOf(num));
                    importLogs.add(importLog);
                    PresentationCode codePres = null;
                    if (!invalid) {
                        if (commande == null || commande.intValue() < 0) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Num\u00e9ro de commande interne invalide : %d", (Object[])new Object[]{commande}));
                            continue;
                        }
                        if (codeProduit.length() == 6) {
                            codePres = PresentationCode.getPresentationCodeFor(codeProduit.charAt(0));
                            if (codePres == null) {
                                importLog.setError(true);
                                importLog.setMessage(I18n._((String)"Code pr\u00e9sentation inconnu : %s", (Object[])new Object[]{codeProduit}));
                                continue;
                            }
                            if (codePres == PresentationCode.A || codePres == PresentationCode.B || codePres == PresentationCode.D) {
                                importLog.setError(true);
                                importLog.setMessage(I18n._((String)"Code pr\u00e9sentation destin\u00e9 \u00e0 la vente seulement : %s", (Object[])new Object[]{codeProduit}));
                                continue;
                            }
                            codeProduit = (codePres == PresentationCode.F || codePres == PresentationCode.T) && codeProduit.charAt(1) == '0' ? codePres.getCode() + codeProduit.substring(2) : codeProduit.substring(1);
                        } else {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Code produit invalide (6 caract\u00e8res) : %s", (Object[])new Object[]{codeProduit}));
                            continue;
                        }
                        if (colis == null || colis.intValue() <= 0) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Nombre de colis invalide : %d", (Object[])new Object[]{colis}));
                            continue;
                        }
                        if (poids == null || poids.doubleValue() <= 0.0) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Poids invalide : %e", (Object[])new Object[]{poids}));
                            continue;
                        }
                        if (!dluo.matches("\\d\\d(/\\d\\d){2}")) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"DLUO, format de date invalide : %s", (Object[])new Object[]{dluo}));
                            continue;
                        }
                        if (codePays.isEmpty()) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Origine invalide : %s", (Object[])new Object[]{codePays}));
                            continue;
                        }
                        Country enumPays = null;
                        try {
                            enumPays = Country.valueOf(codePays);
                        }
                        catch (IllegalArgumentException ex) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Origine invalide : %s", (Object[])new Object[]{codePays}));
                            continue;
                        }
                        batch.setOrigin(enumPays);
                        Object supplier = supplierDAO.findByCode(fournisseur);
                        if (supplier == null) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Fournisseur inconnu : %s", (Object[])new Object[]{fournisseur}));
                            continue;
                        }
                        batch.setSupplier((Supplier)supplier);
                        Client client = null;
                        if (!codeClient.isEmpty() && (client = (Client)clientDAO.findByCode(codeClient)) == null) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Client d\u00e9di\u00e9 inconnu : %s", (Object[])new Object[]{codeClient}));
                            continue;
                        }
                        batch.setDedicatedClient(client);
                        Object product = productDAO.findByCode(codeProduit);
                        if (product == null) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Produit inconnu : %s", (Object[])new Object[]{codeProduit}));
                            continue;
                        }
                        batch.setProduct((Product)product);
                    }
                    if (!invalid) {
                        batch.setOrderNumber(commande.intValue());
                        batch.setDluo(df.parse(dluo));
                        batch.setEntryDate(dateEntree);
                        batch.setQuantity(poids.doubleValue());
                        batch.setPackageCount(colis.intValue());
                        batch.setSampleCode(echantillon);
                        if (StringUtils.isBlank((CharSequence)batch.getComment())) {
                            batch.setComment(remarque);
                        } else if (StringUtils.isNotBlank((CharSequence)remarque)) {
                            importLog.setMessage(I18n._((String)"Le commentaire du lot n'a pas \u00e9t\u00e9 mis \u00e0 jour (saisie d\u00e9j\u00e0 pr\u00e9sente dans le SGQ)", (Object[])new Object[0]));
                        }
                    }
                    if (batch.getTopiaId() == null) {
                        batch = (Batch)batchDAO.create(batch);
                        Date expiredDate = this.getBatchDefaultExpiratedDate(batch, codePres);
                        batch.setExpiredDate(expiredDate);
                        if (invalid) {
                            importLog.setMessage(I18n._((String)"Lot d\u00e9fini comme 'Ignor\u00e9' dans DBASE et non visible dans le SGQ", (Object[])new Object[0]));
                        } else {
                            importLog.setMessage(I18n._((String)"Lot import\u00e9", (Object[])new Object[0]));
                            Object presentation = presentationDAO.createByNaturalId(batch, codePres);
                            if (batch.getExpiredDate() == null) {
                                presentation.setQuantity(poids.doubleValue());
                            }
                            presentation.setOriginal(true);
                            presentationDAO.update((TopiaEntity)presentation);
                        }
                    } else {
                        batch = (Batch)batchDAO.update(batch);
                        if (StringUtils.isEmpty((CharSequence)importLog.getMessage())) {
                            importLog.setMessage(I18n._((String)"Lot mis \u00e0 jour", (Object[])new Object[0]));
                        }
                    }
                    importLog.setBean(batch);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping product " + num + " (out of range)"));
            }
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't commit modification in database", ex);
        }
        catch (IOException ex) {
            throw new SgqBusinessException("Can't read dfb file", ex);
        }
        catch (CorruptedTableException ex) {
            throw new SgqBusinessException(I18n._((String)"Format de fichier invalide ou corrompu", (Object[])new Object[0]), ex);
        }
        catch (ParseException ex) {
            throw new SgqBusinessException("Can't parse data", ex);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ex) {
                    throw new SgqBusinessException("Can't close dbf file", ex);
                }
            }
        }
        return importLogs;
    }

    protected Date getBatchDefaultExpiratedDate(Batch batch, PresentationCode presentationCode) {
        Date expiredDate = null;
        if (presentationCode == PresentationCode.F) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(batch.getEntryDate());
            calendar.add(6, 7);
            expiredDate = calendar.getTime();
        }
        return expiredDate;
    }

    public void prepareAnalyze(Batch batch, AnalyzeType analyzeType) {
        block4: {
            if (batch == null) {
                throw new NullPointerException("batch can't be null");
            }
            if (analyzeType == null) {
                throw new NullPointerException("analyzeType can't be null");
            }
            try {
                BatchAnalyzeDAO analyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
                BatchAnalyze analyze = (BatchAnalyze)analyzeDAO.create(new Object[0]);
                analyze.setCreationDate(new Date());
                analyze.setAnalyzeType(analyzeType);
                analyze.setBatch(batch);
                analyzeDAO.update(analyze);
                this.daoHelper.commit();
            }
            catch (TopiaException ex) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Can't prepare analyze", (Throwable)ex);
            }
        }
    }

    public void sendAnalyzeToSupplier(BatchAnalyze analyze, Date sentDate, Date receiveLimitDate, Supplier supplier) {
        block2: {
            try {
                BatchAnalyzeDAO analyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
                analyze.setSupplier(supplier);
                analyze.setSentDate(sentDate);
                analyze.setReceiptLimitDate(receiveLimitDate);
                analyzeDAO.update(analyze);
                this.daoHelper.commit();
            }
            catch (TopiaException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't send analyze to supplier", (Throwable)ex);
            }
        }
    }

    public void receiveAnalyzeFromSupplier(BatchAnalyze analyze, Supplier supplier) {
        block2: {
            try {
                BatchAnalyzeDAO analyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
                analyze.setSupplier(supplier);
                analyzeDAO.update(analyze);
                this.daoHelper.commit();
            }
            catch (TopiaException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't receive analyze from supplier", (Throwable)ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAnalyzeFile(Batch batch, BatchAnalyze analyze, String fileName, File file) {
        if (batch == null && analyze == null) {
            throw new NullPointerException("batch and analyze can't both be null");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Blob blob = Hibernate.createBlob((InputStream)is);
            ((InputStream)is).close();
            AnalyzeFileDAO analyzeFileDAO = this.daoHelper.getAnalyzeFileDAO();
            AnalyzeFile analyzeFile = (AnalyzeFile)analyzeFileDAO.create(new Object[0]);
            analyzeFile.setName(fileName);
            analyzeFile.setData(blob);
            analyzeFile.setBatch(batch);
            analyzeFile.setBatchAnalyze(analyze);
            this.daoHelper.commit();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't read file content", ex);
                catch (TopiaException ex2) {
                    throw new SgqBusinessException("Can't save file in database", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public AnalyzeFile getAnalyzeFileById(String analyzeFileId) {
        AnalyzeFile result = null;
        try {
            AnalyzeFileDAO analyzeFileDAO = this.daoHelper.getAnalyzeFileDAO();
            result = (AnalyzeFile)analyzeFileDAO.findByTopiaId(analyzeFileId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File generateControlFile(Batch batch) {
        File result = null;
        FileOutputStream os = null;
        try {
            String out = this.getControlHtmlContent(batch);
            result = File.createTempFile("sgq-control-", ".pdf");
            result.deleteOnExit();
            os = new FileOutputStream(result);
            ITextRenderer renderer = new ITextRenderer();
            URL baseUrl = BatchService.class.getResource("/ftl/botanic.ftl");
            String url = StringUtils.removeEnd((String)baseUrl.toExternalForm(), (String)"botanic.ftl");
            renderer.setDocumentFromString(out, url);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't generate control file", ex);
                catch (DocumentException ex2) {
                    throw new SgqBusinessException("Can't generate control file", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        return result;
    }

    protected String getControlHtmlContent(Batch batch) {
        Configuration freemarkerConfiguration = new Configuration();
        freemarkerConfiguration.setEncoding(Locale.getDefault(), "UTF-8");
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(BatchService.class, "/ftl");
        freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
        freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new BeansWrapper());
        String result = null;
        try {
            Template mapTemplate = null;
            if (batch.getProduct().isBotanicControl()) {
                mapTemplate = freemarkerConfiguration.getTemplate("botanic.ftl");
            } else if (batch.getProduct().isIdentificationControl()) {
                mapTemplate = freemarkerConfiguration.getTemplate("identification.ftl");
            } else {
                throw new IllegalArgumentException("Batch product doesn't define any control");
            }
            HashMap<String, Batch> root = new HashMap<String, Batch>();
            root.put("batch", batch);
            StringWriter out = new StringWriter();
            mapTemplate.process(root, (Writer)out);
            ((Writer)out).flush();
            result = ((Object)out).toString();
        }
        catch (IOException ex) {
            throw new SgqBusinessException("Can't generate control file", ex);
        }
        catch (TemplateException ex) {
            throw new SgqBusinessException("Can't generate control file", ex);
        }
        return result;
    }

    public String getControlFilename(Batch batch) {
        String result = null;
        result = batch.getProduct().isBotanicControl() ? "CB" : "CI";
        result = result + "_" + batch.getProduct().getName() + "_" + batch.getNumber() + ".pdf";
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recoverBatchFile(File file) {
        long before = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Recovering numero lot file " + file.getAbsolutePath()));
        }
        InputStreamReader reader = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            HashMap<String, Client> clients = new HashMap<String, Client>();
            for (Client client : clientDAO.findAll()) {
                clients.put(client.getCode(), client);
            }
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            HashMap<String, Supplier> suppliers = new HashMap<String, Supplier>();
            for (Supplier supplier : supplierDAO.findAll()) {
                suppliers.put(supplier.getCode(), supplier);
            }
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            HashMap<String, Product> products = new HashMap<String, Product>();
            for (Product product : productDAO.findAll()) {
                products.put(product.getCode(), product);
            }
            if (batchDAO.count() > 0L) {
                throw new SgqBusinessException("Can't recover batch file, if batch already exist in database !");
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(file), this.config.getImportCsvFileEncoding());
            BatchImportModel model = new BatchImportModel(suppliers, clients);
            ImportConf conf = new ImportConf();
            conf.setStrictMode(false);
            Import2 importCsv = Import2.newImport((ImportConf)conf, (ImportModel)model, (Reader)reader);
            for (ImportRow row : importCsv) {
                BatchBean bean = (BatchBean)row.getBean();
                if (row.isValid()) {
                    if (bean.isInvalid()) continue;
                    String beanProductCode = bean.getProductCode();
                    char presCode = beanProductCode.charAt(0);
                    String productCode = beanProductCode;
                    PresentationCode codePres = null;
                    try {
                        codePres = PresentationCode.getPresentationCodeFor(presCode);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new SgqBusinessException("Can't commit import with errors", ex);
                    }
                    productCode = (codePres == PresentationCode.F || codePres == PresentationCode.T) && productCode.charAt(1) == '0' ? codePres.getCode() + productCode.substring(2) : productCode.substring(1);
                    Product product = (Product)products.get(productCode);
                    if (product == null) {
                        throw new SgqBusinessException("Can't find product " + productCode);
                    }
                    Batch batch = new BatchImpl();
                    PropertyUtils.copyProperties((Object)batch, (Object)bean);
                    batch = (Batch)batchDAO.create(batch);
                    batch.setProduct(product);
                    Object presentation = presentationDAO.createByNaturalId(batch, codePres);
                    presentation.setOriginal(true);
                    if (batch.getExpiredDate() == null) {
                        presentation.setQuantity(batch.getQuantity());
                    }
                    presentationDAO.update((TopiaEntity)presentation);
                    continue;
                }
                Throwable cause = null;
                Iterator i$ = row.getErrors().iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        throw new SgqBusinessException("Can't commit import with errors", cause);
                    }
                    AbstractImportErrorInfo error = (AbstractImportErrorInfo)i$.next();
                    if (cause != null) continue;
                    cause = error.getCause();
                }
            }
            this.daoHelper.commit();
            ((Reader)reader).close();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't read csv file", ex);
                catch (TopiaException ex2) {
                    throw new SgqBusinessException("Can't commit modification in database", ex2);
                }
                catch (IllegalAccessException ex3) {
                    throw new SgqBusinessException("Can't copy properties", ex3);
                }
                catch (InvocationTargetException ex4) {
                    throw new SgqBusinessException("Can't copy properties", ex4);
                }
                catch (NoSuchMethodException ex5) {
                    throw new SgqBusinessException("Can't copy properties", ex5);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        if (log.isInfoEnabled()) {
            long after = System.currentTimeMillis();
            log.info((Object)("File imported in " + (after - before) + " ms"));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recoverAnalyzeFile(File analyzeFile) {
        long before = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Recovering analyze file " + analyzeFile.getAbsolutePath()));
        }
        InputStreamReader reader = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            BatchAnalyzeDAO batchAnalyzeDAO = this.daoHelper.getBatchAnalyzeDAO();
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            HashMap<String, Supplier> suppliers = new HashMap<String, Supplier>();
            for (Supplier supplier : supplierDAO.findAll()) {
                suppliers.put(supplier.getCode(), supplier);
            }
            AnalyzeTypeDAO analyzeTypeDAO = this.daoHelper.getAnalyzeTypeDAO();
            HashMap<String, AnalyzeType> analyzeTypes = new HashMap<String, AnalyzeType>();
            for (AnalyzeType analyzeType : analyzeTypeDAO.findAll()) {
                analyzeTypes.put(analyzeType.getName(), analyzeType);
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(analyzeFile), this.config.getImportCsvFileEncoding());
            AnalyzeImportModel model = new AnalyzeImportModel(batchDAO, analyzeTypes, suppliers);
            ImportConf conf = new ImportConf();
            conf.setStrictMode(false);
            Import2 importCsv = Import2.newImport((ImportConf)conf, (ImportModel)model, (Reader)reader);
            for (ImportRow row : importCsv) {
                BatchAnalyze bean = (BatchAnalyze)row.getBean();
                if (row.isValid()) {
                    bean.setCreationDate(bean.getSentDate());
                    batchAnalyzeDAO.create(bean);
                    continue;
                }
                Throwable cause = null;
                Iterator i$ = row.getErrors().iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        throw new SgqBusinessException("Can't commit import with errors", cause);
                    }
                    AbstractImportErrorInfo error = (AbstractImportErrorInfo)i$.next();
                    if (cause != null) continue;
                    cause = error.getCause();
                }
            }
            this.daoHelper.commit();
            ((Reader)reader).close();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't read csv file", ex);
                catch (TopiaException ex2) {
                    throw new SgqBusinessException("Can't commit modification in database", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        if (log.isInfoEnabled()) {
            long after = System.currentTimeMillis();
            log.info((Object)("File imported in " + (after - before) + " ms"));
        }
    }

    public Map<Place, List<PresentationModel>> findAllBatchPerPlacesAndProduct(Zone zone, Place place, String product) {
        HashMap<Place, List<PresentationModel>> result = new HashMap<Place, List<PresentationModel>>();
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            List<PresentationModel> presentationModels = presentationDAO.findAllNonExpiredValidModel(product);
            for (PresentationModel model : presentationModels) {
                List<Place> places = model.getPlaces();
                for (Place presPlace : places) {
                    if (place != null && !place.equals(presPlace) || zone != null && presPlace.getZone() != zone) continue;
                    ArrayList<PresentationModel> presList = (ArrayList<PresentationModel>)result.get(presPlace);
                    if (presList == null) {
                        presList = new ArrayList<PresentationModel>();
                        result.put(presPlace, presList);
                    }
                    presList.add(model);
                }
            }
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by batch", ex);
        }
        return result;
    }

    public InputStream exportInventory() {
        FileInputStream result = null;
        try {
            InventoryBean bean;
            File file = File.createTempFile("sgq-inventory-", ".csv");
            file.deleteOnExit();
            ProductPlaceDAO productPlaceDAO = this.daoHelper.getProductPlaceDAO();
            List productPlaces = productPlaceDAO.findAll();
            MultiKeyMap allPresentation = this.findAllPresentationsPerPlaceAndProduct();
            ArrayList<InventoryBean> beans = new ArrayList<InventoryBean>();
            for (ProductPlace productPlace : productPlaces) {
                List presentationModels = (List)allPresentation.get((Object)productPlace.getPlace(), (Object)productPlace.getProduct());
                boolean refPlaceFound = false;
                if (presentationModels != null) {
                    for (PresentationModel model : presentationModels) {
                        if (model.getPresentation().getPresentationCode() != productPlace.getPresentationCode()) continue;
                        InventoryBean bean2 = new InventoryBean();
                        bean2.setZone(productPlace.getPlace().getZone());
                        bean2.setPlace(productPlace.getPlace());
                        bean2.setPresentationCode(model.getPresentation().getPresentationCode());
                        bean2.setProduct(productPlace.getProduct());
                        bean2.setBatch(model.getPresentation().getBatch());
                        bean2.setDluo(model.getPresentation().getBatch().getDluo());
                        if (model.getPresentation().getQuantity() <= 0.0) {
                            bean2.setComment(I18n._((String)"le stock est th\u00e9oriquement vide pour ce lot", (Object[])new Object[0]));
                        }
                        beans.add(bean2);
                        refPlaceFound = true;
                    }
                }
                if (refPlaceFound) continue;
                bean = new InventoryBean();
                bean.setZone(productPlace.getPlace().getZone());
                bean.setPlace(productPlace.getPlace());
                bean.setProduct(productPlace.getProduct());
                bean.setPresentationCode(productPlace.getPresentationCode());
                beans.add(bean);
            }
            List presentationModels = (List)allPresentation.get((Object)this, (Object)this);
            if (presentationModels != null) {
                for (PresentationModel model : presentationModels) {
                    Presentation presentation = model.getPresentation();
                    bean = new InventoryBean();
                    bean.setPresentationCode(presentation.getPresentationCode());
                    bean.setBatch(presentation.getBatch());
                    bean.setProduct(presentation.getBatch().getProduct());
                    bean.setDluo(model.getPresentation().getBatch().getDluo());
                    if (model.getPresentation().getQuantity() <= 0.0) {
                        bean.setComment(I18n._((String)"le stock est th\u00e9oriquement vide pour ce lot", (Object[])new Object[0]));
                    }
                    beans.add(bean);
                }
            }
            InventoryExportModel model = new InventoryExportModel();
            String csv = Export.exportToString((ExportModel)model, beans, (Charset)Charset.forName(this.config.getImportCsvFileEncoding()));
            FileUtils.writeStringToFile((File)file, (String)csv, (String)this.config.getImportCsvFileEncoding());
            result = new FileInputStream(file);
        }
        catch (Exception ex) {
            throw new SgqBusinessException("Can't write csv file", ex);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImportLog<Batch>> importInventory(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing inventory from file " + file.getAbsolutePath()));
        }
        ArrayList<ImportLog<Batch>> importLogs = new ArrayList<ImportLog<Batch>>();
        InputStreamReader reader = null;
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            ProductPlaceDAO productPlaceDAO = this.daoHelper.getProductPlaceDAO();
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            PlaceDAO placeDAO = this.daoHelper.getPlaceDAO();
            List<Presentation> presentations = presentationDAO.findAllNonExpiredValid(null);
            HashMap<Batch, ArrayList<Presentation>> batchPresentations = new HashMap<Batch, ArrayList<Presentation>>();
            for (Presentation presentation : presentations) {
                Batch batch = presentation.getBatch();
                ArrayList<Presentation> presentationsForBatch = (ArrayList<Presentation>)batchPresentations.get(batch);
                if (presentationsForBatch == null) {
                    presentationsForBatch = new ArrayList<Presentation>();
                    batchPresentations.put(batch, presentationsForBatch);
                }
                presentationsForBatch.add(presentation);
            }
            List batches = batchDAO.findAll();
            HashMap<Integer, Batch> batchCache = new HashMap<Integer, Batch>();
            for (Batch batch : batches) {
                batchCache.put(batch.getNumber(), batch);
            }
            List allProducts = productDAO.findAll();
            HashMap<String, Product> productCache = new HashMap<String, Product>();
            for (Product product : allProducts) {
                productCache.put(product.getCode(), product);
            }
            List allPlaces = placeDAO.findAll();
            HashMap<String, Place> placeCache = new HashMap<String, Place>();
            for (Place place : allPlaces) {
                placeCache.put(place.getCode(), place);
            }
            List allProductPlaces = productPlaceDAO.findAll();
            MultiKeyMap productPlaceCache = new MultiKeyMap();
            for (ProductPlace productPlace : allProductPlaces) {
                productPlaceCache.put((Object)productPlace.getProduct(), (Object)productPlace.getPlace(), (Object)productPlace.getPresentationCode(), (Object)productPlace);
            }
            HashMap<Presentation, Double> presentationQuantity = new HashMap<Presentation, Double>();
            reader = new InputStreamReader((InputStream)new FileInputStream(file), this.config.getImportCsvFileEncoding());
            InventoryImportModel model = new InventoryImportModel(batchCache, placeCache, productCache);
            ImportConf conf = new ImportConf();
            conf.setStrictMode(false);
            Import2 importCsv = Import2.newImport((ImportConf)conf, (ImportModel)model, (Reader)reader);
            for (ImportRow row : importCsv) {
                ImportLog<Batch> importLog;
                InventoryBean bean = (InventoryBean)row.getBean();
                if (row.isValid()) {
                    double currentQuantity;
                    ImportLog<Batch> importLog22;
                    Double realQuantity = bean.getRealQuantity();
                    if (realQuantity == null) continue;
                    Batch batch = bean.getBatch();
                    PresentationCode presentationCode = bean.getPresentationCode();
                    if (batch == null) {
                        importLog = new ImportLog<Batch>(true);
                        importLog.setLine(row.getLineNumber());
                        importLog.setMessage(I18n._((String)"Lot manquant pour quantit\u00e9 relev\u00e9 : ligne %d", (Object[])new Object[]{row.getLineNumber()}));
                        importLog.setBean(batch);
                        importLogs.add(importLog);
                        continue;
                    }
                    if (batch.getExpiredDate() != null) {
                        importLog = new ImportLog(true);
                        importLog.setLine(row.getLineNumber());
                        importLog.setMessage(I18n._((String)"Impossible de modifier la quantit\u00e9 du lot expir\u00e9 : %d", (Object[])new Object[]{batch.getNumber()}));
                        importLog.setBean(batch);
                        importLogs.add(importLog);
                        continue;
                    }
                    if (!batch.getProduct().equals(bean.getProduct())) {
                        importLog = new ImportLog(true);
                        importLog.setLine(row.getLineNumber());
                        importLog.setMessage(I18n._((String)"Produit incorrect pour le lot %d : trouv\u00e9 %s, attendu %s", (Object[])new Object[]{batch.getNumber(), bean.getProduct().getCode(), batch.getProduct().getCode()}));
                        importLog.setBean(batch);
                        importLogs.add(importLog);
                        continue;
                    }
                    Place place = bean.getPlace();
                    if (place == null) {
                        importLog22 = new ImportLog<Batch>(true);
                        importLog22.setLine(row.getLineNumber());
                        importLog22.setMessage(I18n._((String)"L'emplacement est absent ou invalide pour le lot %d", (Object[])new Object[]{batch.getNumber()}));
                        importLog22.setBean(batch);
                        importLogs.add(importLog22);
                        continue;
                    }
                    if (presentationCode == null || presentationCode != PresentationCode._ && presentationCode != PresentationCode.M && presentationCode != PresentationCode.P) {
                        importLog22 = new ImportLog(true);
                        importLog22.setLine(row.getLineNumber());
                        importLog22.setMessage(I18n._((String)"La pr\u00e9sentation est requise et ne peut \u00eatre que ., M ou P pour le lot %d en zone %s, emplacement %s", (Object[])new Object[]{batch.getNumber(), place.getZone().name(), place.getCode()}));
                        importLog22.setBean(batch);
                        importLogs.add(importLog22);
                        continue;
                    }
                    if (!productPlaceCache.containsKey((Object)bean.getProduct(), (Object)place, (Object)presentationCode)) {
                        importLog22 = new ImportLog(true);
                        importLog22.setLine(row.getLineNumber());
                        importLog22.setMessage(I18n._((String)"Emplacement %s/%s invalide ou \u00e0 cr\u00e9er pour la plante %c%s", (Object[])new Object[]{bean.getZone(), bean.getPlace().getCode(), Character.valueOf(bean.getPresentationCode().getCode()), batch.getProduct().getCode()}));
                        importLog22.setBean(batch);
                        importLogs.add(importLog22);
                        continue;
                    }
                    if (realQuantity > batch.getQuantity()) {
                        importLog22 = new ImportLog(true);
                        importLog22.setLine(row.getLineNumber());
                        importLog22.setMessage(I18n._((String)"La quantit\u00e9 de la pr\u00e9sentation %c pour le lot %d (%.2f) est sup\u00e9rieure \u00e0 la quantit\u00e9 entr\u00e9e du lot (%.2f)", (Object[])new Object[]{Character.valueOf(presentationCode.getCode()), batch.getNumber(), realQuantity, batch.getQuantity()}));
                        importLog22.setBean(batch);
                        importLogs.add(importLog22);
                        continue;
                    }
                    Presentation presentation = null;
                    for (Presentation presentationForBatch : (List)batchPresentations.get(batch)) {
                        if (presentationForBatch.getPresentationCode() != bean.getPresentationCode()) continue;
                        presentation = presentationForBatch;
                        break;
                    }
                    if (presentation == null) {
                        presentation = presentationDAO.createByNaturalId(batch, presentationCode);
                        ArrayList<Presentation> presentationsForBatch = (ArrayList<Presentation>)batchPresentations.get(batch);
                        if (presentationsForBatch == null) {
                            presentationsForBatch = new ArrayList<Presentation>();
                            batchPresentations.put(batch, presentationsForBatch);
                        }
                        presentationsForBatch.add(presentation);
                    }
                    if ((currentQuantity = presentation.getQuantity()) != realQuantity) {
                        Double previousQuantity = (Double)presentationQuantity.get(presentation);
                        if (previousQuantity == null) {
                            previousQuantity = 0.0;
                        }
                        ImportLog<Batch> importLog3 = new ImportLog<Batch>();
                        importLog3.setLine(row.getLineNumber());
                        importLog3.setMessage(I18n._((String)"Mise \u00e0 jour de la quantit\u00e9 relev\u00e9e pour le lot %d (presentation %c) de %.2f \u00e0 %.2f", (Object[])new Object[]{batch.getNumber(), Character.valueOf(presentationCode.getCode()), currentQuantity, realQuantity}));
                        importLog3.setBean(batch);
                        importLogs.add(importLog3);
                        presentation.setQuantity(previousQuantity + realQuantity);
                        if (presentation.getInventoryPlaces() == null || !presentation.getInventoryPlaces().contains(place)) {
                            presentation.addInventoryPlaces(place);
                        }
                        presentationDAO.update(presentation);
                    }
                    presentationQuantity.put(presentation, presentation.getQuantity());
                    continue;
                }
                Set rowErrors = row.getErrors();
                for (AbstractImportErrorInfo rowError : rowErrors) {
                    importLog = new ImportLog(true);
                    importLog.setLine(row.getLineNumber());
                    importLog.setMessage(rowError.getCause().getMessage());
                    importLogs.add(importLog);
                }
            }
            this.daoHelper.commit();
            ((Reader)reader).close();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't import inventory", ex);
                catch (TopiaException ex2) {
                    throw new SgqBusinessException("Can't import inventory", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return importLogs;
    }

    protected MultiKeyMap findAllPresentationsPerPlaceAndProduct() {
        MultiKeyMap result = new MultiKeyMap();
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            List<PresentationModel> presentationModels = presentationDAO.findAllNonExpiredValidModel(null);
            for (PresentationModel model : presentationModels) {
                List<Place> places = model.getPlaces();
                if (CollectionUtils.isEmpty(places)) {
                    ArrayList<PresentationModel> presList = (ArrayList<PresentationModel>)result.get((Object)this, (Object)this);
                    if (presList == null) {
                        presList = new ArrayList<PresentationModel>();
                        result.put((Object)this, (Object)this, presList);
                    }
                    presList.add(model);
                    continue;
                }
                for (Place presPlace : places) {
                    Product product;
                    ArrayList<PresentationModel> presList = (ArrayList<PresentationModel>)result.get((Object)presPlace, (Object)(product = model.getPresentation().getBatch().getProduct()));
                    if (presList == null) {
                        presList = new ArrayList<PresentationModel>();
                        result.put((Object)presPlace, (Object)product, presList);
                    }
                    presList.add(model);
                }
            }
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by batch", ex);
        }
        return result;
    }

    public void deleteAnalyzeFile(AnalyzeFile analyzeFile) {
        try {
            AnalyzeFileDAO analyzeFileDao = this.daoHelper.getAnalyzeFileDAO();
            analyzeFileDao.delete(analyzeFile);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't delete analyze file", ex);
        }
    }

    public void deleteAnalyze(BatchAnalyze analyze) {
        try {
            BatchAnalyzeDAO batchAnalyzeDao = this.daoHelper.getBatchAnalyzeDAO();
            batchAnalyzeDao.delete(analyze);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't delete analyze", ex);
        }
    }

    public Date getBatchMaxEntryDate() {
        Date result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getMaxEntryDate();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }
}

