/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Expedition;
import com.herbocailleau.sgq.entities.ExpeditionDAO;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.Production;
import com.herbocailleau.sgq.entities.ProductionDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PresentationDAOAbstract<E extends Presentation>
extends TopiaDAOImpl<E> {
    public Class<E> getEntityClass() {
        return Presentation.class;
    }

    public SGQDAOHelper.SGQEntityEnum getTopiaEntityEnum() {
        return SGQDAOHelper.SGQEntityEnum.Presentation;
    }

    public void delete(E entity) throws TopiaException {
        List list = this.getContext().getDAO(Expedition.class).findAllByProperties("presentation", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getPresentation())) continue;
            item.setPresentation(null);
        }
        list = this.getContext().getDAO(Production.class).findAllByProperties("presentation", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getPresentation())) continue;
            item.setPresentation(null);
        }
        list = this.getContext().getDAO(Production.class).findAllByProperties("correction", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getCorrection())) continue;
            item.setCorrection(null);
        }
        list = this.getContext().getDAO(Expedition.class).findAllByProperties("correction", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getCorrection())) continue;
            item.setCorrection(null);
        }
        super.delete(entity);
    }

    public E findByNaturalId(Batch batch, PresentationCode presentationCode) throws TopiaException {
        return (E)((Presentation)this.findByProperties("batch", batch, new Object[]{"presentationCode", presentationCode}));
    }

    public boolean existByNaturalId(Batch batch, PresentationCode presentationCode) throws TopiaException {
        return this.existByProperties("batch", batch, new Object[]{"presentationCode", presentationCode});
    }

    @Deprecated
    public E create(Batch batch, PresentationCode presentationCode) throws TopiaException {
        return (E)((Presentation)this.create(new Object[]{"batch", batch, "presentationCode", presentationCode}));
    }

    public E createByNaturalId(Batch batch, PresentationCode presentationCode) throws TopiaException {
        return (E)((Presentation)this.create(new Object[]{"batch", batch, "presentationCode", presentationCode}));
    }

    public E createByNotNull(Batch batch, PresentationCode presentationCode) throws TopiaException {
        return (E)((Presentation)this.create(new Object[]{"batch", batch, "presentationCode", presentationCode}));
    }

    public E findByQuantity(double v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("quantity", v);
        return (E)result;
    }

    public List<E> findAllByQuantity(double v) throws TopiaException {
        List result = this.findAllByProperty("quantity", v);
        return result;
    }

    public E findByDmesd(Date v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("dmesd", v);
        return (E)result;
    }

    public List<E> findAllByDmesd(Date v) throws TopiaException {
        List result = this.findAllByProperty("dmesd", v);
        return result;
    }

    public E findByOriginal(boolean v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("original", v);
        return (E)result;
    }

    public List<E> findAllByOriginal(boolean v) throws TopiaException {
        List result = this.findAllByProperty("original", v);
        return result;
    }

    public E findByBatch(Batch v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("batch", v);
        return (E)result;
    }

    public List<E> findAllByBatch(Batch v) throws TopiaException {
        List result = this.findAllByProperty("batch", v);
        return result;
    }

    public E findByPresentationCode(PresentationCode v) throws TopiaException {
        Presentation result = (Presentation)this.findByProperty("presentationCode", (Object)v);
        return (E)result;
    }

    public List<E> findAllByPresentationCode(PresentationCode v) throws TopiaException {
        List result = this.findAllByProperty("presentationCode", (Object)v);
        return result;
    }

    public E findContainsInventoryPlaces(Place v) throws TopiaException {
        Presentation result = (Presentation)this.findContains("inventoryPlaces", v);
        return (E)result;
    }

    public List<E> findAllContainsInventoryPlaces(Place v) throws TopiaException {
        List result = this.findAllContains("inventoryPlaces", v);
        return result;
    }

    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List tmp;
        TopiaDAOImpl dao;
        ArrayList result = new ArrayList();
        if (type == Production.class) {
            dao = (ProductionDAO)this.getContext().getDAO(Production.class);
            tmp = dao.findAllByPresentation((Presentation)entity);
            result.addAll(tmp);
        }
        if (type == Production.class) {
            dao = (ProductionDAO)this.getContext().getDAO(Production.class);
            tmp = dao.findAllByCorrection((Presentation)entity);
            result.addAll(tmp);
        }
        if (type == Expedition.class) {
            dao = (ExpeditionDAO)this.getContext().getDAO(Expedition.class);
            tmp = dao.findAllByPresentation((Presentation)entity);
            result.addAll(tmp);
        }
        if (type == Expedition.class) {
            dao = (ExpeditionDAO)this.getContext().getDAO(Expedition.class);
            tmp = dao.findAllByCorrection((Presentation)entity);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);
        List<Object> list = this.findUsages(Production.class, entity);
        if (!list.isEmpty()) {
            result.put(Production.class, list);
        }
        if (!(list = this.findUsages(Expedition.class, entity)).isEmpty()) {
            result.put(Expedition.class, list);
        }
        return result;
    }
}

