package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class ProductPlaceAbstract extends TopiaEntityAbstract implements ProductPlace {

    /**
     * Nom de l'attribut en BD : presentationCode
     */
    protected PresentationCode presentationCode;

    /**
     * Nom de l'attribut en BD : product
     */
    protected Product product;

    /**
     * Nom de l'attribut en BD : place
     */
    protected Place place;

    private static final long serialVersionUID = 3486174670333753188L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_PRESENTATION_CODE, PresentationCode.class, presentationCode);
        visitor.visit(this, PROPERTY_PRODUCT, Product.class, product);
        visitor.visit(this, PROPERTY_PLACE, Place.class, place);
        visitor.end(this);
    }

    @Override
    public void setPresentationCode(PresentationCode presentationCode) {
        PresentationCode oldValue = this.presentationCode;
        fireOnPreWrite(PROPERTY_PRESENTATION_CODE, oldValue, presentationCode);
        this.presentationCode = presentationCode;
        fireOnPostWrite(PROPERTY_PRESENTATION_CODE, oldValue, presentationCode);
    }

    @Override
    public PresentationCode getPresentationCode() {
        fireOnPreRead(PROPERTY_PRESENTATION_CODE, presentationCode);
        PresentationCode result = this.presentationCode;
        fireOnPostRead(PROPERTY_PRESENTATION_CODE, presentationCode);
        return result;
    }

    @Override
    public void setProduct(Product product) {
        Product oldValue = this.product;
        fireOnPreWrite(PROPERTY_PRODUCT, oldValue, product);
        this.product = product;
        fireOnPostWrite(PROPERTY_PRODUCT, oldValue, product);
    }

    @Override
    public Product getProduct() {
        fireOnPreRead(PROPERTY_PRODUCT, product);
        Product result = this.product;
        fireOnPostRead(PROPERTY_PRODUCT, product);
        return result;
    }

    @Override
    public void setPlace(Place place) {
        Place oldValue = this.place;
        fireOnPreWrite(PROPERTY_PLACE, oldValue, place);
        this.place = place;
        fireOnPostWrite(PROPERTY_PLACE, oldValue, place);
    }

    @Override
    public Place getPlace() {
        fireOnPreRead(PROPERTY_PLACE, place);
        Place result = this.place;
        fireOnPostRead(PROPERTY_PLACE, place);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //ProductPlaceAbstract
