/*
 * #%L
 * SGQ :: Business
 * $Id: SgqUtils.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-business/src/main/java/com/herbocailleau/sgq/business/SgqUtils.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

import java.io.IOException;

import org.xBaseJ.DBF;

public class SgqUtils {

    /**
     * Close dbf file.
     * 
     * @param file file to close
     */
    public static void closeFile(DBF file) {
        if (file != null) {
            try {
                file.close();
            } catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /**
     * Return true if client is an internal client (production/expedition process).
     * 
     * @param config config to get internal client id
     * @param clientId client id to test
     * @return true or false
     */
    public static boolean isInternalClient(SgqBusinessConfig config, int clientId) {
        boolean result = false;
        result |= config.getClientInternalSite1() == clientId;
        result |= config.getClientInternalSite2() == clientId;
        result |= config.getClientInternalSite3() == clientId;
        return result;
    }
}
