/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.TenantDatabasePendingModifiedValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TenantDatabase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TenantDatabase> {
    private static final SdkField<Instant> TENANT_DATABASE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TenantDatabaseCreateTime").getter(TenantDatabase.getter(TenantDatabase::tenantDatabaseCreateTime)).setter(TenantDatabase.setter(Builder::tenantDatabaseCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabaseCreateTime").build()}).build();
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(TenantDatabase.getter(TenantDatabase::dbInstanceIdentifier)).setter(TenantDatabase.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> TENANT_DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantDBName").getter(TenantDatabase.getter(TenantDatabase::tenantDBName)).setter(TenantDatabase.setter(Builder::tenantDBName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDBName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TenantDatabase.getter(TenantDatabase::status)).setter(TenantDatabase.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(TenantDatabase.getter(TenantDatabase::masterUsername)).setter(TenantDatabase.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbiResourceId").getter(TenantDatabase.getter(TenantDatabase::dbiResourceId)).setter(TenantDatabase.setter(Builder::dbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()}).build();
    private static final SdkField<String> TENANT_DATABASE_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantDatabaseResourceId").getter(TenantDatabase.getter(TenantDatabase::tenantDatabaseResourceId)).setter(TenantDatabase.setter(Builder::tenantDatabaseResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabaseResourceId").build()}).build();
    private static final SdkField<String> TENANT_DATABASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantDatabaseARN").getter(TenantDatabase.getter(TenantDatabase::tenantDatabaseARN)).setter(TenantDatabase.setter(Builder::tenantDatabaseARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabaseARN").build()}).build();
    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CharacterSetName").getter(TenantDatabase.getter(TenantDatabase::characterSetName)).setter(TenantDatabase.setter(Builder::characterSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()}).build();
    private static final SdkField<String> NCHAR_CHARACTER_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NcharCharacterSetName").getter(TenantDatabase.getter(TenantDatabase::ncharCharacterSetName)).setter(TenantDatabase.setter(Builder::ncharCharacterSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NcharCharacterSetName").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(TenantDatabase.getter(TenantDatabase::deletionProtection)).setter(TenantDatabase.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<TenantDatabasePendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingModifiedValues").getter(TenantDatabase.getter(TenantDatabase::pendingModifiedValues)).setter(TenantDatabase.setter(Builder::pendingModifiedValues)).constructor(TenantDatabasePendingModifiedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(TenantDatabase.getter(TenantDatabase::tagList)).setter(TenantDatabase.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_DATABASE_CREATE_TIME_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, TENANT_DB_NAME_FIELD, STATUS_FIELD, MASTER_USERNAME_FIELD, DBI_RESOURCE_ID_FIELD, TENANT_DATABASE_RESOURCE_ID_FIELD, TENANT_DATABASE_ARN_FIELD, CHARACTER_SET_NAME_FIELD, NCHAR_CHARACTER_SET_NAME_FIELD, DELETION_PROTECTION_FIELD, PENDING_MODIFIED_VALUES_FIELD, TAG_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant tenantDatabaseCreateTime;
    private final String dbInstanceIdentifier;
    private final String tenantDBName;
    private final String status;
    private final String masterUsername;
    private final String dbiResourceId;
    private final String tenantDatabaseResourceId;
    private final String tenantDatabaseARN;
    private final String characterSetName;
    private final String ncharCharacterSetName;
    private final Boolean deletionProtection;
    private final TenantDatabasePendingModifiedValues pendingModifiedValues;
    private final List<Tag> tagList;

    private TenantDatabase(BuilderImpl builder) {
        this.tenantDatabaseCreateTime = builder.tenantDatabaseCreateTime;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.tenantDBName = builder.tenantDBName;
        this.status = builder.status;
        this.masterUsername = builder.masterUsername;
        this.dbiResourceId = builder.dbiResourceId;
        this.tenantDatabaseResourceId = builder.tenantDatabaseResourceId;
        this.tenantDatabaseARN = builder.tenantDatabaseARN;
        this.characterSetName = builder.characterSetName;
        this.ncharCharacterSetName = builder.ncharCharacterSetName;
        this.deletionProtection = builder.deletionProtection;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.tagList = builder.tagList;
    }

    public final Instant tenantDatabaseCreateTime() {
        return this.tenantDatabaseCreateTime;
    }

    public final String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public final String tenantDBName() {
        return this.tenantDBName;
    }

    public final String status() {
        return this.status;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String dbiResourceId() {
        return this.dbiResourceId;
    }

    public final String tenantDatabaseResourceId() {
        return this.tenantDatabaseResourceId;
    }

    public final String tenantDatabaseARN() {
        return this.tenantDatabaseARN;
    }

    public final String characterSetName() {
        return this.characterSetName;
    }

    public final String ncharCharacterSetName() {
        return this.ncharCharacterSetName;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final TenantDatabasePendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDatabaseCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDBName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDatabaseResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDatabaseARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ncharCharacterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TenantDatabase)) {
            return false;
        }
        TenantDatabase other = (TenantDatabase)obj;
        return Objects.equals(this.tenantDatabaseCreateTime(), other.tenantDatabaseCreateTime()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.tenantDBName(), other.tenantDBName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.dbiResourceId(), other.dbiResourceId()) && Objects.equals(this.tenantDatabaseResourceId(), other.tenantDatabaseResourceId()) && Objects.equals(this.tenantDatabaseARN(), other.tenantDatabaseARN()) && Objects.equals(this.characterSetName(), other.characterSetName()) && Objects.equals(this.ncharCharacterSetName(), other.ncharCharacterSetName()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList());
    }

    public final String toString() {
        return ToString.builder((String)"TenantDatabase").add("TenantDatabaseCreateTime", (Object)this.tenantDatabaseCreateTime()).add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("TenantDBName", (Object)this.tenantDBName()).add("Status", (Object)this.status()).add("MasterUsername", (Object)this.masterUsername()).add("DbiResourceId", (Object)this.dbiResourceId()).add("TenantDatabaseResourceId", (Object)this.tenantDatabaseResourceId()).add("TenantDatabaseARN", (Object)this.tenantDatabaseARN()).add("CharacterSetName", (Object)this.characterSetName()).add("NcharCharacterSetName", (Object)this.ncharCharacterSetName()).add("DeletionProtection", (Object)this.deletionProtection()).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("TagList", this.hasTagList() ? this.tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TenantDatabaseCreateTime": {
                return Optional.ofNullable(clazz.cast(this.tenantDatabaseCreateTime()));
            }
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "TenantDBName": {
                return Optional.ofNullable(clazz.cast(this.tenantDBName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "DbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbiResourceId()));
            }
            case "TenantDatabaseResourceId": {
                return Optional.ofNullable(clazz.cast(this.tenantDatabaseResourceId()));
            }
            case "TenantDatabaseARN": {
                return Optional.ofNullable(clazz.cast(this.tenantDatabaseARN()));
            }
            case "CharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.characterSetName()));
            }
            case "NcharCharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.ncharCharacterSetName()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "PendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TenantDatabase, T> g) {
        return obj -> g.apply((TenantDatabase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant tenantDatabaseCreateTime;
        private String dbInstanceIdentifier;
        private String tenantDBName;
        private String status;
        private String masterUsername;
        private String dbiResourceId;
        private String tenantDatabaseResourceId;
        private String tenantDatabaseARN;
        private String characterSetName;
        private String ncharCharacterSetName;
        private Boolean deletionProtection;
        private TenantDatabasePendingModifiedValues pendingModifiedValues;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TenantDatabase model) {
            this.tenantDatabaseCreateTime(model.tenantDatabaseCreateTime);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.tenantDBName(model.tenantDBName);
            this.status(model.status);
            this.masterUsername(model.masterUsername);
            this.dbiResourceId(model.dbiResourceId);
            this.tenantDatabaseResourceId(model.tenantDatabaseResourceId);
            this.tenantDatabaseARN(model.tenantDatabaseARN);
            this.characterSetName(model.characterSetName);
            this.ncharCharacterSetName(model.ncharCharacterSetName);
            this.deletionProtection(model.deletionProtection);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.tagList(model.tagList);
        }

        public final Instant getTenantDatabaseCreateTime() {
            return this.tenantDatabaseCreateTime;
        }

        public final void setTenantDatabaseCreateTime(Instant tenantDatabaseCreateTime) {
            this.tenantDatabaseCreateTime = tenantDatabaseCreateTime;
        }

        @Override
        public final Builder tenantDatabaseCreateTime(Instant tenantDatabaseCreateTime) {
            this.tenantDatabaseCreateTime = tenantDatabaseCreateTime;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getTenantDBName() {
            return this.tenantDBName;
        }

        public final void setTenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
        }

        @Override
        public final Builder tenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final String getTenantDatabaseResourceId() {
            return this.tenantDatabaseResourceId;
        }

        public final void setTenantDatabaseResourceId(String tenantDatabaseResourceId) {
            this.tenantDatabaseResourceId = tenantDatabaseResourceId;
        }

        @Override
        public final Builder tenantDatabaseResourceId(String tenantDatabaseResourceId) {
            this.tenantDatabaseResourceId = tenantDatabaseResourceId;
            return this;
        }

        public final String getTenantDatabaseARN() {
            return this.tenantDatabaseARN;
        }

        public final void setTenantDatabaseARN(String tenantDatabaseARN) {
            this.tenantDatabaseARN = tenantDatabaseARN;
        }

        @Override
        public final Builder tenantDatabaseARN(String tenantDatabaseARN) {
            this.tenantDatabaseARN = tenantDatabaseARN;
            return this;
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getNcharCharacterSetName() {
            return this.ncharCharacterSetName;
        }

        public final void setNcharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
        }

        @Override
        public final Builder ncharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final TenantDatabasePendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(TenantDatabasePendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(TenantDatabasePendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TenantDatabase build() {
            return new TenantDatabase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TenantDatabase> {
        public Builder tenantDatabaseCreateTime(Instant var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder tenantDBName(String var1);

        public Builder status(String var1);

        public Builder masterUsername(String var1);

        public Builder dbiResourceId(String var1);

        public Builder tenantDatabaseResourceId(String var1);

        public Builder tenantDatabaseARN(String var1);

        public Builder characterSetName(String var1);

        public Builder ncharCharacterSetName(String var1);

        public Builder deletionProtection(Boolean var1);

        public Builder pendingModifiedValues(TenantDatabasePendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<TenantDatabasePendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((TenantDatabasePendingModifiedValues)((TenantDatabasePendingModifiedValues.Builder)TenantDatabasePendingModifiedValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);
    }
}

