/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyEventSubscriptionRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyEventSubscriptionRequest.Builder, ModifyEventSubscriptionRequest> {
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionName").getter(getter(ModifyEventSubscriptionRequest::subscriptionName))
            .setter(setter(Builder::subscriptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(ModifyEventSubscriptionRequest::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(ModifyEventSubscriptionRequest::sourceType))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventCategories")
            .getter(getter(ModifyEventSubscriptionRequest::eventCategories))
            .setter(setter(Builder::eventCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EventCategory")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EventCategory").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(ModifyEventSubscriptionRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_NAME_FIELD,
            SNS_TOPIC_ARN_FIELD, SOURCE_TYPE_FIELD, EVENT_CATEGORIES_FIELD, ENABLED_FIELD));

    private final String subscriptionName;

    private final String snsTopicArn;

    private final String sourceType;

    private final List<String> eventCategories;

    private final Boolean enabled;

    private ModifyEventSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
        this.snsTopicArn = builder.snsTopicArn;
        this.sourceType = builder.sourceType;
        this.eventCategories = builder.eventCategories;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The name of the RDS event notification subscription.
     * </p>
     * 
     * @return The name of the RDS event notification subscription.
     */
    public final String subscriptionName() {
        return subscriptionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS
     * when you create a topic and subscribe to it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by
     *         Amazon SNS when you create a topic and subscribe to it.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The type of source that is generating the events. For example, if you want to be notified of events generated by
     * a DB instance, you would set this parameter to db-instance. For RDS Proxy events, specify <code>db-proxy</code>.
     * If this value isn't specified, all events are returned.
     * </p>
     * <p>
     * Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
     * <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
     * <code>db-proxy</code>
     * </p>
     * 
     * @return The type of source that is generating the events. For example, if you want to be notified of events
     *         generated by a DB instance, you would set this parameter to db-instance. For RDS Proxy events, specify
     *         <code>db-proxy</code>. If this value isn't specified, all events are returned.</p>
     *         <p>
     *         Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
     *         <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
     *         <code>db-proxy</code>
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventCategories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventCategories() {
        return eventCategories != null && !(eventCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event categories for a source type (<code>SourceType</code>) that you want to subscribe to. You can see
     * a list of the categories for a given source type in <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon RDS
     * User Guide</i> or by using the <code>DescribeEventCategories</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventCategories} method.
     * </p>
     * 
     * @return A list of event categories for a source type (<code>SourceType</code>) that you want to subscribe to. You
     *         can see a list of the categories for a given source type in <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the
     *         <i>Amazon RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation.
     */
    public final List<String> eventCategories() {
        return eventCategories;
    }

    /**
     * <p>
     * Specifies whether to activate the subscription.
     * </p>
     * 
     * @return Specifies whether to activate the subscription.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventCategories() ? eventCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEventSubscriptionRequest)) {
            return false;
        }
        ModifyEventSubscriptionRequest other = (ModifyEventSubscriptionRequest) obj;
        return Objects.equals(subscriptionName(), other.subscriptionName()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(sourceType(), other.sourceType()) && hasEventCategories() == other.hasEventCategories()
                && Objects.equals(eventCategories(), other.eventCategories()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyEventSubscriptionRequest").add("SubscriptionName", subscriptionName())
                .add("SnsTopicArn", snsTopicArn()).add("SourceType", sourceType())
                .add("EventCategories", hasEventCategories() ? eventCategories() : null).add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionName":
            return Optional.ofNullable(clazz.cast(subscriptionName()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "EventCategories":
            return Optional.ofNullable(clazz.cast(eventCategories()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyEventSubscriptionRequest, T> g) {
        return obj -> g.apply((ModifyEventSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyEventSubscriptionRequest> {
        /**
         * <p>
         * The name of the RDS event notification subscription.
         * </p>
         * 
         * @param subscriptionName
         *        The name of the RDS event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionName(String subscriptionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon
         * SNS when you create a topic and subscribe to it.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by
         *        Amazon SNS when you create a topic and subscribe to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The type of source that is generating the events. For example, if you want to be notified of events generated
         * by a DB instance, you would set this parameter to db-instance. For RDS Proxy events, specify
         * <code>db-proxy</code>. If this value isn't specified, all events are returned.
         * </p>
         * <p>
         * Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
         * <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
         * <code>db-proxy</code>
         * </p>
         * 
         * @param sourceType
         *        The type of source that is generating the events. For example, if you want to be notified of events
         *        generated by a DB instance, you would set this parameter to db-instance. For RDS Proxy events, specify
         *        <code>db-proxy</code>. If this value isn't specified, all events are returned.</p>
         *        <p>
         *        Valid Values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> |
         *        <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> |
         *        <code>db-proxy</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * A list of event categories for a source type (<code>SourceType</code>) that you want to subscribe to. You can
         * see a list of the categories for a given source type in <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon
         * RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation.
         * </p>
         * 
         * @param eventCategories
         *        A list of event categories for a source type (<code>SourceType</code>) that you want to subscribe to.
         *        You can see a list of the categories for a given source type in <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the
         *        <i>Amazon RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(Collection<String> eventCategories);

        /**
         * <p>
         * A list of event categories for a source type (<code>SourceType</code>) that you want to subscribe to. You can
         * see a list of the categories for a given source type in <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon
         * RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation.
         * </p>
         * 
         * @param eventCategories
         *        A list of event categories for a source type (<code>SourceType</code>) that you want to subscribe to.
         *        You can see a list of the categories for a given source type in <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the
         *        <i>Amazon RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(String... eventCategories);

        /**
         * <p>
         * Specifies whether to activate the subscription.
         * </p>
         * 
         * @param enabled
         *        Specifies whether to activate the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String subscriptionName;

        private String snsTopicArn;

        private String sourceType;

        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyEventSubscriptionRequest model) {
            super(model);
            subscriptionName(model.subscriptionName);
            snsTopicArn(model.snsTopicArn);
            sourceType(model.sourceType);
            eventCategories(model.eventCategories);
            enabled(model.enabled);
        }

        public final String getSubscriptionName() {
            return subscriptionName;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final Collection<String> getEventCategories() {
            if (eventCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return eventCategories;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String... eventCategories) {
            eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyEventSubscriptionRequest build() {
            return new ModifyEventSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
