/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOptionGroupOptionsResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeOptionGroupOptionsResponse.Builder, DescribeOptionGroupOptionsResponse> {
    private static final SdkField<List<OptionGroupOption>> OPTION_GROUP_OPTIONS_FIELD = SdkField
            .<List<OptionGroupOption>> builder(MarshallingType.LIST)
            .memberName("OptionGroupOptions")
            .getter(getter(DescribeOptionGroupOptionsResponse::optionGroupOptions))
            .setter(setter(Builder::optionGroupOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OptionGroupOption")
                            .memberFieldInfo(
                                    SdkField.<OptionGroupOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionGroupOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OptionGroupOption").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeOptionGroupOptionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUP_OPTIONS_FIELD,
            MARKER_FIELD));

    private final List<OptionGroupOption> optionGroupOptions;

    private final String marker;

    private DescribeOptionGroupOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.optionGroupOptions = builder.optionGroupOptions;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionGroupOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionGroupOptions() {
        return optionGroupOptions != null && !(optionGroupOptions instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the OptionGroupOptions property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionGroupOptions} method.
     * </p>
     * 
     * @return The value of the OptionGroupOptions property for this object.
     */
    public final List<OptionGroupOption> optionGroupOptions() {
        return optionGroupOptions;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionGroupOptions() ? optionGroupOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOptionGroupOptionsResponse)) {
            return false;
        }
        DescribeOptionGroupOptionsResponse other = (DescribeOptionGroupOptionsResponse) obj;
        return hasOptionGroupOptions() == other.hasOptionGroupOptions()
                && Objects.equals(optionGroupOptions(), other.optionGroupOptions()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOptionGroupOptionsResponse")
                .add("OptionGroupOptions", hasOptionGroupOptions() ? optionGroupOptions() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptionGroupOptions":
            return Optional.ofNullable(clazz.cast(optionGroupOptions()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOptionGroupOptionsResponse, T> g) {
        return obj -> g.apply((DescribeOptionGroupOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeOptionGroupOptionsResponse> {
        /**
         * Sets the value of the OptionGroupOptions property for this object.
         *
         * @param optionGroupOptions
         *        The new value for the OptionGroupOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupOptions(Collection<OptionGroupOption> optionGroupOptions);

        /**
         * Sets the value of the OptionGroupOptions property for this object.
         *
         * @param optionGroupOptions
         *        The new value for the OptionGroupOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupOptions(OptionGroupOption... optionGroupOptions);

        /**
         * Sets the value of the OptionGroupOptions property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.OptionGroupOption.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.OptionGroupOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.OptionGroupOption.Builder#build()} is called immediately and
         * its result is passed to {@link #optionGroupOptions(List<OptionGroupOption>)}.
         * 
         * @param optionGroupOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.OptionGroupOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionGroupOptions(java.util.Collection<OptionGroupOption>)
         */
        Builder optionGroupOptions(Consumer<OptionGroupOption.Builder>... optionGroupOptions);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private List<OptionGroupOption> optionGroupOptions = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOptionGroupOptionsResponse model) {
            super(model);
            optionGroupOptions(model.optionGroupOptions);
            marker(model.marker);
        }

        public final List<OptionGroupOption.Builder> getOptionGroupOptions() {
            List<OptionGroupOption.Builder> result = OptionGroupOptionsListCopier.copyToBuilder(this.optionGroupOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionGroupOptions(Collection<OptionGroupOption.BuilderImpl> optionGroupOptions) {
            this.optionGroupOptions = OptionGroupOptionsListCopier.copyFromBuilder(optionGroupOptions);
        }

        @Override
        public final Builder optionGroupOptions(Collection<OptionGroupOption> optionGroupOptions) {
            this.optionGroupOptions = OptionGroupOptionsListCopier.copy(optionGroupOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptions(OptionGroupOption... optionGroupOptions) {
            optionGroupOptions(Arrays.asList(optionGroupOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptions(Consumer<OptionGroupOption.Builder>... optionGroupOptions) {
            optionGroupOptions(Stream.of(optionGroupOptions).map(c -> OptionGroupOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeOptionGroupOptionsResponse build() {
            return new DescribeOptionGroupOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
