/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.ExpressionType;
import com.amazonaws.s3.model.InputSerialization;
import com.amazonaws.s3.model.OutputSerialization;
import java.util.Objects;

public class SelectParameters {
    InputSerialization inputSerialization;
    ExpressionType expressionType;
    String expression;
    OutputSerialization outputSerialization;

    SelectParameters() {
        this.inputSerialization = null;
        this.expressionType = null;
        this.expression = "";
        this.outputSerialization = null;
    }

    protected SelectParameters(BuilderImpl builder) {
        this.inputSerialization = builder.inputSerialization;
        this.expressionType = builder.expressionType;
        this.expression = builder.expression;
        this.outputSerialization = builder.outputSerialization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(SelectParameters.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof SelectParameters;
    }

    public InputSerialization inputSerialization() {
        return this.inputSerialization;
    }

    public ExpressionType expressionType() {
        return this.expressionType;
    }

    public String expression() {
        return this.expression;
    }

    public OutputSerialization outputSerialization() {
        return this.outputSerialization;
    }

    protected static class BuilderImpl
    implements Builder {
        InputSerialization inputSerialization;
        ExpressionType expressionType;
        String expression;
        OutputSerialization outputSerialization;

        protected BuilderImpl() {
        }

        private BuilderImpl(SelectParameters model) {
            this.inputSerialization(model.inputSerialization);
            this.expressionType(model.expressionType);
            this.expression(model.expression);
            this.outputSerialization(model.outputSerialization);
        }

        @Override
        public SelectParameters build() {
            return new SelectParameters(this);
        }

        @Override
        public final Builder inputSerialization(InputSerialization inputSerialization) {
            this.inputSerialization = inputSerialization;
            return this;
        }

        @Override
        public final Builder expressionType(ExpressionType expressionType) {
            this.expressionType = expressionType;
            return this;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        @Override
        public final Builder outputSerialization(OutputSerialization outputSerialization) {
            this.outputSerialization = outputSerialization;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public InputSerialization inputSerialization() {
            return this.inputSerialization;
        }

        public ExpressionType expressionType() {
            return this.expressionType;
        }

        public String expression() {
            return this.expression;
        }

        public OutputSerialization outputSerialization() {
            return this.outputSerialization;
        }
    }

    public static interface Builder {
        public Builder inputSerialization(InputSerialization var1);

        public Builder expressionType(ExpressionType var1);

        public Builder expression(String var1);

        public Builder outputSerialization(OutputSerialization var1);

        public SelectParameters build();
    }
}

