/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.css.CssLintProcessor;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintError;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintException;
import ro.isdc.wro.extensions.support.lint.LintReport;
import ro.isdc.wro.extensions.support.lint.ReportXmlFormatter;
import ro.isdc.wro.extensions.support.lint.ResourceLintReport;
import ro.isdc.wro.maven.plugin.AbstractSingleProcessorMojo;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

public class CssLintMojo
extends AbstractSingleProcessorMojo {
    private File reportFile;
    private LintReport<CssLintError> lintReport;

    protected ResourcePreProcessor createResourceProcessor() {
        CssLintProcessor processor = new CssLintProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                if (resource != null) {
                    CssLintMojo.this.getLog().info((CharSequence)("processing resource: " + resource.getUri()));
                }
                super.process(resource, reader, (Writer)new StringWriter());
            }

            protected void onException(WroRuntimeException e) {
                CssLintMojo.this.onException((Exception)e);
            }

            protected void onCssLintException(CssLintException e, Resource resource) throws Exception {
                CssLintMojo.this.getLog().error((CharSequence)(e.getErrors().size() + " errors found while processing resource: " + resource.getUri() + " Errors are: " + e.getErrors()));
                CssLintMojo.this.lintReport.addReport(ResourceLintReport.create((String)resource.getUri(), (Collection)e.getErrors()));
                if (!CssLintMojo.this.isFailNever()) {
                    throw new MojoExecutionException("Errors found when validating resource: " + resource);
                }
            }
        }.setOptions(new String[]{this.getOptions()});
        return processor;
    }

    protected void onBeforeExecute() {
        this.lintReport = new LintReport();
        FileUtils.deleteQuietly((File)this.reportFile);
    }

    protected void onAfterExecute() {
        if (this.reportFile != null) {
            try {
                this.reportFile.getParentFile().mkdirs();
                this.reportFile.createNewFile();
                this.getLog().debug((CharSequence)("creating report at location: " + this.reportFile));
                ReportXmlFormatter.createForCssLintError(this.lintReport, (ReportXmlFormatter.FormatterType)ReportXmlFormatter.FormatterType.CSSLINT).write((OutputStream)new FileOutputStream(this.reportFile));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could not create report file: " + this.reportFile), (Throwable)e);
            }
        }
    }

    void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    void onException(Exception e) {
    }
}

