/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.packer;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class PackerJs {
    private static final Logger LOG = LoggerFactory.getLogger(PackerJs.class);

    private RhinoScriptBuilder initScriptBuilder() {
        LOG.debug("Initialising a new script builder");
        try {
            return RhinoScriptBuilder.newChain().evaluateChain(this.getStreamForBase2(), "base2.min.js").evaluateChain(this.getStreamForPacker(), "packer.min.js");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed reading init script", ex);
        }
    }

    protected InputStream getStreamForBase2() {
        return PackerJs.class.getResourceAsStream("base2.min.js");
    }

    protected InputStream getStreamForPacker() {
        return PackerJs.class.getResourceAsStream("packer.min.js");
    }

    public String pack(String data) throws IOException {
        StopWatch watch = new StopWatch();
        watch.start("init");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        watch.stop();
        watch.start("pack");
        String packIt = this.buildPackScript(WroUtil.toJSMultiLineString((String)data));
        Object result = builder.evaluate(packIt, "packerIt");
        watch.stop();
        LOG.debug(watch.prettyPrint());
        return String.valueOf(result);
    }

    protected String buildPackScript(String data) {
        return "new Packer().pack(" + data + ", true, true);";
    }
}

