/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.csslint;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintError;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintException;
import ro.isdc.wro.extensions.processor.support.linter.OptionsBuilder;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class CssLint {
    private static final Logger LOG = LoggerFactory.getLogger(CssLint.class);
    private static final String DEFAULT_CSSLINT_JS = "csslint.min.js";
    private final OptionsBuilder optionsBuilder = new OptionsBuilder();
    private String options;
    private ScriptableObject scope;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder = null;
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newChain().evaluateChain(this.getScriptAsStream(), DEFAULT_CSSLINT_JS);
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed reading init script", ex);
        }
    }

    protected InputStream getScriptAsStream() {
        return CssLint.class.getResourceAsStream(DEFAULT_CSSLINT_JS);
    }

    public void validate(String data) throws CssLintException {
        StopWatch watch = new StopWatch();
        watch.start("init");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        watch.stop();
        watch.start("cssLint");
        LOG.debug("options: {}", (Object)this.options);
        String script = this.buildCssLintScript(WroUtil.toJSMultiLineString((String)data));
        LOG.debug("script: {}", (Object)script);
        builder.evaluate(script, "CSSLint.verify").toString();
        boolean valid = Boolean.parseBoolean(builder.evaluate("result.length == 0", "checkNoErrors").toString());
        if (!valid) {
            String json = builder.addJSON().evaluate("JSON.stringify(result)", "CssLint messages").toString();
            LOG.debug("json {}", (Object)json);
            Type type = new TypeToken<List<CssLintError>>(){}.getType();
            List errors = (List)new Gson().fromJson(json, type);
            LOG.debug("Errors: {}", (Object)errors);
            throw new CssLintException().setErrors(errors);
        }
        LOG.debug("isValid: {}", (Object)valid);
        watch.stop();
        LOG.debug(watch.prettyPrint());
    }

    private String buildCssLintScript(String data) {
        return String.format("var result = CSSLint.verify(%s,%s).messages", data, this.optionsBuilder.buildFromCsv(this.options));
    }

    public CssLint setOptions(String options) {
        this.options = options;
        return this;
    }
}

