/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.linter;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.locator.WebjarUriLocator;
import ro.isdc.wro.extensions.processor.support.linter.LinterError;
import ro.isdc.wro.extensions.processor.support.linter.LinterException;
import ro.isdc.wro.extensions.processor.support.linter.OptionsBuilder;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public abstract class AbstractLinter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLinter.class);
    private WebjarUriLocator webjarLocator;
    private final OptionsBuilder optionsBuilder = new OptionsBuilder();
    private String options;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            return RhinoScriptBuilder.newClientSideAwareChain().evaluateChain(this.getScriptAsStream(), "linter.js");
        }
        catch (IOException e) {
            throw new WroRuntimeException("Failed reading init script", (Throwable)e);
        }
    }

    protected final WebjarUriLocator getWebjarLocator() {
        if (this.webjarLocator == null) {
            this.webjarLocator = new WebjarUriLocator();
        }
        return this.webjarLocator;
    }

    protected abstract InputStream getScriptAsStream() throws IOException;

    public void validate(String data) throws LinterException {
        StopWatch watch = new StopWatch();
        watch.start("init");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        watch.stop();
        watch.start("lint");
        String packIt = this.buildLinterScript(WroUtil.toJSMultiLineString((String)data), this.getOptions());
        boolean valid = Boolean.parseBoolean(builder.evaluate(packIt, "check").toString());
        if (!valid) {
            String json = builder.addJSON().evaluate(String.format("JSON.stringify(JSON.decycle(%s.errors))", this.getLinterName()), "stringify errors").toString();
            LOG.debug("json {}", (Object)json);
            Type type = new TypeToken<List<LinterError>>(){}.getType();
            List errors = (List)new Gson().fromJson(json, type);
            LOG.debug("errors {}", (Object)errors);
            throw new LinterException().setErrors(errors);
        }
        LOG.debug("result: {}", (Object)valid);
        watch.stop();
        LOG.debug(watch.prettyPrint());
    }

    protected abstract String getLinterName();

    private String buildLinterScript(String data, String options) {
        return String.format("%s(%s,%s);", this.getLinterName(), data, this.optionsBuilder.buildFromCsv(options));
    }

    public AbstractLinter setOptions(String ... options) {
        this.options = StringUtils.join((Object[])options, (char)',');
        LOG.debug("setOptions: {}", (Object)this.options);
        return this;
    }

    private String getOptions() {
        if (this.options == null) {
            this.options = this.createDefaultOptions();
        }
        return this.options;
    }

    protected String createDefaultOptions() {
        return "";
    }
}

