/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.SupportAware;
import ro.isdc.wro.util.WroUtil;

@SupportedResourceType(value=ResourceType.JS)
public class TypeScriptProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
SupportAware {
    private static final String TYPESCRIPT_EXTENSION = "ts";
    private static final String SHELL_COMMAND = "tsc";
    private static final String ARG_OUT = "--out";
    private static final Logger LOG = LoggerFactory.getLogger(TypeScriptProcessor.class);
    public static final String ALIAS = "typeScript";
    private final boolean isWindows;

    public TypeScriptProcessor() {
        String osName = System.getProperty("os.name");
        LOG.debug("OS Name: {}", (Object)osName);
        this.isWindows = osName != null && osName.contains("Windows");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        String resourceUri = resource == null ? "unknown.js" : resource.getUri();
        try {
            writer.write(this.process(resourceUri, content));
        }
        catch (Exception e) {
            LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e, content);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private String process(String resourceUri, String content) {
        InputStream shellIn = null;
        File tempSource = null;
        File tempDest = null;
        try {
            tempSource = WroUtil.createTempFile((String)TYPESCRIPT_EXTENSION);
            tempDest = WroUtil.createTempFile((String)TYPESCRIPT_EXTENSION);
            String encoding = "UTF-8";
            IOUtils.write((String)content, (OutputStream)new FileOutputStream(tempSource), (String)"UTF-8");
            LOG.debug("absolute path: {}", (Object)tempSource.getAbsolutePath());
            Process process = this.createProcess(tempSource, tempDest);
            int exitStatus = process.waitFor();
            String result = IOUtils.toString((InputStream)new FileInputStream(tempDest), (String)"UTF-8");
            if (exitStatus != 0) {
                LOG.error("exitStatus: {}", (Object)exitStatus);
                String errorMessage = IOUtils.toString((InputStream)process.getInputStream(), (String)"UTF-8");
                errorMessage = MessageFormat.format("Error in Typescript: \n{0}", errorMessage.replace(tempSource.getPath(), resourceUri));
                throw new WroRuntimeException(errorMessage).logError();
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            throw WroRuntimeException.wrap((Exception)e);
        }
        finally {
            IOUtils.closeQuietly(shellIn);
            FileUtils.deleteQuietly((File)tempSource);
            FileUtils.deleteQuietly((File)tempDest);
        }
    }

    protected void onException(Exception e, String content) {
        throw WroRuntimeException.wrap((Exception)e);
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    private Process createProcess(File sourceFile, File destFile) throws IOException {
        Validate.notNull((Object)sourceFile);
        String[] commandLine = this.getCommandLine(sourceFile.getPath(), destFile.getPath());
        LOG.debug("CommandLine arguments: {}", Arrays.asList(commandLine));
        return new ProcessBuilder(commandLine).redirectErrorStream(true).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupported() {
        File tempSource = null;
        File tempDest = null;
        try {
            tempSource = WroUtil.createTempFile((String)TYPESCRIPT_EXTENSION);
            tempDest = WroUtil.createTempFile((String)TYPESCRIPT_EXTENSION);
            Process process = this.createProcess(tempSource, tempDest);
            int exitValue = process.waitFor();
            LOG.debug("exitValue {}. ErrorMessage: {}", (Object)exitValue, (Object)IOUtils.toString((InputStream)process.getInputStream()));
            if (exitValue != 0) {
                throw new UnsupportedOperationException("Tsc is not a supported operation on this platform");
            }
            LOG.debug("The {} processor is supported.", (Object)this.getClass().getName());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.debug("Unsupported processor", (Throwable)e);
            LOG.warn("The {} processor is not supported. Because: {}", (Object)this.getClass().getName(), (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.deleteQuietly((File)tempSource);
            FileUtils.deleteQuietly((File)tempDest);
        }
    }

    protected String[] getCommandLine(String filePath, String outFilePath) {
        return this.isWindows ? this.buildArgumentsForWindows(filePath, outFilePath) : this.buildArgumentsForUnix(filePath, outFilePath);
    }

    private String[] buildArgumentsForUnix(String filePath, String outFilePath) {
        return new String[]{SHELL_COMMAND, filePath, ARG_OUT, outFilePath};
    }

    private String[] buildArgumentsForWindows(String filePath, String outFilePath) {
        return new String[]{"cmd", "/c", SHELL_COMMAND, filePath, ARG_OUT, outFilePath};
    }
}

