/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.extensions.processor.js.NodeCoffeeScriptProcessor;
import ro.isdc.wro.extensions.processor.js.RhinoCoffeeScriptProcessor;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.LazyProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.util.LazyInitializer;

@SupportedResourceType(value=ResourceType.JS)
public class CoffeeScriptProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CoffeeScriptProcessor.class);
    public static final String ALIAS = "coffeeScript";
    @Inject
    private Injector injector;
    private ResourcePreProcessor processor;

    private ResourcePreProcessor initializeProcessor() {
        ProcessorDecorator processor = new ProcessorDecorator((Object)this.createNodeProcessor());
        return processor.isSupported() ? processor : this.createRhinoProcessor();
    }

    ResourcePreProcessor createNodeProcessor() {
        LOG.debug("creating NodeCoffeeScript processor");
        return new NodeCoffeeScriptProcessor();
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        this.getProcessor().process(resource, reader, writer);
    }

    private ResourcePreProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = this.initializeProcessor();
            this.injector.inject((Object)this.processor);
        }
        return this.processor;
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    ResourcePreProcessor createRhinoProcessor() {
        LOG.debug("Node CoffeeScript is not supported. Using fallback Rhino processor");
        return new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new RhinoCoffeeScriptProcessor();
            }
        });
    }
}

