/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.linter;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.linter.LinterError;
import ro.isdc.wro.extensions.processor.support.linter.LinterException;
import ro.isdc.wro.extensions.processor.support.linter.OptionsBuilder;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public abstract class AbstractLinter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLinter.class);
    private final OptionsBuilder optionsBuilder = new OptionsBuilder();
    private String[] options;

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            return RhinoScriptBuilder.newChain().evaluateChain(this.getScriptAsStream(), "linter.js");
        }
        catch (IOException e) {
            throw new WroRuntimeException("Failed reading init script", (Throwable)e);
        }
    }

    protected abstract InputStream getScriptAsStream();

    public void validate(String data) throws LinterException {
        StopWatch watch = new StopWatch();
        watch.start("init");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        watch.stop();
        watch.start("lint");
        LOG.debug("options: {}", (Object)Arrays.toString(this.options));
        String packIt = this.buildLinterScript(WroUtil.toJSMultiLineString((String)data), this.options);
        boolean valid = Boolean.parseBoolean(builder.evaluate(packIt, "check").toString());
        if (!valid) {
            String json = builder.addJSON().evaluate(String.format("JSON.stringify(%s.errors)", this.getLinterName()), "stringify errors").toString();
            LOG.debug("json {}", (Object)json);
            Type type = new TypeToken<List<LinterError>>(){}.getType();
            List errors = (List)new Gson().fromJson(json, type);
            LOG.debug("errors {}", (Object)errors);
            throw new LinterException().setErrors(errors);
        }
        LOG.debug("result: {}", (Object)valid);
        watch.stop();
        LOG.debug(watch.prettyPrint());
    }

    protected abstract String getLinterName();

    private String buildLinterScript(String data, String ... options) {
        return String.format("%s(%s,%s);", this.getLinterName(), data, this.optionsBuilder.build(options));
    }

    public AbstractLinter setOptions(String ... options) {
        this.options = options != null ? (options.length > 1 ? options : this.optionsBuilder.splitOptions(options[0])) : ArrayUtils.EMPTY_STRING_ARRAY;
        LOG.debug("setOptions: {}", Arrays.asList(this.options));
        return this;
    }
}

