/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.coffeescript;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class CoffeeScript {
    private static final Logger LOG = LoggerFactory.getLogger(CoffeeScript.class);
    private String[] options;
    private ScriptableObject scope;
    private static final String DEFAULT_COFFE_SCRIPT = "coffee-script.min.js";

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder = null;
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newChain().evaluateChain(this.getCoffeeScriptAsStream(), DEFAULT_COFFE_SCRIPT);
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed reading init script", ex);
        }
    }

    protected InputStream getCoffeeScriptAsStream() {
        return CoffeeScript.class.getResourceAsStream(DEFAULT_COFFE_SCRIPT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compile(String data) {
        StopWatch watch = new StopWatch();
        watch.start("init");
        try {
            RhinoScriptBuilder builder = this.initScriptBuilder();
            watch.stop();
            watch.start("compile");
            String compileScript = String.format("CoffeeScript.compile(%s, %s);", WroUtil.toJSMultiLineString((String)data), this.buildOptions());
            String string = (String)builder.evaluate(compileScript, "CoffeeScript.compile");
            return string;
        }
        finally {
            watch.stop();
            LOG.debug(watch.prettyPrint());
        }
    }

    private String buildOptions() {
        StringBuffer sb = new StringBuffer("{");
        if (this.options != null) {
            for (int i = 0; i < this.options.length; ++i) {
                sb.append(this.options[i]).append(": true");
                if (i >= this.options.length - 1) continue;
                sb.append(",");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public CoffeeScript setOptions(String ... options) {
        this.options = options == null ? new String[]{} : options;
        LOG.debug("setOptions: {}", Arrays.asList(this.options));
        return this;
    }
}

