/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.SupportAware;
import ro.isdc.wro.util.WroUtil;

@SupportedResourceType(value=ResourceType.CSS)
public class NodeLessCssProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
SupportAware {
    private static final String OPTION_NO_COLOR = "--no-color";
    private static final String SHELL_COMMAND = "lessc";
    private static final Logger LOG = LoggerFactory.getLogger(NodeLessCssProcessor.class);
    public static final String ALIAS = "nodeLessCss";
    private final boolean isWindows;

    public NodeLessCssProcessor() {
        String osName = System.getProperty("os.name");
        LOG.debug("OS Name: {}", (Object)osName);
        this.isWindows = osName != null && osName.contains("Windows");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        String resourceUri = resource == null ? "unknown.less" : resource.getUri();
        try {
            writer.write(this.process(resourceUri, content));
        }
        catch (Exception e) {
            LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
            LOG.error(e.getMessage(), (Throwable)e);
            this.onException(e, content);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private String process(String resourceUri, String content) {
        InputStream shellIn = null;
        File temp = null;
        try {
            temp = WroUtil.createTempFile();
            String encoding = "UTF-8";
            IOUtils.write((String)content, (OutputStream)new FileOutputStream(temp), (String)"UTF-8");
            LOG.debug("absolute path: {}", (Object)temp.getAbsolutePath());
            String tempFilePath = temp.getPath();
            Process process = this.createProcess(tempFilePath);
            String result = IOUtils.toString((InputStream)new AutoCloseInputStream(process.getInputStream()), (String)"UTF-8");
            int exitStatus = process.waitFor();
            if (exitStatus != 0) {
                LOG.error("exitStatus: {}", (Object)exitStatus);
                String errorMessage = MessageFormat.format("Error in LESS: \n{0}", result.replace(tempFilePath, resourceUri));
                throw new WroRuntimeException(errorMessage);
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            throw WroRuntimeException.wrap((Exception)e);
        }
        finally {
            IOUtils.closeQuietly(shellIn);
            FileUtils.deleteQuietly((File)temp);
        }
    }

    protected void onException(Exception e, String content) {
        throw WroRuntimeException.wrap((Exception)e);
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    private Process createProcess(String sourceFilePath) throws IOException {
        String[] commandLine = this.getCommandLine(sourceFilePath);
        LOG.debug("commandLine arguments: {}", Arrays.asList(commandLine));
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine).redirectErrorStream(true);
        return processBuilder.start();
    }

    public boolean isSupported() {
        try {
            new ProcessBuilder(this.getCommandLine("")).start();
            LOG.debug("The {} processor is supported.", (Object)this.getClass().getName());
            return true;
        }
        catch (Exception e) {
            LOG.warn("The {} processor is not supported.", (Object)this.getClass().getName());
            return false;
        }
    }

    protected String[] getCommandLine(String filePath) {
        return this.isWindows ? this.buildArgumentsForWindows(filePath) : this.buildArgumentsForUnix(filePath);
    }

    private String[] buildArgumentsForUnix(String filePath) {
        return new String[]{SHELL_COMMAND, OPTION_NO_COLOR, filePath};
    }

    private String[] buildArgumentsForWindows(String filePath) {
        return new String[]{"cmd", "/c", SHELL_COMMAND, OPTION_NO_COLOR, filePath};
    }
}

