/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.util.WroUtil;

public final class PathPatternProcessorDecorator
extends ProcessorDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(PathPatternProcessorDecorator.class);
    private final String[] patterns;
    private final AntPathMatcher matcher;
    private final boolean includes;

    private PathPatternProcessorDecorator(Object processor, boolean includes, String ... patterns) {
        super(processor);
        Validate.notEmpty((Object[])patterns, (String)"A pattern set is required.", (Object[])new Object[0]);
        this.includes = includes;
        this.matcher = new AntPathMatcher();
        this.patterns = patterns;
        LOG.debug("{} patterns {}", (Object)(includes ? "include" : "exclude"), (Object)Arrays.toString(patterns));
    }

    public static PathPatternProcessorDecorator include(Object processor, String ... patterns) {
        return new PathPatternProcessorDecorator(processor, true, patterns);
    }

    public static PathPatternProcessorDecorator exclude(Object processor, String ... patterns) {
        return new PathPatternProcessorDecorator(processor, false, patterns);
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String uri;
        if (resource != null) {
            uri = resource.getUri();
            LOG.debug("matching uri: {}", (Object)uri);
            if (this.includes) {
                for (String pattern : this.patterns) {
                    if (!this.matcher.match(pattern, uri)) continue;
                    LOG.debug("Processing resource: {}. Match found: {}", (Object)uri, (Object)this.toString());
                    this.getDecoratedObject().process(resource, reader, writer);
                    return;
                }
            } else {
                boolean process = true;
                for (String pattern : this.patterns) {
                    if (!this.matcher.match(pattern, uri)) continue;
                    process = false;
                    break;
                }
                if (process) {
                    LOG.debug("Processing resource: {}. Match found: {}", (Object)uri, (Object)this.toString());
                    this.getDecoratedObject().process(resource, reader, writer);
                    return;
                }
            }
        } else {
            throw new WroRuntimeException("Wrong usage of " + this.toString() + ". Please use it as a pre-processor.");
        }
        LOG.debug("Skipping {} from {}. No match found: {}", new Object[]{uri, this.getDecoratedObject(), this.toString()});
        WroUtil.safeCopy((Reader)reader, (Writer)writer);
    }

    public String toString() {
        String processorName = this.getOriginalDecoratedObject().getClass().getSimpleName();
        StringBuilder buffer = new StringBuilder(processorName).append(": ").append(this.includes ? "(" : "!(");
        String separator = this.includes ? " || " : " && ";
        for (String pattern : this.patterns) {
            buffer.append(pattern).append(separator);
        }
        buffer.setLength(buffer.length() - separator.length());
        buffer.append(")");
        return buffer.toString();
    }
}

