/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.http.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import ro.isdc.wro.model.resource.Resource;

public class ResourceSerializer
implements JsonSerializer<Resource> {
    private final String basePath;

    public ResourceSerializer(String requestURI) {
        this.basePath = requestURI;
    }

    public JsonElement serialize(Resource resource, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        String uri = resource.getUri();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(resource.getType().toString()));
        jsonObject.add("uri", (JsonElement)new JsonPrimitive(uri));
        jsonObject.add("proxyUri", (JsonElement)new JsonPrimitive(this.getExternalUri(uri)));
        return jsonObject;
    }

    private String getExternalUri(String uri) {
        if (this.isExternal(uri)) {
            return uri;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.basePath);
        stringBuilder.append("wroResources");
        stringBuilder.append("?id=");
        stringBuilder.append(uri);
        return stringBuilder.toString();
    }

    private boolean isExternal(String uri) {
        return uri.toLowerCase().startsWith("http://");
    }
}

