/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.http.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.isdc.wro.extensions.http.handler.ResourceSerializer;
import ro.isdc.wro.http.handler.RequestHandlerSupport;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.util.WroUtil;

public class ModelAsJsonRequestHandler
extends RequestHandlerSupport {
    @VisibleForTesting
    static final String CONTENT_TYPE = "application/json";
    public static final String ENDPOINT_URI = "wroAPI/model";
    @Inject
    private WroModelFactory modelFactory;

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        WroUtil.addNoCacheHeaders((HttpServletResponse)response);
        response.setContentType(CONTENT_TYPE);
        response.setStatus(200);
        this.newGson(request).toJson(this.modelFactory.create(), (Appendable)response.getWriter());
        response.getWriter().flush();
    }

    protected Gson newGson(HttpServletRequest request) {
        return new GsonBuilder().registerTypeAdapter(Resource.class, (Object)new ResourceSerializer(this.getWroBasePath(request))).setPrettyPrinting().disableHtmlEscaping().create();
    }

    public boolean accept(HttpServletRequest request) {
        return WroUtil.matchesUrl((HttpServletRequest)request, (String)ENDPOINT_URI);
    }

    private String getWroBasePath(HttpServletRequest request) {
        return request.getRequestURI().replaceAll("(?i)wroAPI/model", "");
    }
}

