
zul.sel.Option = zk.$extends(zul.Widget, {
	$define: {
		disabled: function (disabled) {
			var n = this.$n();
			if (n) n.disabled = disabled ? 'disabled' : '';
		},
		value: null
	},
	setVisible: function (visible) {
		if (this._visible != visible) {
			this._visible = visible;
			if (this.desktop)
				this.parent.rerender();
		}
	},
	setSelected: function (selected) {
		if (this._selected != selected) {
			if (this.parent)
				this.parent.toggleItemSelection(this);
			
			var n = this.$n();
			if (n) n.selected = selected ? 'selected' : '';
			this._selected = selected;
		}
	},
	isSelected: function () {
		return this._selected;
	},
	getLabel: function () {
		return this.firstChild ? this.firstChild.getLabel() : null; 
	},
	getMaxlength: function () {
		return this.parent ? this.parent.getMaxlength() : 0;
	},
	domLabel_: function () {
		return zUtl.encodeXML(this.getLabel(), {maxlength: this.getMaxlength()});
	},
	domAttrs_: function () {
		return this.$supers('domAttrs_', arguments) + (this.isDisabled() ? ' disabled="disabled"' :'') +
		(this.isSelected() ? ' selected="selected"' : '');
	}
});