/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.awt.image.RenderedImage;
import java.io.IOException;
import org.zkoss.image.Image;
import org.zkoss.image.Images;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.LabelElement;
import org.zkoss.zul.impl.Utils;

public abstract class LabelImageElement
extends LabelElement
implements org.zkoss.zul.impl.api.LabelImageElement {
    private String _src;
    private Image _image;
    private String _hoversrc;
    private Image _hoverimg;
    private byte _imgver;
    private byte _hoverimgver;

    protected LabelImageElement() {
    }

    protected LabelImageElement(String label, String image) {
        this.setLabel(label);
        this.setImage(image);
    }

    protected LabelImageElement(String label) {
        this.setLabel(label);
    }

    public String getImage() {
        return this._src;
    }

    public void setImage(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._image != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._image = null;
            this.smartUpdate("image", new EncodedImageURL());
        }
    }

    public String getSrc() {
        return this.getImage();
    }

    public void setSrc(String src) {
        this.setImage(src);
    }

    public void setImageContent(Image image) {
        if (this._src != null || image != this._image) {
            this._image = image;
            this._src = null;
            if (this._image != null) {
                this._imgver = (byte)(this._imgver + 1);
            }
            this.smartUpdate("image", new EncodedImageURL());
        }
    }

    public void setImageContent(RenderedImage image) {
        try {
            this.setImageContent(Images.encode((String)"a.png", (RenderedImage)image));
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }

    public Image getImageContent() {
        return this._image;
    }

    public String getHoverImage() {
        return this._hoversrc;
    }

    public void setHoverImage(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._hoverimg != null || !Objects.equals((Object)this._hoversrc, (Object)src)) {
            this._hoversrc = src;
            this._hoverimg = null;
            this.smartUpdate("hoverImage", new EncodedHoverURL());
        }
    }

    public void setHoverImageContent(Image image) {
        if (this._hoversrc != null || image != this._hoverimg) {
            this._hoverimg = image;
            this._hoversrc = null;
            if (this._hoverimg != null) {
                this._hoverimgver = (byte)(this._hoverimgver + 1);
            }
            this.smartUpdate("hoverImage", new EncodedHoverURL());
        }
    }

    public void setHoverImageContent(RenderedImage image) {
        try {
            this.setHoverImageContent(Images.encode((String)"hover.png", (RenderedImage)image));
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }

    public boolean isImageAssigned() {
        return this._src != null || this._image != null;
    }

    private String getEncodedImageURL() {
        if (this._image != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, this._imgver, "c/" + this._image.getName(), this._image.getFormat());
        }
        Desktop dt = this.getDesktop();
        return dt != null && this._src != null ? dt.getExecution().encodeURL(this._src) : null;
    }

    private String getEncodedHoverURL() {
        if (this._hoverimg != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, this._hoverimgver, "h/" + this._hoverimg.getName(), this._hoverimg.getFormat());
        }
        Desktop dt = this.getDesktop();
        return dt != null && this._hoversrc != null ? dt.getExecution().encodeURL(this._hoversrc) : null;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "image", this.getEncodedImageURL());
        this.render(renderer, "hoverImage", this.getEncodedHoverURL());
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    private class EncodedHoverURL
    implements DeferredValue {
        private EncodedHoverURL() {
        }

        public Object getValue() {
            return LabelImageElement.this.getEncodedHoverURL();
        }
    }

    private class EncodedImageURL
    implements DeferredValue {
        private EncodedImageURL() {
        }

        public Object getValue() {
            return LabelImageElement.this.getEncodedImageURL();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)LabelImageElement.this);
        }

        public Media getMedia(String pathInfo) {
            int k;
            int j;
            if (pathInfo != null && (j = pathInfo.indexOf(47, 1)) >= 0 && (k = pathInfo.indexOf(47, ++j)) == j + 1 && pathInfo.charAt(j) == 'h') {
                return LabelImageElement.this._hoverimg;
            }
            return LabelImageElement.this._image;
        }
    }
}

