/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuSelect;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.ErrorEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.ClientConstraint;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.CustomConstraint;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.ext.Constrainted;
import org.zkoss.zul.impl.XulElement;
import org.zkoss.zul.mesg.MZul;

public abstract class InputElement
extends XulElement
implements Constrainted,
org.zkoss.zul.impl.api.InputElement {
    private static final Log log = Log.lookup((Class)InputElement.class);
    protected Object _value;
    private transient String _txtByClient;
    private String _errmsg;
    private String _name;
    private int _maxlength;
    private int _cols;
    private int _tabindex = -1;
    private Constraint _constr;
    private boolean _disabled;
    private boolean _readonly;
    private boolean _valided;
    private transient boolean _checkOnly;
    private boolean _inplace;

    public void setInplace(boolean inplace) {
        if (this._inplace != inplace) {
            this._inplace = inplace;
            this.smartUpdate("inplace", this._inplace);
        }
    }

    public boolean isInplace() {
        return this._inplace;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            this.smartUpdate("readonly", this._readonly);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public String getErrorMessage() {
        return this._errmsg;
    }

    public void clearErrorMessage(boolean revalidateRequired) {
        if (this._errmsg != null) {
            this._errmsg = null;
            Clients.closeErrorBox((Component)this);
        }
        this._valided = !revalidateRequired;
    }

    public void clearErrorMessage() {
        this.clearErrorMessage(false);
    }

    public String getText() throws WrongValueException {
        this.checkUserError();
        return this.coerceToString(this._value);
    }

    public void setText(String value) throws WrongValueException {
        if (this._maxlength > 0 && value != null && value.length() > this._maxlength) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.STRING_TOO_LONG, (Object)new Integer(this._maxlength)));
        }
        Object val = this.coerceFromString(value);
        this.validate(val);
        boolean errFound = this._errmsg != null;
        this.clearErrorMessage();
        if (!Objects.equals((Object)this._value, (Object)val)) {
            this._value = val;
            String fmtval = this.coerceToString(this._value);
            if (this._txtByClient == null || !Objects.equals((Object)this._txtByClient, (Object)fmtval)) {
                this._txtByClient = null;
                this.smartUpdate("value", fmtval);
            }
        } else if (this._txtByClient != null) {
            String fmtval = this.coerceToString(this._value);
            if (!Objects.equals((Object)this._txtByClient, (Object)fmtval)) {
                this._txtByClient = null;
                this.smartUpdate("value", fmtval);
            }
        } else if (errFound) {
            this.smartUpdate("value", this.coerceToString(this._value));
        }
    }

    protected abstract Object coerceFromString(String var1) throws WrongValueException;

    protected abstract String coerceToString(Object var1);

    protected void validate(Object value) throws WrongValueException {
        Constraint constr = this.getConstraint();
        if (constr != null) {
            Scopes.beforeInterpret((Scope)this);
            try {
                constr.validate((Component)this, value);
                if (!this._checkOnly && constr instanceof CustomConstraint) {
                    try {
                        ((CustomConstraint)((Object)constr)).showCustomError((Component)this, null);
                    }
                    catch (Throwable ex) {
                        log.realCauseBriefly(ex);
                    }
                }
            }
            catch (WrongValueException ex) {
                if (!this._checkOnly && constr instanceof CustomConstraint) {
                    ((CustomConstraint)((Object)constr)).showCustomError((Component)this, ex);
                }
                throw ex;
            }
            finally {
                Scopes.afterInterpret();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WrongValueException showCustomError(WrongValueException ex) {
        if (this._constr instanceof CustomConstraint) {
            Scopes.beforeInterpret((Scope)this);
            try {
                ((CustomConstraint)((Object)this._constr)).showCustomError((Component)this, ex);
            }
            catch (Throwable t) {
                log.realCause(t);
            }
            finally {
                Scopes.afterInterpret();
            }
        }
        return ex;
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.smartUpdate("maxlength", maxlength);
        }
    }

    public int getCols() {
        return this._cols;
    }

    public void setCols(int cols) throws WrongValueException {
        if (cols <= 0) {
            throw new WrongValueException("Illegal cols: " + cols);
        }
        if (this._cols != cols) {
            this._cols = cols;
            this.smartUpdate("cols", this._cols);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            if (tabindex < 0) {
                this.smartUpdate("tabindex", null);
            } else {
                this.smartUpdate("tabindex", this._tabindex);
            }
        }
    }

    public boolean isMultiline() {
        return false;
    }

    public String getType() {
        return "text";
    }

    public void select() {
        this.response("select", (AuResponse)new AuSelect((Component)this));
    }

    public void setConstraint(String constr) {
        this.setConstraint(constr != null ? SimpleConstraint.getInstance(constr) : null);
    }

    public void setConstraint(Constraint constr) {
        if (!Objects.equals((Object)this._constr, (Object)constr)) {
            this._constr = constr;
            this._valided = false;
            boolean constrDone = false;
            if (this._constr instanceof CustomConstraint) {
                this.smartUpdate("constraint", "[c");
                return;
            }
            if (this._constr instanceof ClientConstraint) {
                ClientConstraint cc = (ClientConstraint)((Object)this._constr);
                try {
                    String js;
                    String cpkg = cc.getClientPackages();
                    if (cpkg != null) {
                        this.smartUpdate("z_pk", cpkg);
                    }
                    if ((js = cc.getClientConstraint()) != null) {
                        char c;
                        char c2 = c = js.length() > 0 ? js.charAt(0) : (char)'\u0000';
                        if (c != '\'' && c != '\"') {
                            this.smartUpdate("z_al", "{constraint:function(){\nreturn " + js + ";}}");
                        } else {
                            this.smartUpdate("constraint", js.substring(1, js.length() - 1));
                        }
                        return;
                    }
                }
                catch (AbstractMethodError ex) {
                    log.warning("Ignore incompatible constraint: " + cc);
                }
            }
            this.smartUpdate("constraint", this._constr != null ? "[s" : null);
        }
    }

    public final Constraint getConstraint() {
        return this._constr;
    }

    protected Object getTargetValue() throws WrongValueException {
        this.checkUserError();
        return this._value;
    }

    public Object getRawValue() {
        return this._value;
    }

    public String getRawText() {
        return this.coerceToString(this._value);
    }

    public void setRawValue(Object value) {
        if (this._errmsg != null || !Objects.equals((Object)this._value, (Object)value)) {
            this.clearErrorMessage(true);
            this._value = value;
            this.smartUpdate("value", this.coerceToString(this._value));
        }
    }

    protected void setValueDirectly(Object value) {
        this._value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this._errmsg != null) {
            return false;
        }
        if (!this._valided && this._constr != null) {
            this._checkOnly = true;
            try {
                this.validate(this._value);
            }
            catch (Throwable ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                this._checkOnly = false;
            }
        }
        return true;
    }

    public void setSelectedText(int start, int end, String newtxt, boolean isHighLight) {
        if (start <= end) {
            String txt = this.getText();
            int len = txt.length();
            if (start < 0) {
                start = 0;
            }
            if (start > len) {
                start = len;
            }
            if (end < 0) {
                end = 0;
            }
            if (end > len) {
                end = len;
            }
            if (newtxt == null) {
                newtxt = "";
            }
            this.setText(txt.substring(0, start) + newtxt + txt.substring(end));
            this.setSelectionRange(start, isHighLight ? start + newtxt.length() : start);
        }
    }

    public void setSelectionRange(int start, int end) {
        this.response("select", (AuResponse)new AuSelect((Component)this, start, end));
    }

    protected void checkUserError() throws WrongValueException {
        if (this._errmsg != null) {
            throw this.showCustomError(new WrongValueException((Component)this, this._errmsg));
        }
        if (!this._valided && this._constr != null) {
            this.setText(this.coerceToString(this._value));
        }
    }

    protected boolean isChildable() {
        return false;
    }

    public WrongValueException onWrongValue(WrongValueException ex) {
        this._errmsg = Exceptions.getMessage((Throwable)ex);
        return this.showCustomError(ex);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onChange")) {
            String value;
            InputEvent evt = InputEvent.getInputEvent((AuRequest)request);
            this._txtByClient = value = evt.getValue();
            try {
                Object oldval = this._value;
                this.setText(value);
                if (oldval == this._value) {
                    return;
                }
            }
            catch (WrongValueException ex) {
                this._errmsg = ex.getMessage();
                throw ex;
            }
            finally {
                this._txtByClient = null;
            }
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onChanging")) {
            Events.postEvent((Event)InputEvent.getInputEvent((AuRequest)request));
        } else if (cmd.equals("onError")) {
            ErrorEvent evt = ErrorEvent.getErrorEvent((AuRequest)request);
            String msg = evt.getMessage();
            this._errmsg = msg != null && msg.length() > 0 ? msg : null;
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "value", this.coerceToString(this._value));
        this.render(renderer, "readonly", this._readonly);
        this.render(renderer, "disabled", this._disabled);
        this.render(renderer, "name", this._name);
        this.render(renderer, "inplace", this._inplace);
        if (this._maxlength > 0) {
            renderer.render("maxlength", this._maxlength);
        }
        if (this._cols > 0) {
            renderer.render("cols", this._cols);
        }
        if (this._tabindex >= 0) {
            renderer.render("tabindex", this._tabindex);
        }
        boolean constrDone = false;
        if (this._constr instanceof CustomConstraint) {
            renderer.render("constraint", "[c");
            constrDone = true;
        } else if (this._constr instanceof ClientConstraint) {
            ClientConstraint cc = (ClientConstraint)((Object)this._constr);
            try {
                this.render(renderer, "z_pk", cc.getClientPackages());
                String js = cc.getClientConstraint();
                if (js != null) {
                    char c;
                    char c2 = c = js.length() > 0 ? js.charAt(0) : (char)'\u0000';
                    if (c != '\'' && c != '\"') {
                        renderer.renderDirectly("z_al", (Object)("{constraint:function(){\nreturn " + js + ";}}"));
                    } else {
                        renderer.renderDirectly("constraint", (Object)js);
                    }
                    constrDone = true;
                }
            }
            catch (AbstractMethodError ex) {
                log.warning("Ignore incompatible constraint: " + cc);
            }
        }
        if (!constrDone && this._constr != null) {
            renderer.render("constraint", "[s");
        }
    }

    static {
        InputElement.addClientEvent((Class)InputElement.class, (String)"onChange", (int)16385);
        InputElement.addClientEvent((Class)InputElement.class, (String)"onChanging", (int)4096);
        InputElement.addClientEvent((Class)InputElement.class, (String)"onFocus", (int)8192);
        InputElement.addClientEvent((Class)InputElement.class, (String)"onBlur", (int)8192);
        InputElement.addClientEvent((Class)InputElement.class, (String)"onSelection", (int)0);
        InputElement.addClientEvent((Class)InputElement.class, (String)"onError", (int)8193);
    }
}

