/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.InputElement;

public class Textbox
extends InputElement
implements org.zkoss.zul.api.Textbox {
    private String _type = "text";
    private int _rows = 1;
    private boolean _multiline;
    private boolean _tabbable;

    public Textbox() {
        this.setValueDirectly("");
    }

    public Textbox(String value) throws WrongValueException {
        this.setValue(value);
    }

    public String getValue() throws WrongValueException {
        return this.getText();
    }

    public void setValue(String value) throws WrongValueException {
        this.setText(value);
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        return value != null ? value : "";
    }

    protected String coerceToString(Object value) {
        return value != null ? (String)value : "";
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) throws WrongValueException {
        if (!"text".equals(type) && !"password".equals(type)) {
            throw new WrongValueException("Illegal type: " + type);
        }
        if (!this._type.equals(type)) {
            this._type = type;
            this.smartUpdate("type", type);
        }
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows <= 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            if (this._rows > 1) {
                this.setMultiline(true);
            }
            this.smartUpdate("rows", this._rows);
        }
    }

    public boolean isMultiline() {
        return this._multiline;
    }

    public void setMultiline(boolean multiline) {
        if (this._multiline != multiline) {
            this._multiline = multiline;
            this.smartUpdate("multiline", multiline);
        }
    }

    public boolean isTabbable() {
        return this._tabbable;
    }

    public void setTabbable(boolean tabbable) {
        if (this._tabbable != tabbable) {
            this._tabbable = tabbable;
            this.smartUpdate("tabbable", tabbable);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._multiline) {
            renderer.render("multiline", this._multiline);
        }
        if (this._rows > 1) {
            renderer.render("rows", this._rows);
        }
        if (this._tabbable) {
            renderer.render("tabbable", this._tabbable);
        }
        if (!"text".equals(this._type)) {
            renderer.render("type", this._type);
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-textbox";
    }

    static {
        Textbox.addClientEvent((Class)Textbox.class, (String)"onFocus", (int)8192);
        Textbox.addClientEvent((Class)Textbox.class, (String)"onBlur", (int)8192);
    }
}

