/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.util.DeferredValue;

public class Script
extends AbstractComponent
implements org.zkoss.zul.api.Script {
    private String _src;
    private String _charset;
    private String _content;
    private String _packages;
    private boolean _defer;

    public String getType() {
        return "text/javascript";
    }

    public void setType(String type) {
    }

    public String getCharset() {
        return this._charset;
    }

    public void setCharset(String charset) {
        if (charset != null && charset.length() == 0) {
            charset = null;
        }
        if (!Objects.equals((Object)this._charset, (Object)charset)) {
            this._charset = charset;
            this.smartUpdate("charset", this._charset);
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this.smartUpdate("src", new EncodedSrcURL());
        }
    }

    public boolean isDefer() {
        return this._defer;
    }

    public void setDefer(boolean defer) {
        this._defer = defer;
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content != null && content.length() == 0) {
            content = null;
        }
        if (!Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this.smartUpdate("content", this._content);
        }
    }

    public String getPackages() {
        return this._packages;
    }

    public void setPackages(String packages) {
        if (packages != null && packages.length() == 0) {
            packages = null;
        }
        if (!Objects.equals((Object)this._packages, (Object)packages)) {
            this._packages = packages;
            this.smartUpdate("packages", this._packages);
        }
    }

    public void redraw(Writer out) throws IOException {
        if (!this._defer && this._content != null) {
            out.write(this._content);
        }
        super.redraw(out);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._defer && this._content != null) {
            renderer.renderDirectly("content", (Object)("function(){\n" + this._content + "\n}"));
        }
        if (this._src != null) {
            HtmlPageRenders.RenderContext rc;
            HtmlPageRenders.RenderContext renderContext = rc = this._defer ? null : HtmlPageRenders.getRenderContext(null);
            if (rc != null) {
                Writer out = rc.extra;
                out.write("\n<script type=\"text/javascript\" src=\"");
                out.write(this.getEncodedSrcURL());
                out.write(34);
                if (this._charset != null) {
                    out.write(" charset=\"");
                    out.write(this._charset);
                    out.write(34);
                }
                out.write(">\n</script>\n");
            } else {
                this.render(renderer, "src", this.getEncodedSrcURL());
            }
        }
        this.render(renderer, "charset", this._charset);
        this.render(renderer, "packages", this._packages);
    }

    protected boolean isChildable() {
        return false;
    }

    private String getEncodedSrcURL() {
        if (this._src == null) {
            return null;
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(this._src) : null;
    }

    private class EncodedSrcURL
    implements DeferredValue {
        private EncodedSrcURL() {
        }

        public Object getValue() {
            return Script.this.getEncodedSrcURL();
        }
    }
}

