/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.LabelImageElement;

public class Checkbox
extends LabelImageElement
implements org.zkoss.zul.api.Checkbox {
    private String _name;
    private int _tabindex = -1;
    boolean _checked;
    private boolean _disabled;

    public Checkbox() {
    }

    public Checkbox(String label) {
        super(label);
    }

    public Checkbox(String label, String image) {
        super(label, image);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isChecked() {
        return this._checked;
    }

    public void setChecked(boolean checked) {
        if (this._checked != checked) {
            this._checked = checked;
            this.smartUpdate("checked", this._checked);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            if (tabindex < 0) {
                this.smartUpdate("tabindex", null);
            } else {
                this.smartUpdate("tabindex", this._tabindex);
            }
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-checkbox" : this._zclass;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._tabindex >= 0) {
            renderer.render("tabindex", this._tabindex);
        }
        this.render(renderer, "disabled", this._disabled);
        this.render(renderer, "name", this._name);
        if (this._checked) {
            this.render(renderer, "checked", this._checked);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onCheck")) {
            CheckEvent evt = CheckEvent.getCheckEvent((AuRequest)request);
            this._checked = evt.isChecked();
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Checkbox.addClientEvent((Class)Checkbox.class, (String)"onCheck", (int)1);
        Checkbox.addClientEvent((Class)Checkbox.class, (String)"onFocus", (int)8192);
        Checkbox.addClientEvent((Class)Checkbox.class, (String)"onBlur", (int)8192);
    }
}

