/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zul.impl.XulElement;

public class Label
extends XulElement
implements org.zkoss.zul.api.Label {
    private String _value = "";
    private int _maxlength;
    private boolean _pre;
    private boolean _hyphen;
    private boolean _multiline;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Label() {
    }

    public Label(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            this.invalidate();
        }
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.invalidate();
        }
    }

    public boolean isPre() {
        return this._pre;
    }

    public void setPre(boolean pre) {
        if (this._pre != pre) {
            this._pre = pre;
            this.invalidate();
        }
    }

    public boolean isMultiline() {
        return this._multiline;
    }

    public void setMultiline(boolean multiline) {
        if (this._multiline != multiline) {
            this._multiline = multiline;
            this.invalidate();
        }
    }

    public boolean isHyphen() {
        return this._hyphen;
    }

    public void setHyphen(boolean hyphen) {
        if (this._hyphen != hyphen) {
            this._hyphen = hyphen;
            this.invalidate();
        }
    }

    public boolean isIdRequired() {
        Component p = this.getParent();
        return p == null || !this.isVisible() || !Label.isRawLabel(p) || !Components.isAutoId((String)this.getId()) || this.isAsapRequired("onClick") || !Label.isEmpty(this.getStyle()) || !Label.isEmpty(this.getSclass()) || !Label.isEmpty(this.getContext()) || !Label.isEmpty(this.getTooltip()) || !Label.isEmpty(this.getTooltiptext()) || !Label.isEmpty(this.getPopup()) || !"false".equals(this.getDraggable()) || !"false".equals(this.getDroppable()) || this.isAsapRequired("onRightClick") || !Label.isEmpty(this.getAction()) || !Label.isEmpty(this.getLeft()) || !Label.isEmpty(this.getTop()) || !Label.isEmpty(this.getWidth()) || !Label.isEmpty(this.getHeight()) || this.isAsapRequired("onDoubleClick");
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static boolean isRawLabel(Component comp) {
        LanguageDefinition langdef = comp.getDefinition().getLanguageDefinition();
        return langdef != null && langdef.isRawLabel();
    }

    public String getEncodedText() {
        StringBuffer sb;
        block5: {
            sb = null;
            int len = this._value.length();
            if (this._pre || this._multiline) {
                int j = 0;
                while (true) {
                    int k;
                    if ((k = this._value.indexOf(10, j)) < 0) {
                        sb = this.encodeLine(sb, j, len);
                        break block5;
                    }
                    if (sb == null) {
                        if (!$assertionsDisabled && j != 0) {
                            throw new AssertionError();
                        }
                        sb = new StringBuffer(this._value.length() + 10);
                    }
                    sb = this.encodeLine(sb, j, k > j && this._value.charAt(k - 1) == '\r' ? k - 1 : k);
                    sb.append("<br/>");
                    j = k + 1;
                }
            }
            sb = this.encodeLine(null, 0, len);
        }
        return sb != null ? sb.toString() : this._value;
    }

    private StringBuffer encodeLine(StringBuffer sb, int b, int e) {
        int deta;
        boolean prews = this._pre || this._multiline;
        int linesz = 0;
        if (this._maxlength > 0 && (deta = e - b) > this._maxlength) {
            if (this._hyphen) {
                linesz = this._maxlength;
            } else if (!prews) {
                int j;
                if (!$assertionsDisabled && b != 0) {
                    throw new AssertionError();
                }
                for (j = this._maxlength; j > 0 && Character.isWhitespace(this._value.charAt(j - 1)); --j) {
                }
                return new StringBuffer(j + 3).append(this._value.substring(0, j)).append("...");
            }
        }
        int cnt = 0;
        block6: for (int j = b; j < e; ++j) {
            char cc = this._value.charAt(j);
            String val = null;
            if (linesz > 0 && ++cnt > linesz && j + 1 < e) {
                sb = this.alloc(sb, j);
                if (Character.isLetterOrDigit(cc) && Character.isLetterOrDigit(this._value.charAt(j + 1))) {
                    int k = sb.length();
                    for (cnt = 0; cnt < 3; ++cnt) {
                        if (Character.isLetterOrDigit(sb.charAt(--k))) continue;
                        sb.insert(k + 1, "<br/>");
                        --j;
                        continue block6;
                    }
                    sb.append('-').append("<br/>").append(cc);
                    cnt = 1;
                    continue;
                }
                if (!Character.isWhitespace(cc)) {
                    sb.append(cc);
                }
                sb.append("<br/>");
                cnt = 0;
                continue;
            }
            if (cc == '\t') {
                if (prews) {
                    val = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                }
            } else if (cc == ' ' || cc == '\f') {
                if (prews) {
                    val = "&nbsp;";
                }
            } else {
                if (this._multiline) {
                    prews = false;
                }
                switch (cc) {
                    case '<': {
                        val = "&lt;";
                        break;
                    }
                    case '>': {
                        val = "&gt;";
                        break;
                    }
                    case '&': {
                        val = "&amp;";
                    }
                }
            }
            if (val != null) {
                sb = this.alloc(sb, j).append(val);
                continue;
            }
            if (sb == null) continue;
            sb.append(cc);
        }
        return sb;
    }

    private StringBuffer alloc(StringBuffer sb, int e) {
        if (sb == null) {
            sb = new StringBuffer(this._value.length() + 10);
            sb.append(this._value.substring(0, e));
        }
        return sb;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String clkattrs = this.getAllOnClickAttrs();
        return clkattrs == null ? attrs : attrs + clkattrs;
    }

    public String getZclass() {
        return this._zclass == null ? "z-label" : this._zclass;
    }

    public void invalidate() {
        if (this.isIdRequired()) {
            super.invalidate();
        } else {
            this.getParent().invalidate();
        }
    }

    public void redraw(Writer out) throws IOException {
        if (this.isIdRequired()) {
            super.redraw(out);
        } else {
            out.write(this.getEncodedText());
        }
    }

    public boolean isChildable() {
        return false;
    }

    static {
        $assertionsDisabled = !Label.class.desiredAssertionStatus();
    }
}

