/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.client.InnerWidth;
import org.zkoss.zk.ui.ext.client.RenderOnDemand;
import org.zkoss.zk.ui.ext.render.ChildChangedAware;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.Columns;
import org.zkoss.zul.GridDrawerEngine;
import org.zkoss.zul.Group;
import org.zkoss.zul.GroupDataInfo;
import org.zkoss.zul.GroupRendererExt;
import org.zkoss.zul.Groupfoot;
import org.zkoss.zul.GroupsListModel;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.RowRendererExt;
import org.zkoss.zul.api.Foot;
import org.zkoss.zul.api.Paging;
import org.zkoss.zul.api.Row;
import org.zkoss.zul.api.Rows;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Paginated;
import org.zkoss.zul.impl.XulElement;

public class Grid
extends XulElement
implements Paginated,
org.zkoss.zul.api.Grid {
    private static final Log log;
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.Grid.onInitLaterPosted";
    private transient org.zkoss.zul.Rows _rows;
    private transient Columns _cols;
    private transient org.zkoss.zul.Foot _foot;
    private transient Collection _heads;
    private String _align;
    private String _pagingPosition = "bottom";
    private ListModel _model;
    private RowRenderer _renderer;
    private transient ListDataListener _dataListener;
    private transient Paginal _pgi;
    private transient org.zkoss.zul.Paging _paging;
    private transient EventListener _pgListener;
    private transient EventListener _pgImpListener;
    private String _scOddRow = null;
    private int _preloadsz = 7;
    private String _innerWidth = "100%";
    private String _innerHeight = null;
    private String _innerTop = "height:0px;display:none";
    private String _innerBottom = "height:0px;display:none";
    private transient GridDrawerEngine _engine;
    private boolean _fixedLayout;
    private boolean _vflex;
    private static final RowRenderer _defRend;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Grid() {
        this.init();
    }

    private void init() {
        this._heads = new AbstractCollection(){

            public int size() {
                int sz = Grid.this.getChildren().size();
                if (Grid.this._rows != null) {
                    --sz;
                }
                if (Grid.this._foot != null) {
                    --sz;
                }
                if (Grid.this._paging != null) {
                    --sz;
                }
                return sz;
            }

            public Iterator iterator() {
                return new Iter();
            }
        };
    }

    public final boolean isVflex() {
        return this._vflex;
    }

    public void setVflex(boolean vflex) {
        if (this._vflex != vflex) {
            this._vflex = vflex;
            this.smartUpdate("z.flex", this._vflex);
        }
    }

    public void setFixedLayout(boolean fixedLayout) {
        if (this._fixedLayout != fixedLayout) {
            this._fixedLayout = fixedLayout;
            this.invalidate();
        }
    }

    public boolean isFixedLayout() {
        String s = (String)this.getAttribute("fixed-layout");
        return s != null ? "true".equalsIgnoreCase(s) : this._fixedLayout;
    }

    public org.zkoss.zul.Rows getRows() {
        return this._rows;
    }

    public Rows getRowsApi() {
        return this.getRows();
    }

    public Columns getColumns() {
        return this._cols;
    }

    public org.zkoss.zul.api.Columns getColumnsApi() {
        return this.getColumns();
    }

    public org.zkoss.zul.Foot getFoot() {
        return this._foot;
    }

    public Foot getFootApi() {
        return this.getFoot();
    }

    public Collection getHeads() {
        return this._heads;
    }

    public Component getCell(int row, int col) {
        org.zkoss.zul.Rows rows = this.getRows();
        if (rows == null) {
            return null;
        }
        List children = rows.getChildren();
        if (children.size() <= row) {
            return null;
        }
        return (children = ((org.zkoss.zul.Row)children.get(row)).getChildren()).size() <= col ? null : (Component)children.get(col);
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public void setPagingPosition(String pagingPosition) {
        if (pagingPosition == null || !pagingPosition.equals("top") && !pagingPosition.equals("bottom") && !pagingPosition.equals("both")) {
            throw new WrongValueException("Unsupported position : " + pagingPosition);
        }
        if (!Objects.equals((Object)this._pagingPosition, (Object)pagingPosition)) {
            this._pagingPosition = pagingPosition;
            this.invalidate();
        }
    }

    public String getPagingPosition() {
        return this._pagingPosition;
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this._pgi.setTotalSize(this._rows != null ? this._rows.getVisibleItemCount() : 0);
                    this.addPagingListener(this._pgi);
                }
            }
        }
    }

    private void newInternalPaging() {
        if (!$assertionsDisabled && !this.inPagingMold()) {
            throw new AssertionError((Object)"paging mold only");
        }
        if (!($assertionsDisabled || this._paging == null && this._pgi == null)) {
            throw new AssertionError();
        }
        org.zkoss.zul.Paging paging = new org.zkoss.zul.Paging();
        paging.setAutohide(true);
        paging.setDetailed(true);
        paging.setTotalSize(this._rows != null ? this._rows.getVisibleItemCount() : 0);
        paging.setParent((Component)this);
        this.addPagingListener(this._pgi);
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new EventListener(){

                public void onEvent(Event event) {
                    PagingEvent evt = (PagingEvent)event;
                    Events.postEvent((Event)new PagingEvent(evt.getName(), (Component)Grid.this, evt.getPageable(), evt.getActivePage()));
                }
            };
        }
        pgi.addEventListener("onPaging", this._pgListener);
        if (this._pgImpListener == null) {
            this._pgImpListener = new EventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEvent(Event event) {
                    if (Grid.this._rows != null && Grid.this._model != null && Grid.this.inPagingMold()) {
                        Renderer renderer = new Renderer();
                        try {
                            Paginal pgi = Grid.this.getPaginal();
                            int pgsz = pgi.getPageSize();
                            int ofs = pgi.getActivePage() * pgsz;
                            ListIterator it = Grid.this._rows.getChildren().listIterator(ofs);
                            while (--pgsz >= 0 && it.hasNext()) {
                                renderer.render((org.zkoss.zul.Row)it.next());
                            }
                        }
                        catch (Throwable ex) {
                            renderer.doCatch(ex);
                        }
                        finally {
                            renderer.doFinally();
                        }
                    }
                    if (Grid.this.getModel() != null || Grid.this.getPagingPosition().equals("both")) {
                        Grid.this.invalidate();
                    } else if (Grid.this._rows != null) {
                        Grid.this._rows.invalidate();
                    }
                }
            };
        }
        pgi.addEventListener("onPagingImpl", this._pgImpListener);
    }

    private void removePagingListener(Paginal pgi) {
        pgi.removeEventListener("onPaging", this._pgListener);
        pgi.removeEventListener("onPagingImpl", this._pgImpListener);
    }

    public org.zkoss.zul.Paging getPagingChild() {
        return this._paging;
    }

    public Paging getPagingChildApi() {
        return this.getPagingChild();
    }

    public org.zkoss.zul.Paging getPaging() {
        return this.getPagingChild();
    }

    public Paging getPagingApi() {
        return this.getPagingChild();
    }

    public int getPageSize() {
        return this.pgi().getPageSize();
    }

    public void setPageSize(int pgsz) throws WrongValueException {
        this.pgi().setPageSize(pgsz);
    }

    public int getPageCount() {
        return this.pgi().getPageCount();
    }

    public int getActivePage() {
        return this.pgi().getActivePage();
    }

    public void setActivePage(int pg) throws WrongValueException {
        this.pgi().setActivePage(pg);
    }

    private Paginal pgi() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi;
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    final boolean inSpecialMold() {
        String mold = (String)this.getAttribute("special-mold-name");
        return mold != null && this.getMold().equals(mold);
    }

    final GridDrawerEngine getDrawerEngine() {
        return this._engine;
    }

    public void setInnerHeight(String innerHeight) {
        if (innerHeight == null) {
            innerHeight = "100%";
        }
        if (!Objects.equals((Object)this._innerHeight, (Object)innerHeight)) {
            this._innerHeight = innerHeight;
            this.smartUpdate("z.innerHeight", this._innerHeight);
        }
    }

    public String getInnerHeight() {
        return this._innerHeight;
    }

    public void setInnerTop(String innerTop) {
        if (innerTop == null) {
            innerTop = "height:0px;display:none";
        }
        if (!Objects.equals((Object)this._innerTop, (Object)innerTop)) {
            this._innerTop = innerTop;
            this.smartUpdate("z.innerTop", this._innerTop);
        }
    }

    public String getInnerTop() {
        return this._innerTop;
    }

    public void setInnerBottom(String innerBottom) {
        if (innerBottom == null) {
            innerBottom = "height:0px;display:none";
        }
        if (!Objects.equals((Object)this._innerBottom, (Object)innerBottom)) {
            this._innerBottom = innerBottom;
            this.smartUpdate("z.innerBottom", this._innerBottom);
        }
    }

    public String getInnerBottom() {
        return this._innerBottom;
    }

    public ListModel getModel() {
        return this._model;
    }

    public ListModel getListModel() {
        return this._model instanceof GroupsListModel ? null : this._model;
    }

    public GroupsModel getGroupsModel() {
        return this._model instanceof GroupsListModel ? ((GroupsListModel)this._model).getGroupsModel() : null;
    }

    public void setModel(ListModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                    if (this._model instanceof GroupsListModel) {
                        this._rows.getChildren().clear();
                    }
                } else {
                    if (this._rows != null) {
                        this._rows.getChildren().clear();
                    }
                    this.smartUpdate("z.model", "true");
                }
                this._model = model;
                this.initDataListener();
            }
            this.syncModel(-1, -1);
            this.postOnInitRender();
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            if (this._rows != null) {
                this._rows.getChildren().clear();
            }
            this.smartUpdate("z.model", null);
        }
    }

    public void setModel(GroupsModel model) {
        this.setModel(model != null ? new GroupsListModel(model) : null);
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Grid.this.onListDataChange(event);
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    public RowRenderer getRowRenderer() {
        return this._renderer;
    }

    public void setRowRenderer(RowRenderer renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            if (this._model != null) {
                if (renderer instanceof RowRendererExt || this._renderer instanceof RowRendererExt) {
                    this.getRows().getChildren().clear();
                    this.syncModel(-1, -1);
                } else if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
                    this.unloadAll();
                }
            }
        }
    }

    public void setRowRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setRowRenderer((RowRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public int getPreloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        return size != null ? Integer.parseInt(size) : this._preloadsz;
    }

    public void setPreloadSize(int sz) {
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        this._preloadsz = sz;
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("z.innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    private void syncModel(int min, int max) {
        int newsz = this._model.getSize();
        int oldsz = this._rows != null ? this._rows.getChildren().size() : 0;
        int newcnt = newsz - oldsz;
        int atg = this._pgi != null ? this.getActivePage() : 0;
        RowRenderer renderer = null;
        Component next = null;
        if (oldsz > 0) {
            if (min < 0) {
                min = 0;
            } else if (min > oldsz - 1) {
                min = oldsz - 1;
            }
            if (max < 0) {
                max = oldsz - 1;
            } else if (max > oldsz - 1) {
                max = oldsz - 1;
            }
            if (min > max) {
                int t = min;
                min = max;
                max = t;
            }
            int cnt = max - min + 1;
            if (this._model instanceof GroupsListModel) {
                if ((newcnt += cnt) > 50 && !this.inPagingMold()) {
                    this.invalidate();
                }
                Component comp = (Component)this._rows.getChildren().get(max);
                next = comp.getNextSibling();
                while (--cnt >= 0) {
                    Component p = comp.getPreviousSibling();
                    comp.detach();
                    comp = p;
                }
            } else {
                int addcnt = 0;
                Component row = (Component)this._rows.getChildren().get(min);
                while (--cnt >= 0) {
                    next = row.getNextSibling();
                    if (cnt < -newcnt) {
                        row.detach();
                    } else if (((org.zkoss.zul.Row)row).isLoaded()) {
                        if (renderer == null) {
                            renderer = this.getRealRenderer();
                        }
                        row.detach();
                        this._rows.insertBefore((Component)this.newUnloadedRow(renderer, min++), next);
                        ++addcnt;
                    }
                    row = next;
                }
                if (!(addcnt <= 50 && addcnt + newcnt <= 50 || this.inPagingMold())) {
                    this.invalidate();
                }
            }
        } else {
            min = 0;
            if (this._rows == null) {
                new org.zkoss.zul.Rows().setParent((Component)this);
            }
        }
        while (--newcnt >= 0) {
            if (renderer == null) {
                renderer = this.getRealRenderer();
            }
            this._rows.insertBefore((Component)this.newUnloadedRow(renderer, min), next);
            ++min;
        }
        if (this._pgi != null) {
            if (atg >= this._pgi.getPageCount()) {
                atg = this._pgi.getPageCount() - 1;
            }
            this._pgi.setActivePage(atg);
        }
    }

    private void unloadAll() {
        List rows = this._rows.getChildren();
        int cnt = rows.size();
        if (cnt <= 0) {
            return;
        }
        RowRenderer renderer = null;
        Component comp = (Component)rows.get(cnt - 1);
        while (--cnt >= 0) {
            Component prev = comp.getPreviousSibling();
            if (((org.zkoss.zul.Row)comp).isLoaded()) {
                if (renderer == null) {
                    renderer = this.getRealRenderer();
                }
                Component next = comp.getNextSibling();
                comp.detach();
                this._rows.insertBefore((Component)this.newUnloadedRow(renderer, cnt), next);
            }
            comp = prev;
        }
    }

    private final org.zkoss.zul.Row newUnloadedRow(RowRenderer renderer, int index) {
        org.zkoss.zul.Row row = null;
        if (this._model instanceof GroupsListModel) {
            GroupsListModel model = (GroupsListModel)this._model;
            GroupDataInfo info = model.getDataInfo(index);
            switch (info.type) {
                case 0: {
                    row = this.newGroup(renderer);
                    break;
                }
                case 1: {
                    row = this.newGroupfoot(renderer);
                    break;
                }
                default: {
                    row = this.newRow(renderer);
                    break;
                }
            }
        } else {
            row = this.newRow(renderer);
        }
        row.setLoaded(false);
        this.newUnloadedCell(renderer, row);
        return row;
    }

    private org.zkoss.zul.Row newRow(RowRenderer renderer) {
        org.zkoss.zul.Row row = null;
        if (renderer instanceof RowRendererExt) {
            row = ((RowRendererExt)((Object)renderer)).newRow(this);
        }
        if (row == null) {
            row = new org.zkoss.zul.Row();
            row.applyProperties();
        }
        return row;
    }

    private Group newGroup(RowRenderer renderer) {
        Group group = null;
        if (renderer instanceof GroupRendererExt) {
            group = ((GroupRendererExt)((Object)renderer)).newGroup(this);
        }
        if (group == null) {
            group = new Group();
            group.applyProperties();
        }
        return group;
    }

    private Groupfoot newGroupfoot(RowRenderer renderer) {
        Groupfoot groupfoot = null;
        if (renderer instanceof GroupRendererExt) {
            groupfoot = ((GroupRendererExt)((Object)renderer)).newGroupfoot(this);
        }
        if (groupfoot == null) {
            groupfoot = new Groupfoot();
            groupfoot.applyProperties();
        }
        return groupfoot;
    }

    private Component newUnloadedCell(RowRenderer renderer, org.zkoss.zul.Row row) {
        Object cell = null;
        if (renderer instanceof RowRendererExt) {
            cell = ((RowRendererExt)((Object)renderer)).newCell(row);
        }
        if (cell == null) {
            cell = Grid.newRenderLabel(null);
            cell.applyProperties();
        }
        cell.setParent((Component)row);
        return cell;
    }

    private static Label newRenderLabel(String value) {
        Label label = new Label(value != null && value.length() > 0 ? value : " ");
        label.setPre(true);
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        if (this.inSpecialMold()) {
            this._engine.onInitRender();
        } else {
            Renderer renderer = new Renderer();
            try {
                int ofs;
                int pgsz;
                if (this.inPagingMold()) {
                    int cnt;
                    pgsz = this._pgi.getPageSize();
                    ofs = this._pgi.getActivePage() * pgsz;
                    if (ofs >= (cnt = this._rows.getChildren().size()) && (ofs = cnt - pgsz) < 0) {
                        ofs = 0;
                    }
                } else {
                    pgsz = 20;
                    ofs = 0;
                }
                ListIterator it = this._rows.getChildren().listIterator(ofs);
                for (int j = 0; j < pgsz && it.hasNext(); ++j) {
                    renderer.render((org.zkoss.zul.Row)it.next());
                }
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
            this.smartUpdate("z.render", true);
        }
    }

    private void onListDataChange(ListDataEvent event) {
        int newsz = this._model.getSize();
        int oldsz = this._rows.getChildren().size();
        int min = event.getIndex0();
        int max = event.getIndex1();
        switch (event.getType()) {
            case 1: {
                Component next;
                int cnt = newsz - oldsz;
                if (cnt <= 0) {
                    throw new UiException("Adding causes a smaller list?");
                }
                if (cnt > 50 && !this.inPagingMold()) {
                    this.invalidate();
                }
                if (min < 0) {
                    min = max < 0 ? 0 : max - cnt + 1;
                }
                if (min > oldsz) {
                    min = oldsz;
                }
                RowRenderer renderer = null;
                Component component = next = min < oldsz ? (Component)this._rows.getChildren().get(min) : null;
                while (--cnt >= 0) {
                    if (renderer == null) {
                        renderer = this.getRealRenderer();
                    }
                    this._rows.insertBefore((Component)this.newUnloadedRow(renderer, min++), next);
                }
                break;
            }
            case 2: {
                int cnt = oldsz - newsz;
                if (cnt <= 0) {
                    throw new UiException("Removal causes a larger list?");
                }
                if (min >= 0) {
                    max = min + cnt - 1;
                } else if (max < 0) {
                    max = cnt - 1;
                }
                if (max > oldsz - 1) {
                    max = oldsz - 1;
                }
                Component comp = (Component)this._rows.getChildren().get(max);
                while (--cnt >= 0) {
                    Component p = comp.getPreviousSibling();
                    comp.detach();
                    comp = p;
                }
                break;
            }
            default: {
                this.syncModel(min, max);
            }
        }
        this.postOnInitRender();
    }

    private static final RowRenderer getDefaultRowRenderer() {
        return _defRend;
    }

    private RowRenderer getRealRenderer() {
        return this._renderer != null ? this._renderer : Grid.getDefaultRowRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderRow(org.zkoss.zul.Row row) {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            renderer.render(row);
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public void renderRowApi(Row rowApi) {
        org.zkoss.zul.Row row = (org.zkoss.zul.Row)rowApi;
        this.renderRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAll() {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = this._rows.getChildren().iterator();
            while (it.hasNext()) {
                renderer.render((org.zkoss.zul.Row)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public void renderRows(Set rows) {
        this.renderItems(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set rows) {
        if (this._model == null) {
            if (log.debugable()) {
                log.debug("No model no render");
            }
            return;
        }
        if (rows.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                renderer.render((org.zkoss.zul.Row)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public String getOddRowSclass() {
        return this._scOddRow == null ? this.getZclass() + "-odd" : this._scOddRow;
    }

    public void setOddRowSclass(String scls) {
        if (scls != null && scls.length() == 0) {
            scls = null;
        }
        if (!Objects.equals((Object)this._scOddRow, (Object)scls)) {
            this._scOddRow = scls;
            this.smartUpdate("z.scOddRow", scls);
        }
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
            } else if (this.inSpecialMold() && this._engine == null) {
                this._engine = new GridDrawerEngine(this);
            }
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-grid" : this._zclass;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(80).append(super.getOuterAttrs());
        if (this._align != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"align", (String)this._align);
        }
        if (this._model != null) {
            Object rows;
            if (this.inPagingMold() && (rows = this.getRows()) != null && ((org.zkoss.zul.Rows)rows).hasGroup()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.hasgroup", (boolean)true);
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.model", (boolean)true);
            rows = this.getRows().getChildren();
            int index = rows.size();
            ListIterator it = rows.listIterator(index);
            while (it.hasPrevious() && !((org.zkoss.zul.Row)it.previous()).isLoaded()) {
                --index;
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.lastLoadIdx", (int)(!this.inSpecialMold() || rows.size() <= this._engine.getVisibleAmount() ? index : this._engine.getVisibleAmount()));
        }
        if (this.getOddRowSclass() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.scOddRow", (String)this.getOddRowSclass());
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.fixed", (boolean)this.isFixedLayout());
        if (this.inSpecialMold()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.cnt", (int)this.getRows().getChildren().size());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.cur", (int)this._engine.getCurpos());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.amt", (int)this._engine.getVisibleAmount());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.isrod", (boolean)true);
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.preload", (int)this.getPreloadSize());
        }
        if (this._vflex) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.vflex", (boolean)true);
        }
        return sb.toString();
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Rows) {
            if (this._rows != null && this._rows != newChild) {
                throw new UiException("Only one rows child is allowed: " + this + "\nNote: rows is created automatically if live data");
            }
        } else if (newChild instanceof Columns) {
            if (this._cols != null && this._cols != newChild) {
                throw new UiException("Only one columns child is allowed: " + this);
            }
        } else if (newChild instanceof org.zkoss.zul.Foot) {
            if (this._foot != null && this._foot != newChild) {
                throw new UiException("Only one foot child is allowed: " + this);
            }
        } else if (newChild instanceof org.zkoss.zul.Paging) {
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + this);
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
        } else if (!(newChild instanceof Auxhead)) {
            throw new UiException("Unsupported child for grid: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Rows) {
            if (super.insertBefore(newChild, refChild)) {
                this._rows = (org.zkoss.zul.Rows)newChild;
                this.invalidate();
                return true;
            }
        } else if (newChild instanceof Columns) {
            if (super.insertBefore(newChild, refChild)) {
                this._cols = (Columns)newChild;
                this.invalidate();
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Foot) {
            if (super.insertBefore(newChild, refChild)) {
                this._foot = (org.zkoss.zul.Foot)newChild;
                this.invalidate();
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Paging) {
            if (super.insertBefore(newChild, refChild)) {
                this._paging = (org.zkoss.zul.Paging)newChild;
                this._pgi = this._paging;
                this.invalidate();
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    public boolean removeChild(Component child) {
        if (this._paging == child && this._pgi == child && this.inPagingMold()) {
            throw new IllegalStateException("The paging component cannot be removed manually. It is removed automatically when changing the mold");
        }
        if (!super.removeChild(child)) {
            return false;
        }
        if (this._rows == child) {
            this._rows = null;
        } else if (this._cols == child) {
            this._cols = null;
        } else if (this._foot == child) {
            this._foot = null;
        } else if (this._paging == child) {
            this._paging = null;
            if (this._pgi == child) {
                this._pgi = null;
            }
        }
        this.invalidate();
        return true;
    }

    public Object clone() {
        Grid clone = (Grid)super.clone();
        clone.init();
        int cnt = 0;
        if (clone._rows != null) {
            ++cnt;
        }
        if (clone._cols != null) {
            ++cnt;
        }
        if (clone._foot != null) {
            ++cnt;
        }
        if (clone._paging != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof org.zkoss.zul.Rows) {
                this._rows = (org.zkoss.zul.Rows)child;
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Columns) {
                this._cols = (Columns)child;
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof org.zkoss.zul.Foot) {
                this._foot = (org.zkoss.zul.Foot)child;
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof org.zkoss.zul.Paging)) continue;
            this._paging = (org.zkoss.zul.Paging)child;
            this._pgi = this._paging;
            if (--cnt != 0) continue;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal(-1);
        if (this._model != null) {
            this.initDataListener();
        }
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        $assertionsDisabled = !Grid.class.desiredAssertionStatus();
        log = Log.lookup((Class)Grid.class);
        _defRend = new RowRenderer(){

            public void render(org.zkoss.zul.Row row, Object data) {
                Label label = Grid.newRenderLabel(Objects.toString((Object)data));
                label.applyProperties();
                label.setParent((Component)row);
                row.setValue(data);
            }
        };
    }

    private class Iter
    implements Iterator {
        private final ListIterator _it;

        private Iter() {
            this._it = Grid.this.getChildren().listIterator();
        }

        public boolean hasNext() {
            while (this._it.hasNext()) {
                Object o = this._it.next();
                if (!(o instanceof Columns) && !(o instanceof Auxhead)) continue;
                this._it.previous();
                return true;
            }
            return false;
        }

        public Object next() {
            Object o;
            while (!((o = this._it.next()) instanceof Columns) && !(o instanceof Auxhead)) {
            }
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements InnerWidth,
    RenderOnDemand,
    ChildChangedAware {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Grid.this);
        }

        public boolean isChildChangedAware() {
            return !Grid.this.isFixedLayout();
        }

        public void setInnerWidthByClient(String width) {
            Grid.this._innerWidth = width == null ? "100%" : width;
        }

        public void renderItems(Set items) {
            int cnt = items.size();
            if (cnt == 0) {
                return;
            }
            if ((cnt = 20 - cnt) > 0 && Grid.this._preloadsz > 0) {
                org.zkoss.zul.Row row;
                if (cnt > Grid.this._preloadsz) {
                    cnt = Grid.this._preloadsz;
                }
                LinkedList<org.zkoss.zul.Row> toload = new LinkedList<org.zkoss.zul.Row>();
                Iterator it = Grid.this.getRows().getChildren().iterator();
                while (it.hasNext() && !items.contains(row = (org.zkoss.zul.Row)it.next())) {
                    if (row.isLoaded()) continue;
                    toload.add(0, row);
                }
                if (!toload.isEmpty()) {
                    int bfcnt = cnt / 3;
                    Iterator e = toload.iterator();
                    while (bfcnt > 0 && e.hasNext()) {
                        items.add(e.next());
                        --bfcnt;
                        --cnt;
                    }
                }
                while (cnt > 0 && it.hasNext()) {
                    row = (org.zkoss.zul.Row)it.next();
                    if (row.isLoaded() || !items.add(row)) continue;
                    --cnt;
                }
            }
            Grid.this.renderItems(items);
        }
    }

    class Renderer {
        private final RowRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        Renderer() {
            this._renderer = Grid.this.getRealRenderer();
        }

        void render(org.zkoss.zul.Row row) throws Throwable {
            if (row.isLoaded()) {
                return;
            }
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            Component cell = row.getFirstChild();
            if (!(this._renderer instanceof RowRendererExt) || (((RowRendererExt)((Object)this._renderer)).getControls() & 1) != 0) {
                cell.detach();
            }
            try {
                this._renderer.render(row, Grid.this._model.getElementAt(row.getIndex()));
            }
            catch (Throwable ex) {
                try {
                    Label label = Grid.newRenderLabel(Exceptions.getMessage((Throwable)ex));
                    label.applyProperties();
                    label.setParent((Component)row);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                row.setLoaded(true);
                throw ex;
            }
            finally {
                if (row.getChildren().isEmpty()) {
                    cell.setParent((Component)row);
                }
            }
            row.setLoaded(true);
            this._rendered = true;
        }

        void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }
}

