/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.hibernate;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.lang.ThreadLocals;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;
import org.zkoss.zk.ui.util.ExecutionCleanup;
import org.zkoss.zk.ui.util.ExecutionInit;

public class HibernateSessionContextListener
implements ExecutionInit,
ExecutionCleanup,
EventThreadInit,
EventThreadResume {
    private static final Log log = Log.lookup((Class)HibernateSessionContextListener.class);
    private static final String HIBERNATE_SESSION_MAP = "org.zkoss.zkplus.hibernate.SessionMap";
    private static final Object SOMETHING = new Object();

    public void init(Execution exec, Execution parent) {
        if (parent == null) {
            HashMap<Object, Object> map = this.getSessionMap();
            if (map == null) {
                map = new HashMap<Object, Object>();
                this.setSessionMap(map);
            }
            exec.setAttribute(HIBERNATE_SESSION_MAP, map);
            map.put(SOMETHING, null);
        }
    }

    public void cleanup(Execution exec, Execution parent, Throwable ex) {
        Map map;
        if (parent == null && (map = this.getSessionMap()) != null) {
            map.remove(SOMETHING);
        }
    }

    public void prepare(Component comp, Event evt) {
    }

    public void init(Component comp, Event evt) {
        Map map = (Map)Executions.getCurrent().getAttribute(HIBERNATE_SESSION_MAP);
        this.setSessionMap(map);
    }

    public void beforeResume(Component comp, Event evt) {
    }

    public void afterResume(Component comp, Event evt) {
        Map map = (Map)Executions.getCurrent().getAttribute(HIBERNATE_SESSION_MAP);
        this.setSessionMap(map);
    }

    public void abortResume(Component comp, Event evt) {
    }

    private void setSessionMap(Map map) {
        this.getContextThreadLocal().set(map);
    }

    private Map getSessionMap() {
        return (Map)this.getContextThreadLocal().get();
    }

    private ThreadLocal getContextThreadLocal() {
        return ThreadLocals.getThreadLocal((String)"org.hibernate.context.ThreadLocalSessionContext", (String)"context");
    }
}

