/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.render;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.render.ComponentRenderer;
import org.zkoss.zk.ui.render.SmartWriter;
import org.zkoss.zkmax.zul.Tablechildren;
import org.zkoss.zkmax.zul.Tablelayout;

public class TablelayoutDefault
implements ComponentRenderer {
    private int _curRol;
    private int _curCol;
    private List _rowinfos;

    private void init() {
        if (this._rowinfos != null && this._rowinfos.size() > 0) {
            this._rowinfos.clear();
        } else {
            this._rowinfos = new LinkedList();
        }
        this._curRol = 0;
        this._curCol = 0;
    }

    public void render(Component comp, Writer out) throws IOException {
        this.init();
        SmartWriter wh = new SmartWriter(out);
        Tablelayout self = (Tablelayout)comp;
        List childern = self.getChildren();
        for (int i = 0; i < childern.size(); ++i) {
            this.updateCellIndex((Tablechildren)childern.get(i));
        }
        wh.write("<table id=\"").write(self.getUuid()).write("\"").write(self.getOuterAttrs()).write(self.getInnerAttrs()).write("> <tbody>");
        int from = 0;
        int to = 0;
        int count = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            count = this.getCellCount(i);
            to = from + count - 1;
            wh.write("<tr>");
            wh.writeChildren((Component)self, from, to);
            from = to + 1;
            wh.write("</tr>");
        }
        wh.write("</tbody></table>");
    }

    private int getRowCount() {
        return this._rowinfos.size();
    }

    private int getCellCount(int index) {
        return ((int[])this._rowinfos.get(index))[0];
    }

    private int[] getNextNonSpan(int columns, int colIndex, int rowIndex) {
        while (this._rowinfos.size() > 0 && colIndex >= columns - 1 || this._rowinfos.size() >= rowIndex + 1 && ((int[])this._rowinfos.get(rowIndex))[1] > colIndex + 1) {
            if (colIndex >= columns - 1) {
                ++rowIndex;
                colIndex = 0;
            } else {
                ++colIndex;
            }
            if (columns != 1) continue;
        }
        return new int[]{colIndex, rowIndex};
    }

    private void updateCellIndex(Tablechildren child) {
        int columns = ((Tablelayout)child.getParent()).getColumns();
        int[] index = this.getNextNonSpan(columns, this._curCol, this._curRol);
        this._curCol = index[0];
        for (int rowIndex = this._curRol = index[1]; rowIndex < this._curRol + (child.getRowspan() > 1 ? child.getRowspan() : 1); ++rowIndex) {
            if (this._rowinfos.size() <= rowIndex) {
                this._rowinfos.add(rowIndex, new int[]{0, 0});
            }
            int[] rowinfo = (int[])this._rowinfos.get(rowIndex);
            for (int colIndex = this._curCol; colIndex < this._curCol + (child.getColspan() > 1 ? child.getColspan() : 1); ++colIndex) {
                rowinfo[1] = rowinfo[1] + 1;
            }
        }
        int[] rowinfo = (int[])this._rowinfos.get(this._curRol);
        rowinfo[0] = rowinfo[0] + 1;
    }
}

