/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.xz.xz.index;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.vafer.jdeb.shaded.xz.xz.XZIOException;
import org.vafer.jdeb.shaded.xz.xz.common.EncoderUtil;
import org.vafer.jdeb.shaded.xz.xz.index.IndexBase;
import org.vafer.jdeb.shaded.xz.xz.index.IndexRecord;

public class IndexEncoder
extends IndexBase {
    private final ArrayList records = new ArrayList();

    public IndexEncoder() {
        super(new XZIOException("XZ Stream or its Index has grown too big"));
    }

    public void add(long l, long l2) throws XZIOException {
        super.add(l, l2);
        this.records.add(new IndexRecord(l, l2));
    }

    public void encode(OutputStream outputStream) throws IOException {
        CRC32 cRC32 = new CRC32();
        CheckedOutputStream checkedOutputStream = new CheckedOutputStream(outputStream, cRC32);
        checkedOutputStream.write(0);
        EncoderUtil.encodeVLI(checkedOutputStream, this.recordCount);
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            IndexRecord indexRecord = (IndexRecord)iterator.next();
            EncoderUtil.encodeVLI(checkedOutputStream, indexRecord.unpadded);
            EncoderUtil.encodeVLI(checkedOutputStream, indexRecord.uncompressed);
        }
        for (int i = this.getIndexPaddingSize(); i > 0; --i) {
            checkedOutputStream.write(0);
        }
        long l = cRC32.getValue();
        for (int i = 0; i < 4; ++i) {
            outputStream.write((byte)(l >>> i * 8));
        }
    }
}

