/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.variable;

import java.util.Map;
import org.unix4j.variable.VariableResolver;

public class MapVariableResolver
implements VariableResolver {
    private final Map<?, ?> nameToValue;

    public MapVariableResolver(Map<?, ?> nameToValue) {
        this.nameToValue = nameToValue;
    }

    public static MapVariableResolver getEnv() {
        return new MapVariableResolver(System.getenv());
    }

    public static MapVariableResolver getSystemProperties() {
        return new MapVariableResolver(System.getProperties());
    }

    public String getMapKeyForVariableName(String variableName) {
        if (variableName.startsWith("$")) {
            return variableName.substring(1);
        }
        return variableName;
    }

    @Override
    public Object getValue(String name) {
        String key = this.getMapKeyForVariableName(name);
        return this.nameToValue.get(key);
    }

    public String toString() {
        return this.nameToValue.toString();
    }
}

